	PAGE	,132
;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFCHR.ASM
	INCLUDE DEFMTR.ASM
.LIST

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS, DS:BIOS, SS:BIOS

	PUBLIC	CON_INPUT, CON_LOOK, CON_FLUSH, CON_OUTPUT, CON_IN_STAT
	PUBLIC	CF, Q_ZCON


	EXTRN	BIOS_CONFUNC:NEAR
	EXTRN	BUSY:NEAR
	EXTRN	SUCESS:NEAR
	EXTRN	NXT_CHAR:BYTE


;**	CON_INPUT - Input a number of characters at the transfer address
;
CON_INPUT PROC	NEAR
	MOV	CX,ES:CRW_CNT[BX]	; Get transfer count
	LES	DI,ES:CRW_TADDR[BX]	; Get transfer address
	CLD

CI2:
	PUSH	DI
	PUSH	CX
CI1:
	MOV	AH,CHR_READ		; Code for input character
	PUSH	CS
	CALL	NEAR PTR BIOS_CONFUNC
	JC	CI1			; If error, try again
	POP	CX
	POP	DI
	STOSB
	LOOP	CI2
	JMP	SUCESS

CON_INPUT ENDP

;**	CON_LOOK - Do a look ahead on the keyboard buffer
;
;	EXIT:	BUSY flag set if no character available
;		BUSY clear and char if a character available
;	
CON_LOOK PROC	NEAR

;	MOV	AL,NXT_CHAR		; See if look ahead has a character
;	OR	AL,AL
;	JNZ	CL1
	MOV	AH,CHR_LOOK		; Get ROM keyboard status
	PUSH	CS
	CALL	NEAR PTR BIOS_CONFUNC
	JC	BUSY			; No char., skip
;	OR	AX,AX			; Check for remnants of Ctrl-break
;	JNZ	CL0			; Nope, valid character
;	MOV	AH,KIO_READ		; Yep, eat this character
;	INT	KEYBOARD_IO_INTR
;	JMP	CON_LOOK		; Check for another
CL0:
CL1:
	MOV	ES:CIC_CHAR[BX],AL	; Pass character
	JMP	SUCESS

CON_LOOK ENDP


;**	CON_IN_STAT - Return input status
;		Return BUSY set if char avail
;
;	ENTRY:	DS=CS
;
;	EXIT:	BUSY set if character available
;		BUSY clear if no character
;
;	USES:	None
CON_IN_STAT PROC NEAR

;	MOV	AL,NXT_CHAR		; See if look ahead has a character
;	OR	AL,AL
;	JNZ	BUSY
	MOV	AH,CHR_STATUS		; Get status
	MOV	AL,CHR_SFGS		; Get status sub-function
	PUSH	CS
	CALL	NEAR PTR BIOS_CONFUNC
	TEST	AH,CHRS_RXR		; Check if char ready
	JZ	BUSY			; No char., return BUSY
	JMP	SUCESS			; Char. available, show it.

CON_IN_STAT ENDP


;**	CON_FLUSH - This routine will flush the console input buffer.
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	None
;
CON_FLUSH PROC NEAR

	MOV	AH,CHR_CONTROL
	MOV	AL,CHR_CFCI
	PUSH	CS
	CALL	NEAR PTR BIOS_CONFUNC
	JMP	SUCESS

CON_FLUSH ENDP

;	This routine does the actual flush of the console buffer
;	 This routine must save registers since it is called
;	 the disk I/O routine.
CF	PROC	NEAR
	MOV	NXT_CHAR,0		; Flush look ahead

	PUSH	AX			; Save registers (CON_FLUSH used in disk I/O)
	PUSH	ES

	MOV	AX,ROM_SEG		; Point to ROM segment
	MOV	ES,AX
	MOV	ES,ES:ROM_DATA_SEG	; Get location of data seg


	MOV	AX,ES:BUFFER_HEAD		; Get offset of beginning of buffer
	MOV	ES:BUFFER_TAIL,AX		; Get pointer to buffer head

	POP	ES			; Restore all registers
	POP	AX

	RET

CF	ENDP


;**	CON_OUTPUT - Print characters to the screen
;	
CON_OUTPUT PROC	NEAR

	CLD
	MOV	CX,ES:[BX+CRW_CNT]
	LDS	SI,ES:[BX+CRW_TADDR]	; Get the address of characters
CO1:
	LODSB
	MOV	AH,CHR_WRITE
	PUSH	CS
	CALL	NEAR PTR BIOS_CONFUNC
	LOOP	CO1
	JMP	SUCESS

CON_OUTPUT ENDP

Q_ZCON	DB	ZCON_IQS DUP (?)

BIOS	ENDS
	END
                                            
