;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE DEFDOSI.ASM
	INCLUDE DEFEVN.ASM
	INCLUDE DEFIPAGE.ASM
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFCHR.ASM
	INCLUDE DEFMTR.ASM
.LIST

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME CS:BIOS,DS:BIOS,SS:BIOS

	EXTRN EVN_FLG:WORD
	EXTRN BIOS_EXTRA:BYTE
	EXTRN CQ_ZCON:BYTE

PRINT_SCREEN_KEY	=	0E2H	; Shift F12, print screen key
PSC_SCAN_CODE		=	3700H	; Scan code for PrtSc key

	PUBLIC	KB_INT
	PUBLIC	KB_MTR
KB_MTR	DD	?
;	Interrupt routine for software interrupts

KB_INT:
	PUSH	AX			; Save registers
	OR	WORD PTR CS:EVN_FLG,EVN_KYB	; Flag keyboard event
	SUB	AH,AH			; Prepare for user interrupt
	INT	INT_UKBA		; Do user interrupt
	OR	AH,AH			; Test if user used char.
	POP	AX
	STC				; Assume char is scrapped
	JNZ	KB_LINK			; Link to ROM if user took char.

	CMP	AL,PRINT_SCREEN_KEY	; Is this a print screen?
	JZ	KB_INT0			; Yes, execute print screen
	CMP	AX,PSC_SCAN_CODE	; Is it PrtSc key?
	JNZ	KB_INT1			; No, skip print screen
KB_INT0:
	TEST	CS:BIOS_EXTRA[PRT_SCRN_FLAG],0FFH	; Yes, is one in progress?
	JNZ	KB_LINK			; Yes, can not do another
	MOV	CS:BIOS_EXTRA[PRT_SCRN_FLAG],0FFH	; Flag print screen in progress
	INT	INT_PRSCA		; and do it
	CLI				; Don't let interrupts through
	MOV	CS:BIOS_EXTRA[PRT_SCRN_FLAG],0	; Print screen done
	STC				; Eat prt scr key
	JMP	SHORT KB_LINK
KB_INT1:
	CLC				; Flag ROM to buffer char.
KB_LINK:
	JMP	DWORD PTR CS:KB_MTR
	
	

	PUBLIC	BIOS_CONFUNC

BIOS_CONFUNC	PROC	FAR

	CMP	AH,CHR_FMAX		; Check for valid request
	JBE	BCF1			; Good request, dispatch
	MOV	AX,CHRE_ILGFH		; Bad request, return error
	STC
	RET

;	Dispatch a valid request

BCF1:
	PUSH	DS			; Address data
	PUSH	CS
	POP	DS
	MOV	DI,AX			; Use request number as an index
	SUB	AL,AL
	XCHG	AL,AH
	SHL	AL,1
	XCHG	AX,DI
	CALL	WORD PTR BCF_TBL[DI]	; Dispatch request
	POP	DS			; Restore callers data segment
	RET				; Exit to caller

BIOS_CONFUNC	ENDP

BCF_TBL	LABEL	WORD
	DW	BCFFWR		; Write function
	DW	BCFFRD		; Read function
	DW	BCFFST		; Status function
	DW	BCFFCT		; Control function
	DW	BCFFLK		; Look ahead function

;	BCFFWR - Write a character
;
BCFFWR	PROC	NEAR

	SUB	AH,AH		; Prepare for user int
	INT	INT_UCRTA	; Let user see character
	OR	AH,AH		; Did user take it?
	JNZ	BCFFWR1		; Yes, skip
	CALL	MTR_SCRT	; Let the monitor do it
BCFFWR1:
	CLC			; Show good return
	RET

BCFFWR	ENDP


;	BCFFRD - Read a character
;
BCFFRD	PROC	NEAR

	MOV	AH,KIO_LOOK	; See if a character is there
	INT	KEYBOARD_IO_INTR
	JZ	NO_CHAR		; Jump if no character is available
	MOV	AH,KIO_READ	; Let MFM-150 get the char
	INT	KEYBOARD_IO_INTR
	CLC
	RET
NO_CHAR:
	MOV	AX,CHRE_RDNR	; Flag NOT READY
	STC			; Show error
	RET

BCFFRD	ENDP


;	BCFFST - Return status
BCFFST	PROC	NEAR

	CMP	AL,CHR_SFGC	; Is it the get config info subfunction?
	JZ	BCFFST2		; Jump if so
	SUB	BH,BH		; Prepare for standardized status
	MOV	AH,KIO_LOOK	; See if a char is available
	INT	KEYBOARD_IO_INTR
	JZ	BCFFST1		; No char, don't flag receiver ready
	OR	BH,CHRS_RXR	; Char available, show receiver ready
BCFFST1:
	OR	BH,CHRS_TXR	; Transmitter always ready
	MOV	AH,BH		; Put status in proper register
	XOR	AL,AL		; Show 0 for raw status
	PUSH	DI		; Save reg
	MOV	DI,OFFSET CQ_ZCON	; Get address of queue descriptor
	MOV	BH,BYTE PTR CQ_QSIZE[DI] ; Get queue size
	MOV	BL,BYTE PTR CQ_ELMTS[DI] ; Get number of elements
	POP	DI
	CLC			; Show good return
	RET

;	Return config info

BCFFST2:
	MOV	WORD PTR ES:[BX],0	; Return phony info
	CLC			; Show success
	RET

BCFFST	ENDP


;	BCFFCT - Control function
;
BCFFCT	PROC	NEAR

	CMP	AL,CHR_CFSU
	JNZ	BCFFCT5
	CLC
	RET
BCFFCT5:
	CMP	AL,CHR_CFCI	; Check for flush buffer request
	JNZ	BCFFCT6		; Not flush, check another
	PUSH	ES		; Save segment
	MOV	AX,ROM_SEG	; Address rom segment
	MOV	ES,AX
	MOV	ES,ES:ROM_DATA_SEG	; Get data segment

	CLI			; Flush the buffer
	MOV	AX,ES:BUFFER_HEAD
	MOV	ES:BUFFER_TAIL,AX
	STI
	POP	ES		; Restore seg

	ASSUME	DS:BIOS

	CLC			; Show good return
	RET
BCFFCT6:
	CLC
	RET

BCFFCT	ENDP


;	BCFFLK - Look ahead
;
BCFFLK	PROC	NEAR

	MOV	AH,KIO_LOOK		; See if the ROM has a character
	INT	KEYBOARD_IO_INTR
	JZ	BCFFLK1			; No, do error return
	CLC				; Yes, show good return
	RET
BCFFLK1:
	MOV	AX,CHRE_IQE		; Flag queue as empty
	STC				; Show error return
	RET

BCFFLK	ENDP

BIOS	ENDS
	END

