/***********************************************************************/
/*	findfrst.c                                                    */
/***********************************************************************/

/*  find first file matching the drive, path and filename */
findfrst(pname,attrib,filespec)
char *pname; /* ptr to string with drive, path and filename */
int attrib; /* file attribute to limit search to specific file types */
struct filedata *filespec; /* 43 byte area to return file specifications */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code;        /* return code for gdosint */
  unsigned saveseg; /* save current DTA segment address */
  unsigned saveoff;  /* save current DTA offset address  */
  int i;               /* temporary variables */
#ifdef LPTR
  unsigned j,k,hiword();                              
#endif
  i = getdta(&saveseg,&saveoff);  /* get current dta and save address */
  if ( i != 0 )  /* return if error */
     return(i);

#ifdef LPTR
 
  j = hiword(filespec);  /* get segment part of filespec address */
  k = (unsigned) filespec; /* get offset part of address */
  i = setdta(j,k);

#else

  ret_code = gdosint(0x00,&regs,&regs);
  i = setdta(regs.ds,filespec);

#endif

  if ( i != 0 )  /* return if error */
     return(i);

  regs.ch = 0;  /* clear hi byte of cx */
  regs.cl = attrib;  /* put attribute value in lo byte of cx */

#ifdef LPTR

  regs.ds = hiword(pname);                        /* get segment part of */
                  			          /* long address.       */
#else

  regs.ds=0;

#endif

  regs.dh = (unsigned) (pname) >> 8; /* put drive/path string address in dx */
  regs.dl = (unsigned) (pname) - (regs.dh << 8);
  regs.es=0;   /* default value for register */
  regs.ah=0x4E; /* DOS function number */
  ret_code = gdosint(0x21,&regs,&regs);
  if ( ret_code != 0 )  /* return if error */
     return(ret_code);
  i = setdta(saveseg,saveoff); /* restore dta */
    if ( i != 0 )  /* return if error */
       return(i);
    else
       return(0);
}
