/***********************************************************************/
/*	renamfil.c                                                    */
/***********************************************************************/
#ifdef _C86_BIG
#define LPTR 1
#endif

/*  Rename a file  */
renamfil(pnameold,pnamenew)
char *pnameold; /* ptr to full pathname of file to be renamed */
char *pnamenew; /* ptr to full pathname of new filename */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

#ifdef LPTR
			/* if big data models => get segment part of */
			/*     ASCII string address pointer          */
  regs.ds= hiword(pnameold);
  regs.es= hiword(pnamenew);

#else

  regs.ds=regs.es=0;		/* else => use default DS */

#endif

  regs.dh= (unsigned) (pnameold) >> 8;  /* pointer to old filename goes in dx */
  regs.dl= (unsigned) (pnameold) - (regs.dh << 8);
  regs.di= (unsigned) (pnamenew);  /* di contains pointer to new filename */
  regs.ah=0x56; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(ret_code);
}
