/***********************************************************************/
/*	execute.c                                                     */
/***********************************************************************/

/* execute another program from within a program */
execute(program,cmd_line)
char *program; /* name of program to execute */
char *cmd_line; /* parameters to pass to program on command line */
{
  extern unsigned _top; /* address of top of stack stored in XCMAIN (C.obj) */
  struct {          /* parameter block used in exec call */
    unsigned environment;  /* segment address of environment */
    unsigned cmd_off;      /* offset address of command line */
    unsigned cmd_seg;      /* segment address of command line */
    unsigned fcb1_off;     /* offset address of first file control block */
    unsigned fcb1_seg;     /* segment address of first file control block */
    unsigned fcb2_off;     /* offset address of second file control block */
    unsigned fcb2_seg;     /* segment address of second file control block */
  } block;

  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  unsigned pspseg;  /* segment address of program segment prefix  */
  unsigned size;    /* temporary variable used in shrinkm */
  unsigned *ptr;    /* temporary pointer used get pspseg             */
  int error;        /* temporary variable used in shrinkm call   */
  char line[129];   /* altered command line to be passed (in psp format) */
  int length;       /* temporary variable used in strlen     */

  error = shrinkm(&size);
  if ( error != 0 )  /* return if there was a problem in shrinking */ 
     return(-error); /* make return code negative to distinguish */
                         /* this return from the exec function return */

  int_no=0x00;  /* special call to gdosint to return current register values*/
  ret_code = gdosint(int_no,&regs,&regs);
  ptr = _top - 2; /* address of pspseg is first thing pushed onto stack by */
                 /* XCMAIN. Therefore, it can be found at _top - 2        */
  pspseg = *ptr;
  block.environment = 0;  /* pass environment of caller */
  block.fcb1_seg = pspseg;
  block.fcb1_off = 0x5C;     /* use default fcbs at offsets 5C & 6C in psp */
  block.fcb2_seg = pspseg;
  block.fcb2_off = 0x6C;

    
/* The first byte of the command line passed must contain the length of    */
/* the parameter string passed. This is the format that DOS uses when      */
/* placing the line at offset 80H in the Program Segment Prefix.           */

  length = strlen(cmd_line);  /* get length of command line passed */
  line[0] = (char) length;    /* put length in first byte of line  */
  line[1] = '\0';	      /* make line a string                */
  strcat(line,cmd_line); /* concatenate the passed line to the length */
  block.cmd_seg = regs.ds;    /* use default ds from gdosint call above */
  block.cmd_off = (unsigned) line;  /* offset of line in data segment */
  regs.bh = (unsigned) (&block) / 256;  /* bx register gets address of block */
  regs.bl = (unsigned) (&block) - (regs.bh * 256);
  regs.es = 0;     /* use default es register as segment for block */
  regs.dh = (unsigned) (program) / 256;  /* dx register gets address of program */
  regs.dl = (unsigned) (program) - (regs.dh * 256);
  regs.ds = 0;     /* use default ds register as segment for program */
  regs.al = 0;     /* EXEC call to load & run program with psp */
  regs.ah = 0x4B;  /* DOS function number for EXEC call */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(ret_code);
}

