/***********************************************************************/
/*	scroll.c                                                      */
/***********************************************************************/
scroll(num_lines,forgnd,bakrnd,up_row,up_col,low_row,low_col,dir)
         /* function to scroll a window on the screen */
int num_lines; /* the number of lines to scroll; 0 for all */
int forgnd; /* the forground color of the character to fill with */
int bakrnd; /* the background color of the character to fill with */
int up_row; /* the row of the upper left hand corner of the window */
int up_col; /* the column of the upper left hand corner */
int low_row; /* the row of the lower right hand corner of the window */
int low_col; /* the column of the lower right hand corner */
int dir; /* the direction to scroll; 0 for up, anything else for down */

{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */
  int mode; /* current mode setting */
  int num_cols; /* number of columns in active display */
  int active_page; /* current active page */  

  getscmod(&mode,&num_cols,&active_page); /* get current settings */
  if (up_col > num_cols || low_col > num_cols)
     return(-1);
     /* validate coordinates passed */
  if (num_lines > (low_row-up_row+1) || num_lines < 0 || up_row < 0 
     || up_col > 79 || low_row > 24 || low_col < 0 || (low_row - up_row) < 0
     || low_row < 0 || up_col < 0 || (low_col - up_col) < 0 
     || ((up_row == low_row)&&(num_lines != 0)) )
    return(-1);
  if (dir == 0)
    regs.ah=6;
  else
    regs.ah=7;
  regs.al=num_lines;
  if (forgnd < 16 ) /* set the attribute byte */
     regs.bh= ( bakrnd << 4 ) + forgnd; /* forgnd not blinking */
  else
     regs.bh= (( bakrnd << 4 ) + forgnd - 16) | 0x0080; /* forgnd blinking */
  regs.bl=0;
  regs.ch=up_row;
  regs.cl=up_col;
  regs.dh=low_row;
  regs.dl=low_col;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  int_no=0x10; /* video I/O interrupt */
  ret_code = gdosint(int_no,&regs,&regs);
  return(0);
}
