/***********************************************************************/
/*	strdate.c                                                     */
/***********************************************************************/

/* function to convert 3 integers to a specified date format */
strdate(out,year,month,day,convert)
char *out; /* output (target) string */
int year; /* year to be converted */
int month; /* month to be converted */
int day; /* day to be converted */
int convert; /*  conversion code to be used                          */
             /*      1 - yymmdd                                      */
             /*      2 - yyyymmdd                                    */
             /*      3 - mm/dd/yy                                    */
             /*      4 - mm-dd-yy                                    */
             /*      5 - mm..m dd, yy                                */
             /*      6 - mm..m dd, yyyy                              */
             /*      7 - mmm dd, yyyy                                */
             /*      8 - mmm dd, yy                                  */
             /*      9 - dd mmm yy                                   */
             /*     10 - dd mmm yyyy                                 */
             /*     11 - dd mm..m yy                                 */
             /*     12 - dd mm..m yyyy                               */
             /*  13-24 - precede format with day of the week         */
             /*  25-36 - precede format with day of the week abbrev. */
             /*  50-84 - see monthsfrom function                     */
             /* 98-128 - see quartersfrom function                   */
{
char ds[4]; /* day part of string */
char ys[6]; /* year part of string */
char ms[10]; /* month part of string */
char wkday[10]; /* day of the week string */
int k; /* stores day of the week */
char wkdate[50]; /* temp array */
char tempyear[5]; /* tempstring for year */
int n; /* original conversion code before alteration */
int j; /* temp variable */
/* for conversion codes 50 to 84 call monthsfrom function */
if((convert > 49) && (convert < 85))
  {
  k = monthsfrom(out,year,month,day,0,convert);
  if(k != 0) return(k);
  return(0);
  }
/* for conversion codes 98 to 128 call quartersfrom function */
if((convert > 97)&&(convert < 129))
  {
  k = quartersfrom(out,year,month,day,0,convert);
  return(k);
  }
/* check that conversion code is valid */
if((convert > 36) || (convert < 1)) return(-1);
/* reduce conversion code to be one of the 12 basic formats */
n = convert;
if((convert > 12) && (convert < 25)) convert = convert - 12;
if(convert > 24) convert = convert - 24;
/* check that this is a valid date */
k = dayofweek(year,month,day);
if(k == 0) return(-2);
/* convert day */
j = stci_d(&ds[0],day,4);
if(j == 1)
  {
  ds[2] = '\0';
  ds[1] = ds[0];
  ds[0] = '0';
  }
/* convert month */
if(convert < 5)
  {
  j = stci_d(&ms[0],month,10);
  if(j == 1)
    {
    ms[2] = '\0';
    ms[1] = ms[0];
    ms[0] = '0';
    }
  }
  else if(month == 1) strcpy(&ms[0],"January");
    else if(month == 2) strcpy(&ms[0],"February");
      else if(month == 3) strcpy(&ms[0],"March");
        else if(month == 4) strcpy(&ms[0],"April");
          else if(month == 5) strcpy(&ms[0],"May");
            else if(month == 6) strcpy(&ms[0],"June");
              else if(month == 7) strcpy(&ms[0],"July");
                else if(month == 8) strcpy(&ms[0],"August");
                  else if(month == 9) strcpy(&ms[0],"September");
                    else if(month == 10) strcpy(&ms[0],"October");
                      else if(month == 11) strcpy(&ms[0],"November");
                        else strcpy(&ms[0],"December");
if((convert < 11) && (convert > 6)) ms[3] = '\0';
/* convert year */
j = stci_d(&ys[0],year,6);
if(j == 2)
  {
  if((convert == 2)||(convert == 7)||(convert == 10)||(convert == 12)
    ||(convert == 6))
    {
    tempyear[0] = '\0';
    strcat(tempyear,"19");
    strcat(tempyear,ys);
    strcpy(&ys[0],&tempyear[0]);
    }
  }
  else
  {
  if((convert == 1)||((convert > 2)&&(convert < 6))||(convert == 8)
    ||(convert == 9)||(convert == 11))
    {
    for(j = 0; j < 3; ++j)
      {
      ys[j] = ys[j + 2];
      }
    }
  }
/* put day, month, year together */
out[0] = '\0';
if(convert < 3)
  {
  strcat(out,&ys[0]);
  strcat(out,&ms[0]);
  strcat(out,&ds[0]);
  }
  else
  {
  if(convert < 5)
    {
    strcat(out,&ms[0]);
    if(convert == 3) strcat(out,"/");
      else strcat(out,"-");
    strcat(out,&ds[0]);
    if(convert == 3) strcat(out,"/");
      else strcat(out,"-");
    strcat(out,&ys[0]);
    }
    else
    {
    if(ds[0] == '0')
      {
      ds[0] = ds[1];
      ds[1] = '\0';
      }
    if(convert < 9)
      {
      strcat(out,&ms[0]);
      strcat(out," ");
      strcat(out,&ds[0]);
      strcat(out,",");
      strcat(out," ");
      strcat(out,&ys[0]);
      }
      else
      {
      strcat(out,&ds[0]);
      strcat(out," ");
      strcat(out,&ms[0]);
      strcat(out," ");
      strcat(out,&ys[0]);
      }
    }
  }
if((n > 12) && (n < 25))
  {
  if(k == 1) strcpy(wkday,"Monday ");
  if(k == 2) strcpy(wkday,"Tuesday ");
  if(k == 3) strcpy(wkday,"Wednesday ");
  if(k == 4) strcpy(wkday,"Thursday ");
  if(k == 5) strcpy(wkday,"Friday ");
  if(k == 6) strcpy(wkday,"Saturday ");
  if(k == 7) strcpy(wkday,"Sunday ");
  }
if(n > 24)
  {
  if(k == 1) strcpy(wkday,"Mon ");
  if(k == 2) strcpy(wkday,"Tue ");
  if(k == 3) strcpy(wkday,"Wed ");
  if(k == 4) strcpy(wkday,"Thu ");
  if(k == 5) strcpy(wkday,"Fri ");
  if(k == 6) strcpy(wkday,"Sat ");
  if(k == 7) strcpy(wkday,"Sun ");
  }
if(n > 12)
  {
  wkdate[0] = '\0';
  strcat(wkdate,wkday);
  strcat(wkdate,out);
  strcpy(out,wkdate);
  }
return(0);
}
