/*******
                             welcome.c

		Demo program to show use of several screen functions provided
	with the Eco-C compiler for the 8088. All functions assume that
	the ANSI.SYS device driver is active.

	To run with a color monitor, use:

			a>WELCOME C

	Leaving off the 'C' in the command line cancels the color com-
	mands.

*******/

#include "COLOR.H"                     /* for symbolic constants */

static char *m[] = {
		"Welcome to the Eco-C 8088 C Compiler",
		"Press any key to continue:",
		"The screen functions mentioned in the addenda",
		"allows you to do things with the PC in color.",
		"You can color things",
		"Make them high intensity",
		"Change foreground and background colors",
		"Make them blink",
		"Give it a try!"
	};

/* 
		To use the color attribute functions sascr() and mascr() a global
variable named _colorflag, which is an int, must be set to logic True for
these two functions to work. See below.

*/
  
main(argc, argv)
int argc;
char **argv;
{
	if (argc > 1)								/* Assumes program was loaded */
		_colorflag = 1;							/*	with two command line args.*/
                                       /*  If only 1 arg, no color   */
	screen_one();
	screen_two();

}

screen_one()
{

	clrscr();
	sascr(FYELLOW);
	box(WIDE-2, 22, 3, 1);
	mascr(3, BRED, FWHITE, BOLD);
	center(1, m[0]);
	sascr(OFF);
	sascr(FYELLOW);
	center(5, m[2]);
	center(6, m[3]);	
	center(9, m[4]);
	center(11, m[5]);
	center(13, m[6]);
	center(15, m[7]);
	center(23, m[1]);
	sascr(OFF);
	getch();                            /* No RETURN needed */
}


screen_two()
{
	sascr(OFF);
	mascr(2, FBLUE, BCYAN);
	center(9, m[4]);
	delay();
	mascr(2, BOLD, FYELLOW);
	center(11, m[5]);
	delay();
	mascr(2, BWHITE, FBLUE);
	center(13, m[6]);
	delay();
	mascr(2, BLINK, FRED);
	center(15, m[7]);
	sascr(OFF);
	delay();
	sascr(FYELLOW);
	center(18, m[8]);
	center(23, m[1]);
	sascr(OFF);
	getch();                            /* No RETURN needed */

}

void delay()
{
	unsigned i = 0;

	while (i < 30000)
		++i;
}
