;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
	PAGE	,132
	TITLE	BBLKDEV - BIOS block devices

;
;	MIN_SEC is the largest sector -1 that date/time will be updated
;	on when read/written. Setting it to 8 insures that when any
;	FAT is updated, so will the time. The highest FAT sector address
;	is on single density 8 inch disks, sector 4.
;

MIN_SEC	EQU	8	; Highest sector to update date/time on
MAX_DSKVAL =	2*100	; 2.0 second delay on disk changes

	.LFCOND
	.TFCOND		; /X to cause FALSE conds not to be listed

;
;  BIOS block device driver interface for MS-DOS 2.0
;
;  10/7/82 - bcb
;

INCLUDE	PARMS.ASM

    IF1
	%OUT	*Pass 1 started*
    ELSE
	%OUT	*Pass 2 started*
    ENDIF

    IF LISTI
	IF1
	%OUT	*Full listing beging generated*
	ENDIF
    ELSE
	IF1
	%OUT	*Include files are not part of listing*
	ENDIF
	.XLIST
    ENDIF

	INCLUDE	DEFDEV.ASM
	INCLUDE	DEFDSK.ASM
	INCLUDE	DEFZ207.ASM
	INCLUDE	MACLIB.ASM
	INCLUDE	DEFFMT.ASM
	INCLUDE	DEFSBC.ASM

	.LIST
	PAGE

BIOS_SEG SEGMENT BYTE PUBLIC 'BIOSCODE'

	PUBLIC	DSK0_INIT
	PUBLIC	DSK0_MCHK
	PUBLIC	DSK0_MCHK1	; Alternate entry for PBE_DSKCHG
	PUBLIC	DSK0_BPB
	PUBLIC	DSK0_IN
	PUBLIC	DSK0_OUT
	PUBLIC	DSK0_OUTV
	PUBLIC	WRTVER
	PUBLIC	DSKPR
	PUBLIC	BPBVEC		; Vector to BPB tables

	EXTRN	EXIT_SUCC:NEAR
	EXTRN	EXIT_BUS:NEAR
	EXTRN	EXIT_ERR:NEAR

	EXTRN	RECURLV:WORD
	EXTRN	SAVESS:WORD
	EXTRN	SAVESP:WORD
	EXTRN	BIOS_STACK:BYTE
	EXTRN	BIOS_START:NEAR
	EXTRN	BIOS_DATE:BYTE

	EXTRN	DSKT_FG:BYTE
	EXTRN	DSK_LDRIVE:WORD
	EXTRN	DSK_TPTR:BYTE
	EXTRN	DSK:NEAR
	EXTRN	PTRSAV:DWORD
	EXTRN	ASSNFLG:BYTE
	EXTRN	TIM_FLG:BYTE
	EXTRN	DSK_BUF:BYTE

	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

;
; Disk init
;

DSK0_INIT:
	MOV	CIN_UNITS[BX],MAXDSKW	; Store number of units
	MOV	WORD PTR CIN_BADDR[BX],OFFSET BPBVEC ; Store BPB vector addr
	MOV	WORD PTR CIN_BADDR+2[BX],CS
	JMP	EXIT_SUCC	; Join common code

;
; Disk media check
;

DSK0_MCHK:
	CALL	DSK0_MCHK1		; Do hard part
	JNC	DSK0_MCHK0		; If no error
	JMP	EXIT_ERR		; If error
DSK0_MCHK0:
	JMP	EXIT_SUCC		; If ok

;	Alternate entry point with simple RET

DSK0_MCHK1:
	MOV	CMC_STAT[BX],CMCS_DKN ; Show don't know if media changed
	MOV	AL,SRH_UNIT[BX]		; AL = unit number
	CMP	AL,MAXDSK8		; Winchester drive?
	JC	DSK0_MCHK1A		; If not

;	See if drive is assigned at all

	CBW				; AX = drive letter
	LEA	DI,DSK_TPTR		; DI = disk table pointer
	SHL	AX,1
	ADD	DI,AX
	SHR	AX,1
	MOV	DI,CS:WORD PTR [DI]	; DI = pointer to table
	TEST	CS:BYTE PTR [DI+DSK_FLAG],DSK_ASN
	JZ	DSK0_MCKNR		; If not, not ready error!
	TEST	CS:BYTE PTR [DI+DSK_SEL],SBAEFLNF
	JNZ	DSK0_MCKNR		; Assigned but not formatted!

;	Is assigned, see if first access since the assign

	SUB	AX,MAXDSK8		; E:=0, F:=1, ..
	MOV	CL,AL
	MOV	AL,1
	SHL	AL,CL
	TEST	CS:BYTE PTR ASSNFLG,AL	; 'NZ' set if drive changed
	JNZ	DSK0_MWCHNG		; If winchester changed

;	See if formatted recently

	TEST	CS:BYTE PTR [DI+DSK_FLAG],DSK_FDC
	PUSHF				; Save status
	AND	CS:BYTE PTR [DI+DSK_FLAG],NOT DSK_FDC
	POPF				; DSK_FDC off, restore flags
	JNZ	DSK0_MWCHNG		; Yep, show the change

;	Not first access, no change in media

	MOV	CMC_STAT[BX],CMCS_NOC ; Show don't know if media changed
	JMP	NEAR PTR DSK0_MCK1	; If not, don't do anything

;	Drive returns as not ready?

DSK0_MCKNR:
	MOV	AL,SRHS_EDNR		; Show drive not ready
	STC
	RET

;	Media changed, flag it

DSK0_MWCHNG:
	MOV	CMC_STAT[BX],CMCS_CHG	; Flag the change
	NOT	AL			; Make a zero mask
	AND	CS:BYTE PTR ASSNFLG,AL
	MOV	AL,SRH_UNIT[BX]
	CBW
	SHL	AX,1			; AX = index into BPB table
	MOV	SI,AX
	ADD	SI,OFFSET BPBVEC	; SI = pointer to pointer
	MOV	SI,CS:[SI]			; SI = pointer to table
	XOR	CS:BYTE PTR BPB_MBYTE[SI],1
	JMP	NEAR PTR DSK0_MCK1	; done

DSK0_MCHK1A:
	CBW
	SHL	AX,1			; Make into word offset
	MOV	DI,AX
	MOV	DI,CS:WORD PTR DSK_TPTR[DI]	; Get disk table pointer

;	See if same drive as last time

	PUSHF
	CLI
	TEST	CS:BYTE PTR DSK_FLAG[DI],DSK_FDC	; Force change?
	PUSHF
	AND	CS:BYTE PTR DSK_FLAG[DI],NOT DSK_FDC	; Turn it off!
	POPF					; Restore test value
	JNZ	DSK0_MCHK1B			; Yes
	CMP	CS:WORD PTR DSK_TIMOUT[DI],MAX_DSKVAL	; Drive ok?
	PUSHF
	MOV	CS:WORD PTR DSK_TIMOUT[DI],0	; Reset it.
	POPF
	JNC	DSK0_MCHK1B			; Nope

;	Drive acessed within MAX_DSKVAL tics, is ok

	MOV	CMC_STAT[BX],CMCS_NOC ; Show no media changed
	POPF
	JMP	DSK0_MCK1

DSK0_MCHK1B:
	POPF

;	Check status of drive

	MOV	AL,BYTE PTR SRH_UNIT[BX]	; Get unit number
	MOV	CS:DSKPR+DSKPR_DRIVE,AL		; Set it in
	PUSH	DS
	PUSH	BX
	PUSH	DI			; Save current pointers
	MOV	BX,CS
	MOV	ES,BX
	MOV	DS,BX
	MOV	BX,OFFSET DSKPR		; ES:BX pointer to dskpr
	MOV	AL,DSK_STATUS		; Get status
	CALL	DSK			; Call it
	POP	DI
	POP	BX
	POP	DS			; AH = status, 'CY' if not ready
	JC	DSK0_MCKNR		; Drive is not ready

	CMP	BYTE PTR SRH_UNIT[BX],MAXDSK5	; < 2 if 5" drive
	JNC	DSK0_MCK0		; If not, must be 8s
	JMP	NEAR PTR DSK0_MCK1	; Was < 2, 5"

;	Is an 8" drive, find density

DSK0_MCK0:
	AND	CS:BYTE PTR DSK_SEL[DI],NOT CONSD	; Double density
	OR	CS:BYTE PTR DSK_FLAG[DI],DSK_FDS	; Double sided
	MOV	CS:WORD PTR DSK_BPS[DI],1024	; 1k sectors
	MOV	CS:WORD PTR DSK_BPWT[DI],10729	; track size
	MOV	CS:WORD PTR DSK_BPRT[DI],10729
	MOV	CS:BYTE PTR DSK_SPT[DI],8	; 8 sectors/track

;	Now see if single or double sided

	TEST	AH,AS2S			; Double sided?
	JZ	DSK0_MCKSS		; No, is single sided
	MOV	SI,OFFSET BPB2		; Is 8", use other table
	JMP	SHORT DSK0_BPB2J

;	8" drive is single sided

DSK0_MCKSS:
	OR	CS:BYTE PTR DSK_SEL[DI],CONSD	; Show single density
	AND	CS:BYTE PTR DSK_FLAG[DI],0FFH-DSK_FDS
	MOV	CS:WORD PTR DSK_BPS[DI],128
	MOV	CS:WORD PTR DSK_BPWT[DI],5365
	MOV	CS:WORD PTR DSK_BPRT[DI],5365
	MOV	CS:BYTE PTR DSK_SPT[DI],26

;	Now see which BPB table to use, ours or theirs

	MOV	AX,1
	CALL	GETSEC
	CMP	CS:BYTE PTR DSK_BUF,0FEH	; Their fat id?
	MOV	SI,OFFSET BPB4		; Assume our table
	JNZ	DSK0_BPB2J
	MOV	SI,OFFSET BPB4C
DSK0_BPB2J:
	MOV	CS:WORD PTR BPB_8IN,SI	; Save it for BPB call
DSK0_MCK1:
	CLC
	RET

BPB_8IN	DW	?			; Pointer to 8" BPB table

;
; Get BPB
;

DSK0_BPB:

;	compute SI as pointer to proper BPB

	MOV	AL,SRH_UNIT[BX]		; AL = unit number
	CBW
	SHL	AX,1			; Make into word offset
	MOV	DI,AX
	MOV	DI,CS:WORD PTR DSK_TPTR[DI]	; Get disk table pointer

	CMP	BYTE PTR SRH_UNIT[BX],MAXDSK5	; < 2 if 5" drive
	JNC	DSK0_BPB0		; If not, must be 8s
	JMP	NEAR PTR DSK0_BPB1	; Was < 2, 5"

;	Drive is an 8 " drive or winchester

DSK0_BPB0:
	CMP	BYTE PTR SRH_UNIT[BX],MAXDSK8
	JC	DSK0_8IN		; Is an 8" disk

	MOV	SI,OFFSET BPB6
	MOV	AL,BYTE PTR SRH_UNIT[BX]
	SUB	AL,MAXDSK8
	CBW
	MOV	CL,SIZE BPB_STRUC
	MUL	CL			; AX = AL * CL
	ADD	SI,AX
	JMP	NEAR PTR DSK0_BPB2

;	Is an 8" drive

DSK0_8IN:
	MOV	SI,CS:WORD PTR BPB_8IN
	JMP	NEAR PTR DSK0_BPB2

;	Drive is a 5" drive, see if large or small drive

DSK0_BPB1:

;	Assume 48 tpi double sided

	OR	CS:BYTE PTR DSK_FLAG[DI],DSK_FDS	; Is double sided
	AND	CS:BYTE PTR DSK_FLAG[DI],0FFH-DSK_FDP-DSK_FWP
	MOV	CS:BYTE PTR DSK_MAXT[DI],40	;show 40 tracks
	MOV	CS:BYTE PTR DSK_SPT[DI],8		; Show another sector

;	Now check FATID and see if our guess was correct

	PUSH	BX
	LES	BX,CRW_TADDR[BX]	; ES:BX points to FAT in ram
	MOV	AL,ES:BYTE PTR [BX]
	POP	BX
	MOV	CS:BYTE PTR FATID,AL	; Save it here
	OR	AL,FMT_EDFLG		; Or in the OLD FORMAT bit
	CMP	AL,FMT_F48D		; FATID for double sided 48tpi
	MOV	SI,OFFSET BPB1		; Assume so
	JZ	DSK0_BPB1A		; It was, were ok
	MOV	SI,OFFSET BPB0		; Show other table
	AND	CS:BYTE PTR DSK_FLAG[DI],0FFH-DSK_FDS	; double sided off
	CMP	AL,FMT_F48S		; Try 48tpi single
	JZ	DSK0_BPB1A		; Was

;	Must be 96tpi double sided

	OR	CS:BYTE PTR DSK_FLAG[DI],DSK_FDS
	MOV	CS:BYTE PTR DSK_MAXT[DI],80	;show 80 tracks
	MOV	SI,OFFSET BPB3
DSK0_BPB2J1:
	JMP	SHORT DSK0_BPB2A

;	Was 48tpi, see if to double step

DSK0_BPB1A:
	MOV	DX,CS:WORD PTR DSK_PORT[DI]	; DX = port number
	ADD	DX,FDAS
	IN	AL,DX			; Get aux stat
	TEST	AL,AS96T		; 96tpi drives?
	JZ	DSK0_BPB2A		; Nope, am ok

;	Was 96tpi drives, show double step and write protect

	OR	CS:BYTE PTR DSK_FLAG[DI],DSK_FDP+DSK_FWP

;	Now check if old or new format

DSK0_BPB2A:
	TEST	BYTE PTR CS:FATID,FMT_EDFLG	; See if already set
	JNZ	DSK0_BPB2			; If so, no more
	ADD	SI,SIZE BPB_STRUC		; Other BPB table
	MOV	CS:BYTE PTR DSK_SPT[DI],9		; Show another sector

;	Save pointer to BPB from SI into packet

DSK0_BPB2:
	MOV	WORD PTR CBPB_BADDR[BX],SI	; Store BPB addr
	MOV	WORD PTR CBPB_BADDR+2[BX],CS
	JMP	EXIT_SUCC			; Join common code

;
; Disk read
;

DSK0_IN:
	MOV	CS:BYTE PTR WRTVER,0
	MOV	AH,DSK_READ	; Get read function
	JMP	SHORT DSK0_RDWR	; Join common code
	
FIRST_SEC	DW	0	; Starting sector for transfer
WRTVER		DB	0	; != 0 if write / verify

;
; Disk write, write w/verify
;

DSK0_OUTV:
	MOV	CS:BYTE PTR WRTVER,1	; Flag to verify
	MOV	AH,DSK_WRITE	; Function code
	JMP	SHORT DSK0_RDWR	; Read/write it

DSK0_OUT:
	MOV	AH,DSK_WRITE	; Get write function
	MOV	CS:BYTE PTR WRTVER,0
;	JMP	SHORT DSK_RDWR	; Join common code

;
; Common read/write code
;

DSK0_RDWR:
	MOV	CX,CRW_CNT[BX]	; Get sector count
	MOV	DX,CRW_START[BX] ; Get starting sector
	MOV	CS:FIRST_SEC,DX	; Save for later
	
	PUSH	CX
	PUSH	DX		; Save in case to verify

	CALL	DSK0_BDT	; Build packet, DS setup
	MOV	AL,AH		; Get function
	PUSHF			; Save interrupt status
	STI			; Turn on interrupts
	CALL	DSK		; Perform function, did error occur ?
	LAHF			; Save flags
	POPF			; Restore interrupt status
	SAHF			; Restore flags
	PUSHF			; Save results

;	Back information into the request packet

	MOV	CX,WORD PTR DSKPR+DSKPR_COUNT ; Get remaining sectors
	LDS	BX,CS:PTRSAV	; Get packet addr
	SUB	CRW_CNT[BX],CX	; Compute number of sectors written
	MOV	DX,CS:WORD PTR DSKPR+DSKPR_BUFF
	MOV	WORD PTR CRW_TADDR[BX],DX
	MOV	DX,CS:WORD PTR DSKPR+DSKPR_SECTOR
	MOV	CRW_START[BX],DX

	POPF
	POP	DX
	POP	CX

	JC	DSK0_RWE	; Jump if errors

;	No errors here, see about verifying

	TEST	CS:BYTE PTR WRTVER,0FFH
	JZ	NOVERIFY	; Nope

;	Must verify, build another DPT

	CALL	DSK0_BDT
	MOV	AL,DSK_VERIFY	; Get function
	PUSHF			; Save interrupt status
	STI			; Turn on interrupts
	CALL	DSK		; Perform function, did error occur ?
	LAHF			; Save flags
	POPF			; Restore interrupt status
	SAHF			; Restore flags
	LDS	BX,CS:PTRSAV	; Get packet addr
	JC	DSK0_RWE

;	No errors, see if to update time values

NOVERIFY:
	CMP	CS:FIRST_SEC,MIN_SEC	; In range?
	JNC	NO_UPDT			; Yes, update the timer
	TEST	CS:BYTE PTR TIM_FLG,0FFH
	JZ	NO_UPDT			; Not time yet
	MOV	CS:BYTE PTR TIM_FLG,0
	CALL	UPDT_TIME		; All set, (we hope?!?)
NO_UPDT:
	JMP	EXIT_SUCC	; Join common code

DSK0_RWE:
	MOV	SI,-1		; Start with entry -1
DSK0_EL:
	INC	SI		; Bump to next
	MOV	AH,CS:BYTE PTR DSK0_ERRB[SI] ; Get error code
	CMP	AH,0FFH		; At end of table ?
	JE	DSK0_EFI	;   Yes, get out
	TEST	AL,AH		; Do any bits match ?
	JZ	DSK0_EL		;   No, try again
DSK0_EFI:
	MOV	AL,CS:BYTE PTR DSK0_ERRC[SI] ; Get error code
	LDS	BX,CS:PTRSAV	; Get packet addr
	JMP	EXIT_ERR	; Join common code

;*	UPDT_TIME - Update disk timer
;
;	Updates the date/time in the loader on disk x
;

UPDT_TIME:
	XOR	AX,AX
	CALL	GETSEC
	JC	UPDT_TIM1	; If error, ignore
	CMP	CS:BYTE PTR DSK_BUF+FMT_OFFSET+FMT_VER,2
	JNZ	UPDT_TIM1	; Loader not proper version

	PUSH	DS
	PUSH	ES

	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX

	MOV	SI,OFFSET BIOS_DATE
	MOV	DI,OFFSET DSK_BUF+FMT_DATE+FMT_OFFSET
	MOV	CX,7		; Prepare to move in the proper time

	PUSHF
	CLD
	REP	MOVSB		; move it in
	POPF

	POP	ES
	POP	DS

	XOR	AX,AX
	CALL	PUTSEC		; re-write the new loader sector
UPDT_TIM1:
	RET

;*	GETSEC - Read sector into DSK_BUF
;

GETSEC:
	MOV	CX,1
	MOV	DX,AX		; sector 0, 1 sector
	CALL	DSK0_BDT	; Build disk table

	MOV	WORD PTR DSKPR+DSKPR_BUFF,OFFSET DSK_BUF
	MOV	WORD PTR DSKPR+DSKPR_BUFF+2,CS
	MOV	AL,DSK_READ
	CALL	DSK

	LDS	BX,CS:PTRSAV
	RET

;*	PUTSEC - Write sector
;

PUTSEC:
	MOV	CX,1
	MOV	DX,AX
	CALL	DSK0_BDT

	MOV	WORD PTR DSKPR+DSKPR_BUFF,OFFSET DSK_BUF
	MOV	WORD PTR DSKPR+DSKPR_BUFF+2,CS
	MOV	AL,DSK_WRITE
	CALL	DSK

	LDS	BX,CS:PTRSAV
	RET

;*	DSK0_BDT - Build DSKPR Packet
;

DSK0_BDT:
	MOV	AL,SRH_UNIT[BX]	; Get unit
	PUSH	DS		; Save segment of packet
	MOV	DI,CS		; Set up DS
	MOV	DS,DI
	MOV	BYTE PTR DSKPR+DSKPR_DRIVE,AL ; Store drive number
	MOV	WORD PTR DSKPR+DSKPR_SECTOR,DX ; Store starting sector
	MOV	WORD PTR DSKPR+DSKPR_COUNT,CX ; Store sector count
	POP	ES
	LES	BX,ES:CRW_TADDR[BX] ; Get transfer addr
	MOV	WORD PTR DSKPR+DSKPR_BUFF,BX ; Store transfer addr
	MOV	WORD PTR DSKPR+DSKPR_BUFF+2,ES
	MOV	ES,DI		; Set up ES:BX
	MOV	BX,OFFSET DSKPR	;  as pointer to packet
	RET

;*	DSK0_ERRx - Error generation tables
;

DSK0_ERRB:
	DB	FDSWPV		; Write protect
	DB	FDSNRD		; Not ready
	DB	FDSCRC+FDSLDT	; CRC error and Lost data
	DB	FDSSEK		; Seek error
	DB	0
	DB	FDSWTF		; Write fault
	DB	-1

DSK0_ERRC:
	DB	SRHS_EWPR	; Write protect
	DB	SRHS_EDNR	; Drive not ready
	DB	SRHS_ECRC	; CRC error
	DB	SRHS_ESEEK	; Seek error
	DB	SRHS_ESNF	; Sector not found
	DB	SRHS_EWRF	; Write fault
	DB	SRHS_EGNF	; General failure

;*	BPB Vector table
;
;	1 entry per unit, the largest entry for each unit
;

BPBVEC:
    REPT MAXDSK5
	DW	BPB3E			; Drive A: 96/ds extended
    ENDM

    REPT MAXDSK8-MAXDSK5
	DW	BPB2			; Drive E: ds/dd
    ENDM

;	Note: The following MUST BE IN ORDER

	DW	BPB6			; Drive i: winchester
	DW	BPB7			; Drive j: winchester
	DW	BPB8			; Drive k: winchester
	DW	BPB9			; Drive l: winchester

;*	BPB tables
;
;	These tables define the actual formats for the different
;	disk types. The maximum format allowed is in BPBVEC for
;	each unit, but at BUILD BPB time we point to the actual
;	BPB that we want the DOS to use
;
;
;	NOTE: The tables that end in E (such as BPB0E) MUST immediately
;	follow the same tables that do not end in E (BPB0 in the above
;	example) - Much of the code assumes that the E table is directly
;	after the normal table.
;


;	BPB for 48tpi ss disks

BPB0	LABEL	NEAR
	ERRNZ	BPB0,BPB_SECSZ
	DW	512
	ERRNZ	BPB0,BPB_SPAU
	DB	1
	ERRNZ	BPB0,BPB_RES
	DW	1
	ERRNZ	BPB0,BPB_NFATS
	DB	2
	ERRNZ	BPB0,BPB_DIRENTS
	DW	64
	ERRNZ	BPB0,BPB_SECS
	DW	8*40
	ERRNZ	BPB0,BPB_MBYTE
	DB	FMT_F48S
	ERRNZ	BPB0,BPB_FATSECS
	DW	1
	ERRNZ	BPB0,<(SIZE BPB_STRUC)>

;	48 tpi single sided, extended density

BPB0E	LABEL	NEAR
	ERRNZ	BPB0E,BPB_SECSZ
	ERRNZ	BPB0,<(SIZE BPB_STRUC)>
	DW	512
	ERRNZ	BPB0E,BPB_SPAU
	DB	1
	ERRNZ	BPB0E,BPB_RES
	DW	1
	ERRNZ	BPB0E,BPB_NFATS
	DB	2
	ERRNZ	BPB0E,BPB_DIRENTS
	DW	64
	ERRNZ	BPB0E,BPB_SECS
	DW	9*40
	ERRNZ	BPB0E,BPB_MBYTE
	DB	FMT_F48SE
	ERRNZ	BPB0E,BPB_FATSECS
	DW	2
	ERRNZ	BPB0E,<(SIZE BPB_STRUC)>

;	BPB for 48tpi ds disks

BPB1	LABEL	NEAR
	ERRNZ	BPB1,BPB_SECSZ
	DW	512
	ERRNZ	BPB1,BPB_SPAU
	DB	2
	ERRNZ	BPB1,BPB_RES
	DW	1
	ERRNZ	BPB1,BPB_NFATS
	DB	2
	ERRNZ	BPB1,BPB_DIRENTS
	DW	112
	ERRNZ	BPB1,BPB_SECS
	DW	8*40*2
	ERRNZ	BPB1,BPB_MBYTE
	DB	FMT_F48D
	ERRNZ	BPB1,BPB_FATSECS
	DW	1
	ERRNZ	BPB1,<(SIZE BPB_STRUC)>

;	48 tpi double sided, extended

BPB1E	LABEL	NEAR
	ERRNZ	BPB1E,BPB_SECSZ
	ERRNZ	BPB1,<(SIZE BPB_STRUC)>
	DW	512
	ERRNZ	BPB1E,BPB_SPAU
	DB	2
	ERRNZ	BPB1E,BPB_RES
	DW	1
	ERRNZ	BPB1E,BPB_NFATS
	DB	2
	ERRNZ	BPB1E,BPB_DIRENTS
	DW	112
	ERRNZ	BPB1E,BPB_SECS
	DW	9*40*2
	ERRNZ	BPB1E,BPB_MBYTE
	DB	FMT_F48DE
	ERRNZ	BPB1E,BPB_FATSECS
	DW	2
	ERRNZ	BPB1E,<(SIZE BPB_STRUC)>

;	BPB for 8" ds dd

BPB2	LABEL	NEAR
	ERRNZ	BPB2,BPB_SECSZ
	DW	1024
	ERRNZ	BPB2,BPB_SPAU
	DB	1
	ERRNZ	BPB2,BPB_RES
	DW	1
	ERRNZ	BPB2,BPB_NFATS
	DB	2
	ERRNZ	BPB2,BPB_DIRENTS
	DW	192
	ERRNZ	BPB2,BPB_SECS
	DW	77*8*2
	ERRNZ	BPB2,BPB_MBYTE
	DB	0FEH
	ERRNZ	BPB2,BPB_FATSECS
	DW	2
	ERRNZ	BPB2,<(SIZE BPB_STRUC)>

;	96tpi double sided

BPB3	LABEL	NEAR
	ERRNZ	BPB3,BPB_SECSZ
	DW	512
	ERRNZ	BPB3,BPB_SPAU
	DB	4
	ERRNZ	BPB3,BPB_RES
	DW	1
	ERRNZ	BPB3,BPB_NFATS
	DB	2
	ERRNZ	BPB3,BPB_DIRENTS
	DW	144
	ERRNZ	BPB3,BPB_SECS
	DW	8*80*2
	ERRNZ	BPB3,BPB_MBYTE
	DB	FMT_F96D
	ERRNZ	BPB3,BPB_FATSECS
	DW	1
	ERRNZ	BPB3,<(SIZE BPB_STRUC)>

;	96tpi double sided, extended

BPB3E	LABEL	NEAR
	ERRNZ	BPB3E,BPB_SECSZ
	ERRNZ	BPB3,<(SIZE BPB_STRUC)>
	DW	512
	ERRNZ	BPB3E,BPB_SPAU
	DB	4
	ERRNZ	BPB3E,BPB_RES
	DW	1
	ERRNZ	BPB3E,BPB_NFATS
	DB	2
	ERRNZ	BPB3E,BPB_DIRENTS
	DW	144
	ERRNZ	BPB3E,BPB_SECS
	DW	9*80*2
	ERRNZ	BPB3E,BPB_MBYTE
	DB	FMT_F96DE
	ERRNZ	BPB3E,BPB_FATSECS
	DW	2
	ERRNZ	BPB3E,<(SIZE BPB_STRUC)>

;	8" ss sd 4 reserved sectors

BPB4	LABEL	NEAR
	ERRNZ	BPB4,BPB_SECSZ
	DW	128
	ERRNZ	BPB4,BPB_SPAU
	DB	4
	ERRNZ	BPB4,BPB_RES
	DW	4
	ERRNZ	BPB4,BPB_NFATS
	DB	2
	ERRNZ	BPB4,BPB_DIRENTS
	DW	104
	ERRNZ	BPB4,BPB_SECS
	DW	77*26
	ERRNZ	BPB4,BPB_MBYTE
	DB	0FDH
	ERRNZ	BPB4,BPB_FATSECS
	DW	6
	ERRNZ	BPB4,<(SIZE BPB_STRUC)>

;	8" ss sd 4 reserved sectors

BPB4C	LABEL	NEAR
	ERRNZ	BPB4C,BPB_SECSZ
	DW	128
	ERRNZ	BPB4C,BPB_SPAU
	DB	4
	ERRNZ	BPB4C,BPB_RES
	DW	1
	ERRNZ	BPB4C,BPB_NFATS
	DB	2
	ERRNZ	BPB4C,BPB_DIRENTS
	DW	68
	ERRNZ	BPB4C,BPB_SECS
	DW	77*26

;	NOTE: This is a phony FATID since the actual fat id of 0FEH would
;	conflict with the ds dd 8" format, confusing MS-DOS.

	ERRNZ	BPB4C,BPB_MBYTE
	DB	0F8H
	ERRNZ	BPB4C,BPB_FATSECS
	DW	6
	ERRNZ	BPB4C,<(SIZE BPB_STRUC)>

;****	NOTE: The 4 winchester tables MUST BE KEPT IN THIS ORDER
;	since the DSK0_BPB code relies on this!!!
;

;	Winchester drive E: partition

BPB6	LABEL	NEAR
	ERRNZ	BPB6,BPB_SECSZ
	DW	1024
	ERRNZ	BPB6,BPB_SPAU
	DB	16
	ERRNZ	BPB6,BPB_RES
	DW	1
	ERRNZ	BPB6,BPB_NFATS
	DB	2
	ERRNZ	BPB6,BPB_DIRENTS
	DW	480
	ERRNZ	BPB6,BPB_SECS
	DW	-1			;32*1024*2-1 Largest partition = 32m
	ERRNZ	BPB6,BPB_MBYTE
	DB	0F8H
	ERRNZ	BPB6,BPB_FATSECS
	DW	6
	ERRNZ	BPB6,<(SIZE BPB_STRUC)>

;	Winchester drive F: partition

BPB7	LABEL	NEAR
	ERRNZ	BPB7,BPB_SECSZ
	DW	1024
	ERRNZ	BPB7,BPB_SPAU
	DB	16
	ERRNZ	BPB7,BPB_RES
	DW	1
	ERRNZ	BPB7,BPB_NFATS
	DB	2
	ERRNZ	BPB7,BPB_DIRENTS
	DW	480
	ERRNZ	BPB7,BPB_SECS
	DW	-1			;32*1024*2 Largest partition = 32m
	ERRNZ	BPB7,BPB_MBYTE
	DB	0F8H
	ERRNZ	BPB7,BPB_FATSECS
	DW	6
	ERRNZ	BPB7,<(SIZE BPB_STRUC)>

;	Winchester drive G: partition

BPB8	LABEL	NEAR
	ERRNZ	BPB8,BPB_SECSZ
	DW	1024
	ERRNZ	BPB8,BPB_SPAU
	DB	16
	ERRNZ	BPB8,BPB_RES
	DW	1
	ERRNZ	BPB8,BPB_NFATS
	DB	2
	ERRNZ	BPB8,BPB_DIRENTS
	DW	480
	ERRNZ	BPB8,BPB_SECS
	DW	-1			;32*1024*2 Largest partition = 32m
	ERRNZ	BPB8,BPB_MBYTE
	DB	0F8H
	ERRNZ	BPB8,BPB_FATSECS
	DW	6
	ERRNZ	BPB8,<(SIZE BPB_STRUC)>

;	Winchester drive H: partition

BPB9	LABEL	NEAR
	ERRNZ	BPB9,BPB_SECSZ
	DW	1024
	ERRNZ	BPB9,BPB_SPAU
	DB	16
	ERRNZ	BPB9,BPB_RES
	DW	1
	ERRNZ	BPB9,BPB_NFATS
	DB	2
	ERRNZ	BPB9,BPB_DIRENTS
	DW	480
	ERRNZ	BPB9,BPB_SECS
	DW	-1			;32*1024*2 Largest partition = 32m
	ERRNZ	BPB9,BPB_MBYTE
	DB	0F8H
	ERRNZ	BPB9,BPB_FATSECS
	DW	6
	ERRNZ	BPB9,<(SIZE BPB_STRUC)>

DSKPR	DB	DSKPR_SIZE DUP(?) ; Parm packet to DSK

FATID	DB	?		; Fat ID byte from BPB packet

NEXTMB	DB	0FDH		; Alternating FAT id byte

BIOS_SEG	ENDS

	END

