	EXTRN	BIOS_DATE:WORD
	EXTRN	BIOS_HRS:BYTE
	EXTRN	BIOS_MIN:BYTE
	EXTRN	BIOS_SEC:BYTE
	EXTRN	BIOS_HSEC:WORD

;
;  PBE_SETDATE - Set the date
;
;     Call with:
;         AX = the number of days since Jan 1, 1980.
;
;     Uses: No registers are used.
;
 
PBE_SETDATE PROC FAR
	PUSHF			; Save status
	CLI			; Turn off interrupts
	MOV	CS: BIOS_DATE,AX ; Save it
	POPF			; Restore status
	RET
PBE_SETDATE ENDP


;
;  PBE_SETTIME - Set the time
;
;      CALL with:
;          CH = hours (0-23)
;          CL = minutes (0-59)
;          DH = seconds (0-59)
;          DL = hundredths of seconds (0-99)
;
;     Uses: No registers are used
;

PBE_SETTIME PROC FAR
	PUSHF			; Save current status
	CLI			; Turn off interrupts
	MOV	CS: BIOS_HRS,CH ; Save hours
	MOV	CS: BIOS_MIN,CL ; Save minutes
	MOV	CS: BIOS_SEC,DH	; Save seconds
	MOV	CS: BYTE PTR BIOS_HSEC,DL ; Save hundredths of seconds
	POPF			; Restore status
	RET
PBE_SETTIME ENDP


;
;  PBE_GETDATE - Get time and date
;
;      Returns:
;          AX = count of days since Jan 1, 1980.
;          CH = hours
;          CL = minutes
;          DH = seconds
;          DL = hunderdths of seconds
;
;     Uses: No registers are used
;

PBE_GETDATE PROC FAR
	PUSHF			; Save current status
	CLI			; Turn off interrupts
	MOV	AX,CS: BIOS_DATE ; Get date
	MOV	CH,CS: BIOS_HRS ; Get hours
	MOV	CL,CS: BIOS_MIN ; Get minutes
	MOV	DH,CS: BIOS_SEC ; Get seconds
	MOV	DL,CS: BYTE PTR BIOS_HSEC ; Get hundredths of seconds
	POPF			; Restore status
	RET
PBE_GETDATE ENDP
