;
;  PBE_READ - Read from the disk
;
;     Call with:
;         AL = Device number
;         CX = Number of sectors to read
;         DX = Logical sector number
;         DS:BX = transfer addr
;
;     Returns:
;         CX = number of sectors not read
;         Success: CY = 0
;         Failure: CY = 1, AL = error code
;
;     Uses: All other regs(segment regs are preserved)
;

PBE_READ:
	MOV	AH,DSK_READ	; Get function to do
	JMP	NEAR PTR PBE_RDWR ; Join common code

;
;  PBE_WRITE - Write to the disk
;
;     Call with:
;         AL = Device number
;         AH = Verify flag: 0=no verify, 1=verify after write
;         CX = Number of sectors to write
;         DX = Logical sector number
;         DS:BX = transfer addr
;
;     Returns:
;         CX = Number of sectors not written
;         Success: CY = 0
;         Failure: CY = 1, AL = error code
;
;     Uses: All other regs(segment regs are perserved)
;

PBE_WRITE:
	MOV	AH,DSK_WRITE	; Get function to do (ignore verify for now)
	

;
; Common code for read and write
;
PBE_RDWR PROC	FAR
	PUSH	DS		; Save DS
	PUSH	ES		; Save ES
	MOV	CS: WORD PTR DSKPR+DSKPR_BUFF+2,DS ; Store DS
	PUSH	CS		; Set up DS seg reg
	POP	DS

;  Put the parameters in the packet

	MOV	BYTE PTR DSKPR+DSKPR_DRIVE,AL ; Drive number
	MOV	WORD PTR DSKPR+DSKPR_SECTOR,DX ; Logical sector
	MOV	WORD PTR DSKPR+DSKPR_COUNT,CX ; Sector count
	MOV	WORD PTR DSKPR+DSKPR_BUFF,BX ; Offset of buffer
	MOV	BX,OFFSET DSKPR	; Get addr of packet
	PUSH	DS		; Set up ES seg reg
	POP	ES
	MOV	AL,AH		; Get function to do
	PUSHF			; Save interrupt status
	STI			; Turn interrupts on
	CALL	DSK		; Perform the function, Did error occur ?
	LAHF			; Save flags
	POPF			; Restore interrupt status
	SAHF			; Restore flags
	JNC	BIOS_RWF	;   No, success so return
	MOV	SI,-1		; Start with entry -1
RW_EL:	INC	SI		; Bump entry number
	MOV	AH,BYTE PTR RW_ERRB[SI] ; Get error code
	CMP	AH,0FFH		; At end of table ?
	JE	RW_EFI		;   Yes, get out
	TEST	AL,AH		; Do any bits match ?
	JZ	RW_EL		;   No, try next entry
RW_EFI:
	MOV	AL,BYTE PTR RW_ERRC[SI]	;   Yes, get error code
	STC			; Turn on CY to show error
BIOS_RWF:
	MOV	CX,WORD PTR DSKPR+DSKPR_COUNT ; Return remaining sectors

	POP	ES		; Restore ES
	POP	DS		; Restore DS

	RET			;   and return
PBE_RDWR ENDP

;	Corresponding Z-DOS error codes

DSKE_WRITEP	EQU	0
DSKE_NREADY	EQU	2
DSKE_DATA	EQU	4
DSKE_SEEK	EQU	6
DSKE_SECT	EQU	8
DSKE_WFAULT	EQU	10
DSKE_OTHER	EQU	12

RW_ERRC DB	DSKE_WRITEP	; Write protect
	DB	DSKE_NREADY	; Not ready
	DB	DSKE_DATA	; Data error
	DB	DSKE_SEEK	; Seek error
	DB	DSKE_SECT	; Sector error
	DB	DSKE_WFAULT	; Write fault
	DB	DSKE_OTHER	; Catchall error

;	List of errors generated by z207

RW_ERRB DB	FDSWPV		; Write protect
	DB	FDSNRD		; Not ready
	DB	FDSCRC+FDSLDT	; CRC error and Lost data
	DB	FDSSEK		; Seek error
	DB	0
	DB	FDSWTF		; Write fault
	DB	-1

;	Translate z217 errors to z207 errors

RW_ERRD	DB	WIEDNR,FDSNRD	; Drive not ready
	DB	WIENSC,FDSSEK	; No seek complete
	DB	WIENTZ,FDSSEK	; No track zero
	DB	WIENI,FDSNRD	; No index pulse
	DB	WIENDS,FDSNRD	; No drive select
	DB	WIEHNF,FDSSEK	; No header AM found
	DB	WIESKE,FDSSEK	; Seek error
	DB	WIESNF,FDSSEK	; Sector not found
	DB	WIEHECC,FDSSEK	; ECC error in header
	DB	WIEDAM,FDSCRC+FDSLDT	; Data AM not found
	DB	WIENECC,FDSCRC+FDSLDT	; Non-correctable ECC error
	DB	WIECECC,FDSCRC+FDSLDT	; Correctable ECC error
	DB	WIEWF,FDSWTF	; Write fault
	DB	WIEIOC,-1	; Illegal op code
	DB	WIEIDA,FDSSEK	; Illegal disk address
	DB	WIEFP,FDSWTF	; Drive format protected
	DB	WIEWP,FDSWTF	; Drive write protected
	DB	WIEMISC,-1	; Misc. error
	DB	-1,-1		; Terminates table
