;***********************************************************************/
;*	varmov.asm                                                    *
;***********************************************************************/
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC
PSEG
ENDIF
;
;**********************************************************************
;
;  VARMOVE
;
;  This subroutine moves a number of BYTES from one memory
;  location (pointer) to another memory location (pointer).
;  The syntax for the function is as follows:
;
;        varmov(bytes,from,to);
;        where:
;              unsigned bytes; /* number of bytes to move */
;              *from; /* pointer from which data is to be moved (source) */
;              *to;   /* pointer to which data will be moved (destination)*/
;
;
;
	PUBLIC VARMOV

IF @BIGMODEL+LPROG     ; LARGE CODE MODELS
VARMOV	PROC FAR
	BYTES EQU BP+6
ELSE
VARMOV	PROC NEAR
	BYTES EQU BP+4
ENDIF
	PUSH BP
	MOV BP,SP
	PUSH DS		; SAVE SEGMENT REGISTERS WHICH MAY BE MODIFIED
	PUSH ES
	MOV CX,[BYTES]	; PUT BYTE COUNT IN CX REGISTER
IF @BIGMODEL+LDATA	; LARGE DATA MODELS
	LES DI,DWORD PTR [BYTES+6]	; SET UP DESTINATION REGS
	LDS SI,DWORD PTR [BYTES+2]	; SET UP SOURCE REGS
ELSE
	PUSH DS		; MAKE ES POINT TO DEFAULT DATA SEGMENT
	POP ES		; BY SETTING ES = DS
	MOV DI,WORD PTR [BYTES+4]	; GET DI WITH DEFAULT ES
	MOV SI,WORD PTR [BYTES+2]	; GET SI WITH DEFAULT DS
ENDIF
	
REP	MOVSB		; DO MOVE
	POP ES		; RESTORE ES AND DS REGISTERS
	POP DS
	POP BP
	RET
VARMOV	ENDP

;**************************************************************************
;
IFDEF CI_C86
@CODE	ENDS
ELSE
ENDPS
ENDIF
	END
