/***********************************************************************/
/*	curdir.c                                                      */
/***********************************************************************/
#ifdef _C86_BIG
#define LPTR 1
#endif


/*  return the path of the current directory                                */
curdir(drive,pname)
char *pname;  /* a character array to be passed the pathname as a string    */
int drive;    /* the selected drive - 0 = default, 1 = A, etc.              */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

#ifdef LPTR
			/* if big data models => get segment part of */
			/*     ASCII string address pointer          */
  regs.ds= hiword(pname);

#else

  regs.ds=0;		/* else => use default DS */

#endif


  regs.es=0;   /* default value for registers */
  regs.dl=drive;
  regs.si= (unsigned) pname;
  regs.ah=0x47; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  return(ret_code);
}
