/***********************************************************************/
/*	diskspac.c                                                    */
/***********************************************************************/

/*  get available clusters, total clusters, bytes/sector, sectors/cluster */
diskspac(drive,avclust,totclust,bps,spc)
int drive; /* drive number to check - 0 =default, 1 = A, etc.  */
int *avclust; /* number of clusters available (free space) */
int *totclust; /* number of clusters on disk in total */
int *bps; /* number of bytes per sector */
int *spc; /* number of sectors per cluster */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  regs.dl = drive;
  regs.ds=regs.es=0;   /* default value for registers */
  regs.ah=0x36; /* DOS function number */
  int_no=0x21; /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *avclust = (regs.bh * 256) + regs.bl; /* available returned in bx register */
  *totclust = (regs.dh * 256) + regs.dl; /* total returned in dx */
  *bps = (regs.ch * 256) + regs.cl; /* bytes per sector returned in cx */
  *spc = (regs.ah * 256) + regs.al; /* sectors per cluster returned in ax */
  return(ret_code);
}

