/***********************************************************************/
/*	writefil.c                                                    */
/***********************************************************************/

/* write data from buffer to file */
writefil(handle,bytes,buffer,actual_count)
unsigned handle; /* 16 bit handle returned from open */
unsigned bytes;  /* number of bytes to write */
char *buffer;  /* ptr to buffer area to transfer data from */
unsigned *actual_count; /* ptr to return actual # of bytes written */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */


#ifdef LPTR
			/* if big data models => get segment part of */
			/*     address pointer          */
  regs.ds= hiword(buffer);

#else

  regs.ds=0;		/* else => use default DS */

#endif

  regs.es=0; /* default es reg. */
  regs.bh=handle >> 8 ; /* handle loaded into bx register */
  regs.bl=handle - (regs.bh << 8);
  regs.ch=bytes >> 8; /* write count loaded into cx register */
  regs.cl=bytes - (regs.ch << 8);
  regs.dh= (unsigned) (buffer) >> 8 ; /* buffer ptr loaded into dx */
  regs.dl= (unsigned) (buffer) - (regs.dh << 8);
  regs.ah=0x40;  /* DOS function number */
  int_no=0x21;  /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *actual_count = (regs.ah << 8) + regs.al ; /* count returned in ax */
  return(ret_code);
}
