/***********************************************************************/
/*	asyinit.c                                                     */
/***********************************************************************/
  
 /* initialize the asynchronous communications port */
asyinit(comm,baud,parity,stops,databits,line,modem)
int comm; /* port number */
int baud; /* baud rate to be set: 110,150,300,600,1200,2400,4800,9600 */ 
int parity; /* 0=none, 1=odd, 2=even */
int stops; /* number of stop bits: 1 0r 2 */
int databits; /* number of data bits: 7 or 8 */
int *line; /* line status returned */                    
int *modem; /* modem status returned */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code;        /* return code for gdosint */
  
  if ( comm < 0 || comm > 1 )
     return(-1);
  regs.dh=0;
  regs.dl=comm;

/* build appropriate initialization value in register al for BIIOS call */

  switch (databits){
	case 7:
		regs.al = 2;
		break;
	case 8: 
		regs.al = 3;
		break;
	default:
		return(-1);
  }

  switch (stops){
	case 1:
		break;
	case 2:
		regs.al |= 0x0004;
		break;
	default:
		return(-1);
  }

  switch (parity){
	case 0:
		break;
	case 1:
		regs.al |= 0x0008;
		break;
	case 2:
		regs.al |= 0x0018;
		break;
	default:
		return(-1);
  }

  switch (baud){
	case 110:
		break;
	case 150:
		regs.al |= 0x0020;
		break;
	case 300:
		regs.al |= 0x0040;
		break;
	case 600:
		regs.al |= 0x0060;
		break;
	case 1200:
		regs.al |= 0x0080;
		break;
	case 2400:
		regs.al |= 0x00A0;
		break;
	case 4800:
		regs.al |= 0x00C0;
		break;
	case 9600:
		regs.al |= 0x00E0;
		break;
	default:
		return(-1);
  }
 
  regs.ah=0;      /* initialize the async port with parameters in al */
  ret_code = gdosint(0x14,&regs,&regs);
  *line=regs.ah;  /* return status */
  *modem=regs.al;
  return(ret_code);
}
