	PAGE	,132
	TITLE	BIOS_INIT - initialization code for BIOS (BINIT.ASM)
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;



	.LFCOND
	.TFCOND		; Use the /X switch to cause FALSE conds not to list

DOS_BUF_COUNT	=	2	; # of DOS file buffers to allocate

;
;  BIOS_INIT - Initialization code
;
;      The loader jumps here after loading the BIOS.
;
;      Assumptions:
;        1) The boot device port number, unit number, and
;            parameter string are stored at known locations.
;        2) On entry, the CS=start of BIOS, the
;           DS=start of loader, SI=offset of loader table,
;           and the other regs are undefined.
;
;  Note: this must be the last module before SYSINIT(currently)
;

	INCLUDE	PARMS.ASM
	INCLUDE	VER.ASM

DOS_ISEG EQU	1400H		; Initial DOS segment
LOAD_FONT	EQU	TRUE	; If to autoload ALTCHAR.SYS

    IF1
	%OUT	*Pass 1 started*
    ELSE
	%OUT	*Pass 2 started*
    ENDIF

    IF1
      IF LISTI
	%OUT	*Full listing being generated*
      ELSE
	%OUT	*Include files are not part of listing*
	.XLIST
      ENDIF
    ENDIF

	INCLUDE	DEFASCII.ASM
	INCLUDE	DEFCONFG.ASM	; Z-100 system
	INCLUDE	DEFMTR.ASM	; ROM based monitor
	INCLUDE	DEF8259A.ASM	; 8259A interrupt controller 
	INCLUDE	DEFFMT.ASM	; Loader header parameters
	INCLUDE	DEF6821.ASM	; 6821 PIA parameters
	INCLUDE	DEFEP2.ASM	; 2661 UART parameters
	INCLUDE	DEFCHR.ASM	; Character device driver
	INCLUDE	DEF8253.ASM	; 8253 programmable timer 
	INCLUDE	DEFZ207.ASM	; Z-207 Disk controller
	INCLUDE	DEFZ217.ASM	; Z-217 Disk controller
	INCLUDE	DEFDSK.ASM	; Disk driver parameters
	INCLUDE	DEFDOSI.ASM	; MS-DOS parameters
	INCLUDE	DEFDIR.ASM	; Directory definitions
	INCLUDE	DEFIPAGE.ASM	; Interrupt page defs
	INCLUDE	DEFSBC.ASM	; SBC definitions
	INCLUDE	MACLIB.ASM
	.LIST

	PAGE

; 
; The following externals are in the SYSINIT module.
; They must be declared outside the BIOS_SEG Segment.
;

	EXTRN	SYSINIT:FAR
	EXTRN	CURRENT_DOS_LOCATION:WORD
	EXTRN	FINAL_DOS_LOCATION:WORD
	EXTRN	DEVICE_LIST:DWORD
	EXTRN	MEMORY_SIZE:WORD
	EXTRN	DEFAULT_DRIVE:BYTE
	EXTRN	BUFFERS:BYTE

;	NOTE: For the SYSINIT relocation and other things at the end
;	of this module to work, the following must be aligned on a
;	paragraph boundry.
;
;	bcb - 5/17/83

BIOS_SEG SEGMENT PARA PUBLIC 'BIOSCODE'

    IF LOAD_FONT
	EXTRN	FONTLD:NEAR
	PUBLIC	MTR_DS_VAL,ROM_VER
    ENDIF
	EXTRN	BIOS_START:NEAR
	EXTRN	BIOS_DATE:BYTE
	EXTRN	RECURLV:WORD
	EXTRN	SAVESS:WORD
	EXTRN	SAVESP:WORD
	EXTRN	ALARM_WAIT:NEAR
	EXTRN	PMESG:NEAR

	EXTRN	ISR_USAI:NEAR
	EXTRN	ISR_USAO:NEAR
	EXTRN	ISR_USBI:NEAR
	EXTRN	ISR_USBO:NEAR
	EXTRN	ISR_UKB:NEAR
	EXTRN	ISR_UCRT:NEAR
	EXTRN	ISR_UTM:NEAR
	EXTRN	ISR_ULP:NEAR
	EXTRN	ISR_ULPS:NEAR
	EXTRN	ISR_VSYN:NEAR

	EXTRN	CQ_ZCON:WORD
	EXTRN	CQ_ZSERA:WORD
	EXTRN	CQ_ZSERB:WORD
	EXTRN	ISR_PRSC:NEAR
	EXTRN	KQ_PUT:NEAR
	EXTRN	ISR_WILD:NEAR
	EXTRN	ISR_EI:NEAR
	EXTRN	ISR_TIM:NEAR
	EXTRN	ISR_SA:NEAR
	EXTRN	ISR_SB:NEAR
	EXTRN	ISR_KD:NEAR
	EXTRN	ISR_SLV:NEAR
	EXTRN	ISR_PP:NEAR
	EXTRN	ISR_SLV0:NEAR
	EXTRN	ISR_SLV1:NEAR
	EXTRN	ISR_SLV2:NEAR
	EXTRN	ISR_SLV3:NEAR
	EXTRN	ISR_SLV4:NEAR
	EXTRN	ISR_SLV5:NEAR
	EXTRN	ISR_SLV6:NEAR
	EXTRN	ISR_SLV7:NEAR
	EXTRN	ISR_EVN:NEAR
	EXTRN	VIDEO_ROM:BYTE
	EXTRN	VIDEO_PGM:BYTE
	EXTRN	BIOS_MCL:BYTE
	EXTRN	DSK_TPTR:WORD
	EXTRN	DSKPR:BYTE
	EXTRN	DSK:NEAR
	EXTRN	DSK_WCB:NEAR
	EXTRN	BIOS_DEVS:NEAR
	EXTRN	BIOS_AUXFUNC:FAR
	EXTRN	BIOS_CONFUNC:FAR
	EXTRN	BIOS_PRNFUNC:FAR
	EXTRN	CHRD_PRN:BYTE
	EXTRN	CHRD_AUX:BYTE
	EXTRN	CHRD_CON:BYTE

	PUBLIC	BIOS_INIT
	PUBLIC	FNT_INFO
	PUBLIC	RE_INIT		; Called by SYSINIT
	PUBLIC	BDRIVE		; Boot drive
	PUBLIC	DSK_BUF		; Reuseable disk buffer
	PUBLIC	ROM_WA
	PUBLIC	BIOS_STACK
	PUBLIC	STACK_START
	PUBLIC	FNT_TAB
	PUBLIC	FNT_END
	PUBLIC	Q_ZCON
	PUBLIC	Q_ZSERA
	PUBLIC	Q_ZSERB

	ORG	0
	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

BINIT_START	LABEL	NEAR

;	FONT configuration table

FNT_INFO	LABEL	BYTE
FNT_RAM	DD	?		; Adress of FONT in ram
FNT_ROM	DD	?		; Adress of FONT in rom
FNT_SIZE DW	?		; Bytes in FONT in ram
FNT_MSIZE DW	?		; Maximum bytes in FONT in RAM

BIOS_INIT:

; Set up segment registers and stack

	MOV	AX,CS		; Set up segment registers
   	MOV	ES,AX
	CLI			; Turn off interrupts before changing SS/SP

; Save information from loader, SI = pointer to loaders header

	MOV	SI,OFFSET FMT_OFFSET
	MOV	DI,OFFSET LDR_HDR ; Get dest offset
	MOV	CX,OFFSET FMT_SIZE	; Get size of header
	CLD			; Set direction
	REP MOVSB		; Move loader header to local area

;	Now relocate the SYSINIT module

	MOV	AX,SEG SYSINIT
	MOV	DS,AX		; DS = current location
	MOV	BX,OFFSET RELOC_SIZE
	XOR	CX,CX
	MOV	ES,CX		; ES:0 = interrupt pag
	MOV	ES,ES:WORD PTR [MTR_DS]	; ES = mtr data segment
	ADD	BX,ES:WORD PTR [MTR_DS_SIZE]
	ADD	BX,15		; BX = total size of space needed
	MOV	CX,4
	SHR	BX,CL
	ADD	AX,BX		; AX = result location
	MOV	CS:WORD PTR SEGSYSINIT,AX
	MOV	ES,AX		; ES = result address
	XOR	SI,SI
	MOV	DI,SI		; DS:SI , ES:DI set up for move
	CLD
	MOV	CX,7FFFH
	REP	MOVSW		; Move upto 64k of it up

	MOV	AX,CS
	MOV	SS,AX
	MOV	SP,OFFSET BIOS_STACK ; Set up a local stack
	MOV	CS:SAVESS,SS	; Save SS
	INC	WORD PTR CS: RECURLV ; Bump recursion level

; Move work area for monitor ROM to a safe place
;

	XOR	SI,SI		; Set both source and dest offsets to zero
	MOV	DI,SI 

	ASSUME	DS:IPAGE_SEG

	MOV	DS,SI		; Address interrupt vector area
	MOV	DS,DS: WORD PTR MTR_DS ; Get current DS used by monitor
	MOV	BX,CS		; Get base addr of BIOS
	MOV	AX,OFFSET ROM_WA ; Get ROM work area offset
	MOV	CL,4		; Get shift count
	SHR	AX,CL		; Divide by 16 to get par
	ADD	BX,AX		; Compute para of work area
	MOV	ES,BX		; Set up dest for move

	ASSUME	DS:MTR_D_SEG

	MOV	CX,WORD PTR DS:MTR_DS_SIZE ; Get bytes to move
	REP MOVSB		; Move the ROM monitor's work area

;
; Initialize interrupt vectors
;   (BX has new value for monitor DS)

	ASSUME	DS:IPAGE_SEG

	XOR	SI,SI		; Set source offset
	MOV	DI,4		; Set dest offset
	MOV	ES,SI		; Set up seg regs to interrupt vectors
	MOV	DS,SI
	MOV	WORD PTR INT_ZERO,OFFSET ISR_WILD ; Store default addr
	MOV	WORD PTR INT_ZERO+2,CS
	MOV	CX,2*(256-16) 	; Get count for smear
	REP MOVSW		; Smear default interrupt handler

	MOV	WORD PTR MTR_DS,BX ; Store ROM monitor DS addr
	MOV	CS:MTR_DS_VAL,BX ; Save locally
	MOV	WORD PTR MTR_DS-2,0 ; Make offset part a zero
	MOV	ES,BX		; Addr ROM monitor data page

	ASSUME	ES:MTR_D_SEG

	MOV	WORD PTR ES:MTR_DXMTC,OFFSET MTR_SKBD ; Set up keyboard
	MOV	WORD PTR ES:MTR_DXMTC+2,SEG MTR_SEG
	MOV	WORD PTR ES:MTR_SXMTC,OFFSET KQ_PUT
	MOV	WORD PTR ES:MTR_SXMTC+2,CS

; Finish remaining inits (CS is already set up for them)

	MOV	WORD PTR INT_EI,OFFSET ISR_EI ; Parity or buss error
	MOV	WORD PTR INT_TIM,OFFSET ISR_TIM ; Timer interrupt handler
	MOV	WORD PTR INT_SLV,OFFSET ISR_SLV ; Slave 8259A
	MOV	WORD PTR INT_SA,OFFSET ISR_SA ; Serial port A
	MOV	WORD PTR INT_SB,OFFSET ISR_SB ; Serial port B
	MOV	WORD PTR INT_KD,OFFSET ISR_KD ; Keyboard/Display/Light pen
	MOV	WORD PTR INT_PP,OFFSET ISR_PP ; Parallel port

	MOV	WORD PTR INT_SLV0,OFFSET ISR_SLV0 ; Slave line 0
	MOV	WORD PTR INT_SLV1,OFFSET ISR_SLV1 ; Slave line 1
	MOV	WORD PTR INT_SLV2,OFFSET ISR_SLV2 ; Slave line 2
	MOV	WORD PTR INT_SLV3,OFFSET ISR_SLV3 ; Slave line 3
	MOV	WORD PTR INT_SLV4,OFFSET ISR_SLV4 ; Slave line 4
	MOV	WORD PTR INT_SLV5,OFFSET ISR_SLV5 ; Slave line 5
	MOV	WORD PTR INT_SLV6,OFFSET ISR_SLV6 ; Slave line 6
	MOV	WORD PTR INT_SLV7,OFFSET ISR_SLV7 ; Slave line 7

;	BIOS generated interrupts

	MOV	WORD PTR INT_UKB,OFFSET ISR_UKB		; User keyboard
	MOV	WORD PTR INT_UCRT,OFFSET ISR_UCRT	; User CRT output
	MOV	WORD PTR INT_USAI,OFFSET ISR_USAI	; Serial A input
	MOV	WORD PTR INT_USAO,OFFSET ISR_USAO	; Serial A output
	MOV	WORD PTR INT_USBI,OFFSET ISR_USBI	; Serial B input
	MOV	WORD PTR INT_USBO,OFFSET ISR_USBO	; Serial B output
	MOV	WORD PTR INT_UTM,OFFSET ISR_UTM		; User Timer
	MOV	WORD PTR INT_ULP,OFFSET ISR_ULP		; Light pen
	MOV	WORD PTR INT_ULPS,OFFSET ISR_ULPS	; Special light pen
	MOV	WORD PTR INT_PRSC,OFFSET ISR_PRSC	; Print Screen
	MOV	WORD PTR INT_EVN,OFFSET ISR_EVN		; Event trap
	MOV	WORD PTR INT_VSYN,OFFSET ISR_VSYN	; Vertical synch

;	Now zero out the location reserved for the mouse interrupt

	MOV	DS:WORD PTR [33H*4],0
	MOV	DS:WORD PTR [33H*4+2],0

	ASSUME	DS:BIOS_SEG,ES:BIOS_SEG

	MOV	AX,CS		; Recover DS,ES
	MOV	DS,AX
	MOV	ES,AX

	MOV	WORD PTR CQ_SEGM+CQ_ZCON,AX		; Default segments
	MOV	WORD PTR CQ_SEGM+CQ_ZSERA,AX
	MOV	WORD PTR CQ_SEGM+CQ_ZSERB,AX

;	Set up the current date/time

	CMP	BYTE PTR LDR_HDR+FMT_VER,2	; Date in loader?
	JC	NO_DATE				; If not, ignore
	MOV	SI,OFFSET LDR_HDR+FMT_DATE	; Diskette date
	MOV	DI,OFFSET BIOS_DATE		; BIOS current date
	MOV	CX,7				; Size in bytes
	CLD
	REP	MOVSB		; Move in the format date of diskette
NO_DATE:

;
; Initialize the Keyboard
;

	MOV	AL,ZKEYDK	; Disable keyboard until ready
	CALL	OUTKEY
	MOV	AL,ZKEYCF	; Flush typeahead buffer
	CALL	OUTKEY
	IN	AL,ZKEYBRDD

;
; Save video state set up by the ROM monitor
;

	IN	AL,ZVIDEO+PIADATA ; Get current video state
	MOV	BYTE PTR VIDEO_ROM,AL ; Save it
	

;
; Initialize the Serial port A
;

	XOR	AL,AL		; Turn off unit
	OUT	ZSERA+EPCMD,AL
	IN	AL,ZSERA+EPCMD	; Reset mode reg ptr
	MOV	AL,EPSB1+EPCL8+EPA16X ; Set mode reg 1
	OUT	ZSERA+EPMODE,AL
	MOV	AL,EPMR2A+EPB960 ; Set mode reg 2
	OUT	ZSERA+EPMODE,AL
	MOV	AL,EPNORM+EPRTS+EPRESE+EPRXEN+EPDTR
	OUT	ZSERA+EPCMD,AL	; Set Command port
	IN	AL,ZSERA+EPDATA ; Clear input
	IN	AL,ZSERA+EPDATA


;
; Initialize the Serial port B
;

	XOR	AL,AL		; Turn off unit
	OUT	ZSERB+EPCMD,AL
	IN	AL,ZSERB+EPCMD	; Reset mode reg ptr
	MOV	AL,EPSB1+EPCL8+EPA16X ; Set mode reg 1
	OUT	ZSERB+EPMODE,AL
	MOV	AL,EPMR2A+EPB960 ; Set mode reg 2
	OUT	ZSERB+EPMODE,AL
	MOV	AL,EPNORM+EPRTS+EPRESE+EPRXEN+EPDTR
	OUT	ZSERB+EPCMD,AL	; Set Command port
	IN	AL,ZSERB+EPDATA	; Clear input
	IN	AL,ZSERB+EPDATA


;
; Initialize PIA port
;

	MOV	AL,PIADDAC	; Set control ports for data
	OUT	ZPIA+PIACTLA,AL
	OUT	ZPIA+PIACTLB,AL
	MOV	AL,01011111B	; Load initial data value for port A
	OUT	ZPIA+PIADATA,AL
	MOV	AL,11111111B	; Load initial data value for port B
	OUT	ZPIA+PIADATB,AL
	XOR	AL,AL		; Set control ports for direction
	OUT	ZPIA+PIACTLA,AL
	OUT	ZPIA+PIACTLB,AL
	MOV	AL,10101111B	; Set direction reg for port A
	OUT	ZPIA+PIADDRA,AL
	MOV	AL,11111100B	; Set direction reg for port B
	OUT	ZPIA+PIADDRB,AL

; Make 0->1 transitions of light pen cause CA1 to set, but no interrupt
; Make 0->1 transitions of vsync cause CA2 to set and cause interrupts

	MOV	AL,PIADDAC+PIAC12+PIAC23 ; Set control port A for data
	OUT	ZPIA+PIACTLA,AL

; Disable transitions of parallel printer to cause interrupt

	MOV	AL,PIADDAC	; Set control port B for data
	OUT	ZPIA+PIACTLB,AL

; Clear CA1,CA2 and CB1,CB2 by reading the port and then using
; dummy I/O to drive clock on PIA (and thus cause clear to occur)

	IN	AL,ZPIA+PIADATA ; Clear CA1,CA2
	IN	AL,ZPIA+PIADATB	; Clear CB1,CB2
	IN	AL,ZDIPSW	; Read from a "safe" place(the dip switch)

; Turn off clear of light pen/vsync so CA1/CA2 transitions can occur

	IN	AL,ZPIA+PIADATA	; Get current data value
	OR	AL,10100000B	; Turn off clear of Vsync/Light pen flipflops
	OUT	ZPIA+PIADATA,AL	; Allow vsync to cause interrupts


;
; Initialize the Timer
;

	
; Make sure all counter read cycles are completed

	IN	AL,ZTIMER+PITC0
	IN	AL,ZTIMER+PITC0
	IN	AL,ZTIMER+PITC1
	IN	AL,ZTIMER+PITC1
	IN	AL,ZTIMER+PITC2
	IN	AL,ZTIMER+PITC2

; Init counter modes

	IN	AL,ZDIPSW		; Waste some time
	MOV	AL,PITSC0+PITRLW+PITMSW
	OUT	ZTIMER+PITCW,AL	; Counter 0 - square wave generator
	IN	AL,ZDIPSW		; Waste some time
	MOV	AL,PITSC1+PITRLW+PITMITC
	OUT	ZTIMER+PITCW,AL	; Counter 1 - event counter
	IN	AL,ZDIPSW		; Waste some time
	MOV	AL,PITSC2+PITRLW+PITMITC
	OUT	ZTIMER+PITCW,AL	; Counter 2 - intr on terminal count

; Init counter values

	IN	AL,ZDIPSW		; Waste some time
	XOR	AL,AL			; Timer 1
	OUT	ZTIMER+PITC1,AL
	PUSH	AX
	POP	AX
	OUT	ZTIMER+PITC1,AL
	IN	AL,ZDIPSW		; Waste some time
	MOV	AX,ZTIMEVAL		; Timer 0
	OUT	ZTIMER+PITC0,AL
	IN	AL,ZDIPSW		; Waste some time
	MOV	AL,AH
	OUT	ZTIMER+PITC0,AL

; Wait for first rising clock from counter 0

	IN	AL,ZDIPSW		; Waste some time
	MOV	AL,0FFH-ZTIMERS0
	OUT	ZTIMERS,AL
	XOR	CX,CX		; Get timeout value
TIMEL:
	IN	AL,ZDIPSW		; Waste some time
	IN	AL,ZTIMERS	; Get status
	TEST	AL,ZTIMERS0	; Has it occured yet ?
	LOOPZ	TIMEL		;   No, try again
	JNZ	BINIC1		; If clock responded, then skip
	JMP	TIMERR		; Clock never responded
BINIC1:

; Clear any pending interrupts

	IN	AL,ZDIPSW		; Waste some time
	MOV	AL,NOT(ZTIMERS0 OR ZTIMERS2)
	OUT	ZTIMERS,AL

;
; Initialize parity generation 
;

	MOV	AL,BIOS_MCL	; Get value of memory control latch
	TEST	AL,ZMCLPK	; Is parity checking specified ?
	JZ	MEMIF		;   No, skip
	AND	AL,NOT ZMCLPK	; Turn off checking(and on generation)
	OUT	ZMCL,AL		; Output value

	MOV	DX,Z205BA
	MOV	CX,Z205BMC
MEMIL0:
	OUT	DX,AL		; Init and z205 boards
	INC	DX
	LOOP	MEMIL0

	XOR	AX,AX		; Start at segment 0
MEMIL:
	MOV	DS,AX		; Set up segment regs
	MOV	ES,AX
	MOV	AX,DS:0		; Get first word
	MOV	BX,AX		; Save a copy
	INC	AX		; Bump value
	INC	WORD PTR DS:0	; Bump memory 
	CMP	AX,WORD PTR DS:0 ; Are they the same ?
	JNE	MEMIC		;   No, skip
	MOV	WORD PTR DS:0,BX ; Restore value
	XOR	SI,SI		; Set up regs for move
	XOR	DI,DI
	MOV	CX,08000H	; Get number of words to move
	REP MOVSW		; Move words onto themselves
MEMIC:
	MOV	AX,DS		; Get segment
	ADD	AX,01000H	; Point to next segment, finished ?
	JNZ	MEMIL		;   No, try again 
	
	MOV	AX,CS		; Restore seg regs
	MOV	ES,AX
	MOV	DS,AX
MEMIF:

;
; Initialize the Slave 8259A interrupt controller
;

	MOV	AL,ICW1OP+ICW1LT+ICW1IL4
	OUT	ZS8259A+ICW1,AL	; Level triggered, cascaded
	MOV	AL,ZS8259AI	; Get slave base interrupt number
	OUT	ZS8259A+ICW2,AL	; Set interrupt base number
	MOV	AL,ZINTSLV
	OUT	ZS8259A+ICW3,AL	; Set slave number
	MOV	AL,ICW4UPM+ICW4SFN
	OUT	ZS8259A+ICW4,AL	; Set processor to 8086, fully nested, non buffered

	MOV	AL,0FFH
	OUT	ZS8259A+OCW1,AL	; Don't allow any interrupts

; 
; Initialize the Master 8259A interrupt controller
;   (interrupts are still disabled)
;

	MOV	AL,ICW1OP+ICW1LT+ICW1IL4
	OUT	ZM8259A+ICW1,AL	; Level triggered, cascaded
	MOV	AL,ZM8259AI	; Get Master base interrupt number
	OUT	ZM8259A+ICW2,AL	; Set interrupt base number
	MOV	AL,ICW3S3
	OUT	ZM8259A+ICW3,AL	; Slave is connected to line 3
	MOV	AL,ICW4UPM+ICW4SFN
	OUT	ZM8259A+ICW4,AL	; Set processor to 8086, special fully nested, nonbuffered

	MOV	AL,NOT (OCW1IM0 OR OCW1IM2 OR OCW1IM4 OR OCW1IM5 OR OCW1IM6)
	OUT	ZM8259A+OCW1,AL	; Allow Fatal hardware, timer, serial A,
				; serial B, and keyboard/video interrupts

	STI			; Now turn on interrutps

	

;
; Initialize PRN, AUX, and CON
;

; Init PRN

	MOV	BX,OFFSET CHRD_PRN ; Get addr of configuration table for PRN
	MOV	AH,CHR_CONTROL	; Get control function code
	MOV	AL,CHR_CFSU	; Get set up subfunction code
	PUSH	CS		; Make call into CALLF
	CALL	NEAR PTR BIOS_PRNFUNC ; Configure the printer, any errors ?
	JNC	BINITC1A	;   No, skip
	JMP	PRNERR		;   Yes, tell user


; Init AUX

BINITC1A:
	MOV	BX,OFFSET CHRD_AUX ; Get addr of configuration table for AUX
	MOV	AH,CHR_CONTROL	; Get control function code
	MOV	AL,CHR_CFSU	; Get set up subfunction code
	PUSH	CS		; Make call into CALLF
	CALL	NEAR PTR BIOS_AUXFUNC ; Configure the aux device, any errors ?
	JNC	BINITC1B	;   No, skip
	JMP	AUXERR		;   Yes, tell user


; Init CON

BINITC1B:
	MOV	BX,OFFSET CHRD_CON ; Get addr of configuration table for CON
	MOV	AH,CHR_CONTROL	; Get control function code
	MOV	AL,CHR_CFSU	; Get set up subfunction code
	PUSH	CS		; Make call into CALLF
	CALL	NEAR PTR BIOS_CONFUNC ; Configure the console, any errors ?
	JNC	BINITC1C	;   No, skip
	JMP	CONERR		;   Yes, tell user

BINITC1C:

;
; Print sign on message
;

;	MOV	BX,OFFSET SMESG	; Get addr of sign on message
;	MOV	CH,SMESGLB	; Get length of sign on message
;	CALL	PMESG		; Print message

; Check version of ROM for compatibility

	PUSH	DS
	MOV	DS,MTR_DS_VAL	; Get ROM's DS

	ASSUME	DS:MTR_D_SEG

	MOV	AL,DS:MTR_VER	; Get version number
	POP	DS

	ASSUME	DS:BIOS_SEG

	MOV	BYTE PTR ROM_VER,AL ; Save it for later
	CMP	AL,MTR_CVER	; Are versions compatable ?
	JNB	BINITFX		;   Yes, skip
	JMP	ROMERR		;   No, Show error

; Fix up disk tables to correspond with boot device

; Using the port number, device type, and unit number we must compute
; a BIOS disk number and an MSDOS drive number.
;

BINITFX:
	MOV	AL,BYTE PTR LDR_HDR+FMT_SEL ; Get select command
	MOV	AH,AL		; Save second copy
	CMP	AL,-1		; Boot from winchester
	JZ	BINITC1H9
	TEST	AL,CONDS8	; Is drive an 8 incher
	JZ	BINITC1D	;   No, skip

	MOV	BYTE PTR BDRIVE,MAXDSK5 ; Set up boot disk as 8 inch floppy
	JMP	SHORT BINITC1E	; Skip

BINITC1D:
	MOV	BYTE PTR BDRIVE,0 ; Set up boot disk as 5.25 inch floppy

BINITC1E:
	AND	AL,CONDS	; Issolate unit number
	ADD	BYTE PTR BDRIVE,AL ; Bump drive number

BINITC1H9:

;	Set up the winchester drive

	MOV	SI,2*MAXDSK8
	MOV	SI,DSK_TPTR[SI]		; Pointer to drive entries
	MOV	DI,WORD PTR DSK_PORT[SI]	; Port address

	MOV	CX,3			; Try max of 3 times
BINITW0A:
	MOV	DX,WISTA
	ADD	DX,DI
	IN	AL,DX			; Get status
	CMP	AL,WISDONE		; Check for DONE
	JZ	BINITW0			; If set
	DEC	CX			; Count one
	JNZ	BINITW0B		; If to try again
	JMP	NEAR PTR BINITD207	; No "DONE" in time, bail out
BINITW0B:
	MOV	DX,WIRES
	ADD	DX,DI
	OUT	DX,AL			; Bump the reset port
	PUSH	CX
	MOV	CX,WORD PTR DSK_DELAY[SI]	; Delay count
	CALL	ALARM_WAIT
	POP	CX
	JMP	BINITW0A

BINITW0:
	MOV	AL,WICSETUP
	MOV	DX,WICOM
	ADD	DX,DI
	OUT	DX,AL			; Issue SETUP command
	PUSH	DX
	MOV	CX,1000
	MOV	DX,WISTA
	ADD	DX,DI
BINITW1:
	IN	AL,DX
	TEST	AL,WISBUSY		; Controller responded?
	LOOPZ	BINITW1			; Not yet
	JCXZ	BINITD207		; Not in time, bail out

;	Compute address of DSK_WCB

	XOR	DX,DX
	MOV	BX,CS
	SHL	BX,1
	RCL	DX,1
	SHL	BX,1
	RCL	DX,1
	SHL	BX,1
	RCL	DX,1
	SHL	BX,1
	RCL	DX,1
	ADD	BX,OFFSET DSK_WCB
	ADC	DX,0			; DX:BX = 32 bit address
	MOV	AL,DL
	POP	DX
	OUT	DX,AL
	MOV	BYTE PTR DSK_WCB+WI3NCAH,AL
	MOV	AL,BH
	OUT	DX,AL
	MOV	BYTE PTR DSK_WCB+WI3NCAM,AL
	MOV	AL,BL
	OUT	DX,AL
	MOV	BYTE PTR DSK_WCB+WI3NCAL,AL
	CALL	NEAR PTR Z217INIT	; Check out boot drive stuff

BINITD207:
	MOV	BL,BYTE PTR BDRIVE ; Get new value
	XOR	BH,BH		; Clear upper part
	SHL	BX,1		; Convert to word ptr
	MOV	BX,DSK_TPTR[BX]	; Get disk table addr

; Store values from loader in table

	MOV	AH,BYTE PTR LDR_HDR+FMT_SEL
	CMP	AH,-1
	JZ	BINITC1EA	; If select byte alread set
	MOV	BYTE PTR DSK_SEL[BX],AH ; Store select command
	MOV	AL,BYTE PTR LDR_HDR+FMT_FLG ; Get flag byte
	MOV	AH,BYTE PTR DSK_FLAG[BX] ; Get flag byte in table
	AND	AL,DSK_FDS OR DSK_FDP	; Isolate double sided/double step
	AND	AH,NOT (DSK_FDS OR DSK_FDP) ; Remove those from table value
	OR	AL,AH			; Put them together
	MOV	BYTE PTR DSK_FLAG[BX],AL ; Put it in table 
	MOV	AX,WORD PTR LDR_HDR+FMT_SECS ; Get bytes per sector
	MOV	WORD PTR DSK_BPS[BX],AX ; Store it 
	MOV	AL,BYTE PTR LDR_HDR+FMT_SPT ; Get sectors per track
	MOV	BYTE PTR DSK_SPT[BX],AL ; Store it


; Fixup the base port number in the disk table

BINITC1EA:
	MOV	DX,WORD PTR DSK_PORT[BX] ; Get default base port number
	MOV	AX,WORD PTR LDR_HDR+FMT_PORT ; Get boot base port number
	CMP	AX,DX		; Are boot and default ports the same ?
	JE	BINITC1H	;   Yes, nothing to do
	MOV	SI,OFFSET DSK_TPTR ; Get addr of disk vector
BINITC1F:
	MOV	BX,[SI]		; Get the addr of the next DSK table
	CMP	BX,-1		; Are we finished ?
	JE	BINITC1H	;   Yes, exit loop

	CMP	DX,WORD PTR DSK_PORT[BX] ; Is base port the default port ?
	JNE	BINITC1G	;   No, skip
	MOV	WORD PTR DSK_PORT[BX],AX ; Yes, store boot port
BINITC1G:
	ADD	SI,2		; Point to next vector entry
	JMP	BINITC1F	; Do next entry

BINITC1H:
	MOV	SI,OFFSET DSK_TPTR ; Get addr of DSK vector
	MOV	WORD PTR EXSTDRV,0 ; Flag all drives as existing

; Reset each disk drive, and flag non-existant ones

	MOV	CX,MAXDSK8	; Get down counter for disks to do
	MOV	AL,0		; AL has drive number(starts at zero)

RSTDRV:	MOV	BYTE PTR DSKPR+DSKPR_DRIVE,AL ; Set drive to use
	PUSH	SI		; Save regs
 	PUSH	CX
	MOV	BX,[SI]		; Get addr of DSK table
	MOV	AH,DSK_FLAG[BX]	; Get flag byte
	AND	BYTE PTR DSK_FLAG[BX],NOT DSK_FRS ; Turn off double restore
	PUSH	AX
	MOV	BX,OFFSET DSKPR ; Get addr of parm pkt for DSK
	MOV	AL,DSK_RESET
	PUSH	SI
	CALL	DSK		; Reset the drive
	POP	SI

; Check for track 0 indicator

	TEST	AL,FDSTK0	; Is track zero seen ?
	JNZ	RSTDRV1		;   Yes, drive exists - skip

; No track zero, flag drive is imaginary

	POP	AX		; Get drive number
	PUSH	AX
	MOV	BX,[SI]		; Get addr of DSK table
	MOV	BYTE PTR DSK_IMGFLG[BX],DSKIF_ID ; Mark drive as imaginary
	MOV	CL,AL		; Turn on proper bit to show as non existant
	MOV	AX,1
	SHL	AX,CL
	OR	WORD PTR EXSTDRV,AX ; Set bit for non existant
	JMP	SHORT RSTDRV3	; Don't bother to step in/out

RSTDRV1:

; Step head in 

	MOV	CX,FDSTEPS	; Number of steps to take
RSTDRV2:
	PUSH	CX		; Save count
	MOV	AL,DSK_STEPIN	; Get function
	MOV	BX,OFFSET DSKPR ; Get addr of parm table
	CALL	DSK		; Step in head
	POP	CX		; Recover count
	LOOP	RSTDRV2		; Decr count and loop if not finished

; Now restore head again

	MOV	BX,OFFSET DSKPR	; Get addr of parm table
	MOV	AL,DSK_RESET	; Get function
	CALL	DSK		; Reset drive

RSTDRV3:
	POP	AX		; Restore regs
	POP	CX
	POP	SI
	MOV	BX,[SI]		; Get addr of DSK table
	MOV	BYTE PTR DSK_FLAG[BX],AH ; Restore flags
	INC	AL		; Bump drive index
	ADD	SI,2		; Point to next vector entry
	LOOP	RSTDRV		; Do next drive

; Now map non-existant drives into imaginary ones

	MOV	AX,WORD PTR EXSTDRV ; Get bit vector of existance
	AND	AX,1111B	; 0FFFFH SHR (16-MAXDSK5) ; Only look at 5 inchers
	XOR	BX,BX		; Get index zero in DSK vector
	MOV	CX,MAXDSK5	; Get count
	CALL	MAPDRV		; Map those drives
	MOV	AX,WORD PTR EXSTDRV ; Get bit vector of existance
	MOV	CX,MAXDSK5	; Skip over 5 inchers
	SHR	AX,CL
	AND	AX,1111B		; look at 8 inchers
	MOV	BX,MAXDSK5*2	; Get word index into DSK vector
	MOV	CX,MAXDSK8-MAXDSK5 ; Get count
	CALL	MAPDRV		; Map those drives

;
; Read in the DOS (at a location after the BIOS)
;

	MOV	BX,DOS_ISEG	; Get initial segment to put DOS

; Read first directory block

	MOV	WORD PTR DSKPR+DSKPR_BUFF+2,BX ; Store in disk packet
	MOV	WORD PTR DSKPR+DSKPR_BUFF,0 ; Set offset
	MOV	AL,BDRIVE	; Get boot drive number
	MOV	BYTE PTR DSKPR+DSKPR_DRIVE,AL ; Store drive number
	MOV	BX,WORD PTR LDR_HDR+FMT_DIR ; Get sector number of directory
	MOV	WORD PTR DSKPR+DSKPR_SECTOR,BX ; Store in table
	MOV	WORD PTR DSKPR+DSKPR_COUNT,1 ; Read one sector
	MOV	BX,OFFSET DSKPR	; Get addr of packet
	MOV	AL,DSK_READ	; Get function
	CALL	DSK		; Read a sector, did an error occur ?
	JNC	BINIC2		;   No, skip
	JMP	DSKERR		;   Yes, go handle it
BINIC2:

; Check if the second entry in the directory is the DOS

	MOV	BX,DOS_ISEG	; Get para addr directory
	MOV	DS,BX
	MOV	CX,DE_ATTR-DE_FNAME ; Get length of name
	MOV	SI,DE_SIZE+DE_FNAME ; Get offset of second name
	MOV	DI,OFFSET DOS_NAME ; Get addr of Name of DOS
	REPE CMPSB		; Are the names equal ?
	JE	BINIC3		;   Yes, skip
	PUSH	CS		;   No, Recover DS
	POP	DS
	JMP	DOSERR		; Go print message
BINIC3:

; Read in the DOS

	MOV	AX,WORD PTR DS:[DE_SIZE+DE_START] ; Get starting alloc unit
	MOV	BX,WORD PTR DS:[DE_SIZE+DE_FSIZE] ; Get file size(<64K)

	PUSH	CS		; Recover DS
	POP	DS

	SUB	AX,2		; Zero base starting allocation unit
	MOV	CL,BYTE PTR LDR_HDR+FMT_CLST ; Get shift count
	SHL	AX,CL		; Make into a sector offset in data area
	ADD	AX,WORD PTR LDR_HDR+FMT_DATA ; Convert to a logical sector
	MOV	WORD PTR DSKPR+DSKPR_SECTOR,AX ; Store in table
	ADD	BX,WORD PTR LDR_HDR+FMT_SECS ; Round up to sector boundary
	DEC	BX
	MOV	CL,BYTE PTR LDR_HDR+FMT_SHFT ; Get sector shift
	SHR	BX,CL		; Compute number of sectors to read
	MOV	WORD PTR DSKPR+DSKPR_COUNT,BX ; Store in table
	MOV	WORD PTR DSKPR+DSKPR_BUFF,0 ; Set offset
	MOV	BX,OFFSET DSKPR	; Get addr of DSK table
	MOV	AL,DSK_READ	; Get function code
	CALL	DSK		; Read the DOS in, did error occur ?
	JNC	BINIT_MSDOS	;   No, skip
	JMP	DSKERR		;   Yes, handle it

BINIT_MSDOS:

; Set up character font information

	MOV	WORD PTR FNT_RAM,OFFSET FNT_TAB ; Store RAM font table addr
	MOV	WORD PTR FNT_RAM+2,CS	; Save RAM paragraph for font
	MOV	WORD PTR FNT_SIZE,MTR_FNT_SIZE ; Assume Version 1 of ROM
	MOV	WORD PTR FNT_MSIZE,MTR_FNT_SIZE ; Store allocated space
	MOV	DS,MTR_DS_VAL	; Get ROM DS value
	CMP	BYTE PTR DS:MTR_VER,1 ; Is ROM version 1
	JE	GET_FNT		;   Yes, skip

; Not version 1, Check out actual size

	MOV	BX,WORD PTR DS:MTR_FNTSIZ ; Get real FONT size
	MOV	WORD PTR CS:FNT_SIZE,BX	; Set it in

GET_FNT:
	MOV	BX,DS:WORD PTR MTR_FONT	; Get offset of font table
	MOV	DX,DS:WORD PTR MTR_FONT+2 ; And paragraph address
	MOV	DS:WORD PTR MTR_FONT,OFFSET FNT_TAB ; Set up our local font
	MOV	DS:WORD PTR MTR_FONT+2,CS ; And set in page value as well
	MOV	CS:WORD PTR FNT_ROM,BX ; Save addr of font
	MOV	CS:WORD PTR FNT_ROM+2,DX

;
; Move in Font table
;

MOVE_FNT:
	MOV	DS,DX		; Get addr of ROM's font table
	MOV	SI,BX
	MOV	DI,OFFSET FNT_TAB ; Get addr to copy it
	PUSH	CS
	POP	ES
	MOV	CX,WORD PTR CS: FNT_SIZE ; Get size of table
	REP	MOVSB		; Move in the new font table
	MOV	AX,CS		; Restore DS, ES
	MOV	DS,AX
	MOV	ES,AX

; Turn on keyboard

	CLI			; Turn off interrupts
	MOV	AL,ZKEYEI	; Enable keyboard interrupts
	CALL	OUTKEY
	MOV	AL,ZKEYEK	; Enable keyboard
	CALL	OUTKEY

; Set up variables for SYSINIT

	MOV	AX,SEGSYSINIT	; Get SYSINIT's seg
	MOV	DS,AX

    ASSUME	DS:SEG SYSINIT

	MOV	DS:CURRENT_DOS_LOCATION,DOS_ISEG ; Store DOS segment
	MOV	AX,CS
	MOV	WORD PTR DS:DEVICE_LIST,OFFSET BIOS_DEVS ; Store ptr to devs
	MOV	WORD PTR DS:DEVICE_LIST+2,AX
	MOV	BX,OFFSET DOS_START
	XOR	CX,CX
	MOV	ES,CX		; ES:0 = interrupt pag
	MOV	ES,ES:WORD PTR [MTR_DS]	; ES = mtr data segment
	ADD	BX,ES:WORD PTR [MTR_DS_SIZE]
	ADD	BX,15		; BX = total size of space needed
	MOV	CL,4
	SHR	BX,CL
	ADD	AX,BX
	MOV	DS:FINAL_DOS_LOCATION,AX
	MOV	AL,CS:BDRIVE
	INC	AL
	MOV	DS:DEFAULT_DRIVE,AL
	MOV	DS:BYTE PTR BUFFERS,DOS_BUF_COUNT

; Fix up stack (Big kludge caused by SYSINIT module)

	CLI			; Turn off interrupts before modifying SS/SP
	MOV	SP,OFFSET BIOS_STACK-128 ; Set up stack pointer
	DEC	CS:WORD PTR RECURLV
	STI
	MOV	AX,CS:SEGSYSINIT
	PUSH	AX
	MOV	AX,OFFSET SYSINIT
	PUSH	AX
	RETF			; Enter the code
	PAGE
;
; MAPDRV - Map non-existant drives into imaginary ones
;
;     Call with:
;         BX = Word index in DSK of first drive
;         AX = Bit vector showing if a drive exists
;         CX = Number of entries to try
;	  EXSTDRV = Bit vector - 1 bits for each nonexistant drive
;
;     On exit:
;         Nonexistant drives flagged as such, and mapped
;			to a physical disk drive
;
;     USES: All registers
;

	ASSUME	DS:BIOS_SEG

MAPDRV	PROC	NEAR
	PUSH	BX		; Save drive index  
	MOV	BX,DSK_TPTR[BX] ; Get addr of DSK entry
	MOV	WORD PTR MAPDRVA,BX ; Save first entry addr
	MOV	WORD PTR MAPDRVB,BX ; And current entry
	MOV	WORD PTR MAPDRVC,CX ; Save count
	POP	BX		; Restore drive index
	SHR	BX,1		; Save first drive number
	MOV	BYTE PTR MAPDRVD,BL

; Now map each drive that has a 1 bit in AX set

MAPDRV1:
	SHR	AX,1		; Is drive nonexistant ?
	JNC	MAPDRV6		;   No, no need to map this guy

; Must map this drive

MAPDRV2:
	PUSH	AX		; Save bit vector and count
	PUSH	CX

; MAPDRVB has current entry, MAPDRVA has first entry
; and MAPDRVC has number of entries to test for

	MOV	SI,MAPDRVB	; SI has entry to map
	MOV	DI,MAPDRVA
	MOV	CX,MAPDRVC	; Start looking
	MOV	AL,BYTE PTR MAPDRVD ; Get drive number
MAPDRV3:
	TEST	BYTE PTR DSK_IMGFLG[DI],DSKIF_ID+DSKIF_NM ; Does drive exist
	JNZ	MAPDRV4		;   No, This is a phony drive too!

; Have a valid drive

	OR	BYTE PTR DSK_IMGFLG[SI],AL ; Set drive to map
	JMP	SHORT MAPDRV5	; Exit loop

; No valid drive yet

MAPDRV4:
	ADD	DI,DSK_SIZE	; Point to next entry
	INC	AL		; Bump drive number
	LOOP	MAPDRV3		; Keep looking

; Could not find a mate for this one

	MOV	BYTE PTR DSK_IMGFLG[SI],DSKIF_DV+DSKIF_NM ; Flag valid

; Have mapped this one

MAPDRV5:
	POP	CX		; Recover regs
	POP	AX

MAPDRV6:
	ADD	WORD PTR MAPDRVB,DSK_SIZE ; Bump to next
	LOOP	MAPDRV1		; Once for each drive
	RET

MAPDRV	ENDP

;
;	RE_INIT - Set up the rest of stuff
;

RE_INIT	PROC	FAR
	PUSH	AX
	PUSH	BX
	PUSH	DX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	PUSH	BP

	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX

; Turn on parity checking(if specified)

	MOV	AL,CS:BIOS_MCL	; Get value of memory control latch
	OUT	ZMCL,AL		; Output it

	MOV	DX,Z205BA
	MOV	CX,Z205BMC
MEMIL01:
	OUT	DX,AL		; Set up all z-205's
	INC	DX
	LOOP	MEMIL01

    IF LOAD_FONT
	CALL	FONTLD
    ENDIF

	POP	BP
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	CX
	POP	DX
	POP	BX
	POP	AX
	RET
RE_INIT	ENDP

;	Send data to keyboard processor

OUTKEY	PROC	NEAR
	PUSH	AX
OUTKEY1:
	IN	AL,ZKEYBRDS
	TEST	AL,ZKEYIBF		; Wait for input buffer empty
	JNZ	OUTKEY1
	POP	AX
	OUT	ZKEYBRDC,AL
	RET
OUTKEY	ENDP

;***	INIT217 - 217 controller inits
;
;	This code initializes the 217 with a SET DRIVE command. The
;	information for this command is obtained from sector zero
;	of the SBC. NOTE: this code is only called if the 217 controller
;	responds to STATUS in time
;

	ASSUME	DS:BIOS_SEG,ES:BIOS_SEG

Z217INIT:
	CMP	BYTE PTR LDR_HDR+FMT_SEL,0FFH
	JNZ	INIT217B			; If not, all done

	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	DS,DS:MTR_DS
	MOV	AL,BYTE PTR DS:MTR_BUNIT
	POP	DS
	MOV	CL,5
	SHL	AL,CL
	MOV	BYTE PTR DSKPR+DSKPR_BUFF+1,AL	; Unit number
	MOV	BYTE PTR DSKPR+DSKPR_BUFF+2,0	; Assume 512
	CMP	WORD PTR LDR_HDR+FMT_SECS,512
	JZ	SHORTDRV
	MOV	BYTE PTR DSKPR+DSKPR_BUFF+2,-1	; Is a big disk
SHORTDRV:
	MOV	AX,WORD PTR LDR_HDR+FMT_NPS
	MOV	BX,WORD PTR LDR_HDR+FMT_NRS	; AX = size, BX = start
	MOV	WORD PTR DSKPR+DSKPR_SECTOR,BX
	MOV	WORD PTR DSKPR+DSKPR_COUNT,AX	; Set them in
	MOV	BYTE PTR DSKPR+DSKPR_BUFF,0	; Set partition flag to 0
	MOV	BYTE PTR DSKPR+DSKPR_DRIVE,MAXDSK8
	MOV	AL,DSK_ASSIGN
	MOV	BX,OFFSET DSKPR
	PUSH	ES
	MOV	CX,CS
	MOV	ES,CX
	CALL	DSK				; Do the implied assign
	POP	ES
	MOV	BYTE PTR BDRIVE,MAXDSK8		; Boot drive E:
INIT217B:
	CLC
	RET

;
; Errors during init
;

DSKERR:
	MOV	BX,OFFSET DSKMESG ; Get addr of message
	MOV	CH,OFFSET DSKMESGL ; Get Length of message
	CALL	PMESG		; Print message
DSKERRL: JMP	SHORT DSKERRL


DOSERR:
	MOV	BX,OFFSET DOSMESG ; Get addr of message
	MOV	CH,OFFSET DOSMESGL ; Get length of message
	CALL	PMESG		; Print message
DOSERRL: JMP	SHORT DOSERRL


TIMERR:
	MOV	BX,OFFSET TIMMESG ; Get addr of error message
	MOV	CH,OFFSET TIMMESGL ; Get length of error message
	CALL	PMESG		; Print message
TIMERRL: JMP	SHORT TIMERRL	; Loop forever

PRNERR:
	MOV	BX,OFFSET PRNMESG ; Get addr of error message
	MOV	CH,OFFSET PRNMESGL ; Get length of error message
	CALL	PMESG		; Print message
PRNERRL: JMP	SHORT PRNERRL	; Loop forever

AUXERR:
	MOV	BX,OFFSET AUXMESG ; Get addr of error message
	MOV	CH,OFFSET AUXMESGL ; Get length of error message
	CALL	PMESG		; Print message
AUXERRL: JMP	SHORT AUXERRL	; Loop forever

CONERR:
	MOV	BX,OFFSET CONMESG ; Get addr of error message
	MOV	CH,OFFSET CONMESGL ; Get length of error message
	CALL	PMESG		; Print message
CONERRL: JMP	SHORT CONERRL	; Loop forever

ROMERR:
	MOV	BX,OFFSET ROMMESG ; Get addr of error message
	MOV	CH,OFFSET ROMMESGL ; Get length of error message
	CALL	PMESG		; Print message
ROMERRL: JMP	SHORT ROMERRL	; Loop forever

VERERR:
	MOV	BX,OFFSET VERMESG ; Get addr of error message
	MOV	CH,OFFSET VERMESGL ; Get length of error message
	CALL	PMESG		; Print message
VERERRL: JMP	SHORT VERERRL	; Loop forever

COMERR:
	MOV	BX,OFFSET COMMESG ; Get addr of message
	MOV	CH,OFFSET COMMESGL ; Get length of message
	CALL	PMESG		; Print the message
COMERRL: JMP	SHORT COMERRL	; Loop forever


COMMESG	DB	CC_CR,CC_LF,CC_LF
	DB	'Error loading COMMAND.COM'
	DB	CC_CR,CC_LF,CC_LF
COMMESGL  =	(OFFSET $)-(OFFSET COMMESG)

DSKMESG DB	CC_CR,CC_LF,CC_LF
	DB	'Disk read error'
	DB	CC_CR,CC_LF,CC_LF
DSKMESGL =	(OFFSET $)-(OFFSET DSKMESG)

DOSMESG	DB	CC_CR,CC_LF,CC_LF
	DB	'Disk is not a system disk'
	DB	CC_CR,CC_LF,CC_LF
DOSMESGL =	(OFFSET $)-(OFFSET DOSMESG)

TIMMESG	DB	CC_CR,CC_LF,CC_LF
	DB	'Timer failure'
	DB	CC_CR,CC_LF,CC_LF
TIMMESGL =	(OFFSET $)-(OFFSET TIMMESG)

PRNMESG	DB	CC_CR,CC_LF,CC_LF
	DB	'PRN Configured wrong'
	DB	CC_CR,CC_LF,CC_LF
PRNMESGL =	(OFFSET $)-(OFFSET PRNMESG)

AUXMESG	DB	CC_CR,CC_LF,CC_LF
	DB	'AUX Configured wrong'
	DB	CC_CR,CC_LF,CC_LF
AUXMESGL =	(OFFSET $)-(OFFSET AUXMESG)

CONMESG	DB	CC_CR,CC_LF,CC_LF
	DB	'CON Configured wrong'
	DB	CC_CR,CC_LF,CC_LF
CONMESGL =	(OFFSET $)-(OFFSET CONMESG)

VERMESG DB	CC_CR,CC_LF,CC_LF
	DB	'Version mismatch between BIOS and LOADER'
	DB	CC_CR,CC_LF,CC_LF
VERMESGL =	(OFFSET $)-(OFFSET VERMESG)

ROMMESG	DB	CC_CR,CC_LF,CC_LF
	DB	'Version mismatch between BIOS and system ROM'
	DB	CC_CR,CC_LF,CC_LF
ROMMESGL =	(OFFSET $)-(OFFSET ROMMESG)


;
;  Data values for BIOS_INIT
;

LDR_HDR		DB	FMT_SIZE DUP(?)	; Local storage for Loader header

BDRIVE		DB	?		; Boot disk number

MAPDRVA		DW	?		; Word index of start
MAPDRVB		DW	?		; Word index of current
MAPDRVC 	DW	?		; Number of entries 
MAPDRVD 	DB	?		; Drive number

EXSTDRV		DW	?		; Bit vector of drive existance

ROM_VER		DB	?		; Version number from rom
MTR_DS_VAL	DW	?		; Monitor ds value
MEMSIZFLG	DW	0		; Memory sizing flag

DOS_NAME	DB	'MSDOS   SYS'

SEGSYSINIT	DW	0		; New segment for SYSINIT

RWA		=	(OFFSET $)-(OFFSET BINIT_START)
	IF (RWA AND 0FH) NE 0
		ORG	RWA+(16-(RWA AND 0FH))	; Force to 16 byte bound
	ENDIF

;	Start of dynamic allocation group

DSK_BUF		LABEL	NEAR		; Disk buffer for I/O
FNT_TAB		EQU	DSK_BUF+1024	; Start of font table
FNT_END		EQU	FNT_TAB+MTR_FNT_SIZE
STACK_START	EQU	FNT_END+0	; Bios internal stack
BIOS_STACK	EQU	STACK_START+256	; Stack end location
Q_ZCON		EQU	BIOS_STACK+0	; Console input que
Q_ZSERA		EQU	Q_ZCON+ZCON_IQS	; Serial A input que
Q_ZSERB		EQU	Q_ZSERA+ZSERA_IQS	; Serial B input que
ROM_WA		EQU	Q_ZSERB+ZSERB_IQS	; Start of rom work area
DOS_START	EQU	ROM_WA		; Relocated after ROM_WA size known

;	Define move size of SYSINIT module

RELOC_SIZE	=	(OFFSET DOS_START)-(OFFSET DSK_BUF)

BIOS_SEG	ENDS
		END


