;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

;
; Define the parameters for the Z-217 controller
;
; 11/22/82 - bcb
;

Z217SPT		EQU 9		; Sectors/track
Z217BPS		EQU 1024		; Bytes/sector

; Define the port offsets

WICOM		EQU 0		; Command port offset
WISTA		EQU 0		; Status port offset
WIRES		EQU 1		; Reset port offset
WIACK		EQU 1		; Interrupt ackowledge port offset

; Define status register bits

WISINT		EQU 80H		; Interrupt
WISBUSY		EQU 40H		; Busy
WISTMAIP	EQU 20H		; TMA in progress
WISBUM		EQU 10H		; Burst mode
WISERR		EQU 08H		; Error
WISIME		EQU 04H		; Immediate mode error
WISPAUS		EQU 02H		; Paused
WISDONE		EQU 01H		; Done

; Define the commands

WICBOOT		EQU 00H		; Boot
WICSETUP	EQU 08H		; Setup
WICEXE		EQU 10H		; Execute
WICPAU		EQU 18H		; Pause
WICCONT		EQU 20H		; Continue

; Define the Flag byte

WIFIEN		EQU 80H		; Interrupts enabled
WIFUBUM		EQU 40H		; Use burst mode
WIFIPC		EQU 20H		; Ignore PAUSE and CONT
WIFDR		EQU 04H		; Disable retries
WIFDECC		EQU 02H		; Disable ecc errors
WIFCHAIN	EQU 01H		; Chain next command

; Define the control block commands

WICBRCL		EQU 00H		; Recal drive
WICBSTS		EQU 01H		; Read drive status

WICBRDL		EQU 11H		; Read logical
WICBWRL		EQU 10H		; Write logical
WICBSKL		EQU 13H		; Seek logical

WICBFMD		EQU 20H		; Format drive
WICBFMT		EQU 21H		; Format track
WICBSDP		EQU 22H		; Set drive parameters

WICBWRA		EQU 30H		; Write absolute
WICBRDA		EQU 31H		; Read absolute
WICBSKA		EQU 33H		; Seek absolute

; Define a type 0/1 control block

WI1COM		EQU 0		; Command
WI1DSHS		EQU WI1COM+1	; Drive select in bits 7-5, sector number 4-0
WI1SECH		EQU WI1DSHS+1	; Sector number(high)
WI1SECL		EQU WI1SECH+1	; Sector number(low)
WI1CNT		EQU WI1SECL+1	; Sector count (0=256)
WI1TMAH		EQU WI1CNT+1	; Data TMA addr(high)
WI1TMAM		EQU WI1TMAH+1	; Data TMA addr(middle)
WI1TMAL		EQU WI1TMAM+1	; Data TMA addr(low)
WI1NCAH		EQU WI1TMAL+1	; Next command addr(high)
WI1NCAM		EQU WI1NCAH+1	; Next command addr(middle)
WI1NCAL		EQU WI1NCAM+1	; Next command addr(low)
WI1FLAGS	EQU WI1NCAL+1	; Flags
WI1ERR		EQU WI1FLAGS+1	; Error code
WI1HSE		EQU WI1ERR+1	; Head in bits 7-5, sector in 4-0 of error
WI1SCHE		EQU WI1HSE+1	; Sector number(high) of error
WI1SCLE		EQU WI1SCHE+1	; Sector number(low) of error
WI1_SIZE	EQU WI1SCLE+1	; Size of control block

; Define a type 2 control block

WI2COM		EQU 0		; Command
WI2DSHS		EQU WI2COM+1	; Drive/max head number
WI2MCH		EQU WI2DSHS+1	; Max cylinder hi
WI2MCL		EQU WI2MCH+1	; Max cylinder lo
WI2RWCH		EQU WI2MCL+1	; Reduced write current hi
WI2RWCL		EQU WI2RWCH+1	; Reduced write current lo
WI2PCH		EQU WI2RWCL+1	; Precomp hi
WI2PCL		EQU WI2PCH+1	; Precomp lo
WI2SRC		EQU WI2PCL+1	; Step rate code
WI2ECS		EQU WI2SRC+1	; ECC correction span to use
WI2CIF		EQU WI2ECS+1	; Cell size and interleave factor
WI2FFC		EQU WI2CIF+1	; fill character for formatting

; Define a type 3 control block

WI3COM		EQU 0		; Command
WI3DSHS		EQU WI3COM+1	; Drive select bits 7-5, head select in 2-0
WI3CYH		EQU WI3DSHS+1	; Cylinder number(high)
WI3CYL		EQU WI3CYH+1	; Cylinder number(low)
WI3SEC		EQU WI3CYL+1	; Sector number
WI3TMAH		EQU WI3SEC+1	; Data TMA addr(high)
WI3TMAM		EQU WI3TMAH+1	; Data TMA addr(middle)
WI3TMAL		EQU WI3TMAM+1	; Data TMA addr(low)
WI3NCAH		EQU WI3TMAL+1	; Next command addr(high)
WI3NCAM		EQU WI3NCAH+1	; Next command addr(middle)
WI3NCAL		EQU WI3NCAM+1	; Next command addr(low)
WI3FLAGS	EQU WI3NCAL+1	; Flags
WI3ERR		EQU WI3FLAGS+1	; Error code
WI3HSE		EQU WI3ERR+1	; Head in bits 7-5, sector in 4-0 of error
WI3CYHE		EQU WI3HSE+1	; Cylinder number(high) of error
WI3CYLE		EQU WI3CYHE+1	; Cylinder number(low) of error
WI3_SIZE	EQU WI3CYLE+1	; Size of control block

; Define the error codes

WIENO		EQU 00H		; No error
WIEDNR		EQU 01H		; Drive not ready
WIENSC		EQU 02H		; No seek complete
WIENTZ		EQU 03H		; No track 0
WIENI		EQU 04H		; No index
WIENDS		EQU 05H		; No drive selected

WIEHNF		EQU 10H		; Header A.M. not found
WIESKE		EQU 11H		; Seek error
WIESNF		EQU 12H		; Sector not found
WIEHECC		EQU 13H		; ECC error in header
WIEDAM		EQU 14H		; Data A.M. not found
WIENECC		EQU 15H		; Non-Correctable ECC error in data field
WIECECC		EQU 16H		; Correctable ECC error in data field
WIEWF		EQU 17H		; Write fault

WIEIOC		EQU 20H		; Illegal op code
WIEIDA		EQU 21H		; Illegal disk addr
WIEFP		EQU 22H		; Format protected
WIEWP		EQU 23H		; Write protected

WIEMISC		EQU 30H		; Miscellaneous error

WIEDIAG		EQU 40H		; Error during diagnostic

