;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
;  DSK - This routine provides the necessary code to perform all disk I/O.
;
;        The particular function to perform is passed in the AL register.
;
;  Call with:
;
;    The register pair ES:BX points to a parameter block(for all functions
;    except GBIOSVEC and  MAPDSK) with the following fields:
;
;      DSKPR_DRIVE (byte):
;         Logical drive number (0-MAXDSK allowed)
;      DSKPR_SECTOR (word):
;         Logical sector number
;            (0-drive_max allowed)
;         (On read/write track function, side flag:
;            0 - side zero, 1 - side one)
;      DSKPR_COUNT (word):
;	transfer count
;            (1-?? (total bytes must fit within the same segment))
;      DSKPR_BUFF (double word):
;         Address of buffer. The first word is the offset, the second word is
;         the segment.
;
;  Register AL has the function to perform
;   (AL) = DSK_RESET - Reset disk(home head)
;   (AL) = DSK_STATUS - Get disk status(on success AH=aux status,AL=status)
;   (AL) = DSK_STEPIN - Step in head
;   (AL) = DSK_READ - Read the specified sectors to the buffer addr
;   (AL) = DSK_WRITE - Write the specified sectors from the buffer addr
;   (AL) = DSK_VERIFY - Verify the specified sectors. (Not implemented yet)
;   (AL) = DSK_FORMAT - Format a track.
;           The write track command is used to write the data at DSK_BUF.
;   (AL) = DSK_READTRK - Perform the read track command.
;   (AL) = DSK_GBIOSVEC - Get addr of disk vector used by the BIOS in ES:BX.
;   (AL) = DSK_MAPDSK - Maps logical in AH to physical in AL
;   (AL) = DSK_SETFDC - Set force disk has been changed flag(DSK_FDC)
;   (AL) = DSK_PREAD - Same as DSK_READ but do not apply BSEC value
;   (AL) = DSK_ASSIGN - Set up BSEC and FATS values in partition
;   (AL) = DSK_PWRITE - Same as DSK_WRITE but no BSEC applied
;
;  Returns:
;   AX = Status of operation
;         (See DEFDSK.ASM)
;   CY = 0 - Operation was a success
;   CY = 1 - Operation failed (see AX)
;   For DSK_READ and DSK_WRITE:
;     DSKPR_COUNT = number of sectors not read/written
;     DSKPR_BUFF = Addr at end of read/write
;   For DSK_GBIOSVEC:
;     ES:BX -> vector of disk table addresses
;
;
;  All register are used.
;  Segment registers are perserved.
;  (DS must be set up before call)
;
;  Last modified: 9/28/82 - bcb
;

BDSK217	PROC	NEAR

	JMP	WORD PTR DSKW1[DI] ; Case to function

DSKW1	DW      OFFSET DSKWFRS	; Reset function
  	DW	OFFSET DSKWFST	; Status function
	DW	OFFSET DSKWFRD	; Read function
	DW	OFFSET DSKWFWR	; Write function
	DW	OFFSET DSKWFVF	; Verify function
	DW	OFFSET DSKWFFT	; Format function
	DW	OFFSET DSKWFSI	; Step in function
	DW	OFFSET DSKWFRT	; Read track function
	DW	OFFSET DSKBDO	; GBIOSVEC
	DW	OFFSET DSKBDO	; MAPDSK
	DW	OFFSET DSKBDO	; SETFDC
	DW	OFFSET DSKWPRD	; PREAD
	DW	OFFSET DSKWASN	; ASSIGN
	DW	OFFSET DSKWPWR	; PWRITE

	PAGE
;
;  Reset(home) function for winchester
;
;      Clears errors and moves head to track zero.
;
;  Call with:
;      ES:BX -> parameter block addr
;      SI -> disk table
;
;  Returns:
;      CY clear - no errors
;      CY set - errors
;

DSKWFRS:
	CLC			; No errors on RESET
	RET			;   and return

	PAGE
;
;  DSKWFST - Status function for winchester
;
;      Clear errors and get current status.
;
;
;  Call with:
;      ES:BX -> parameter block addr
;      SI -> disk table
;
;  Returns:
;      CY clear - no errors
;      CY set - errors
;

DSKBDO:				; Bad operation
DSKWFST:
	MOV	AX,DSKST_NIERR	; Get not implemented error code
	STC			; Show error
	RET			;   and return

	PAGE
;
;  DSKWFVF - verify function for winchester
;
;      (we haven't decided what we want to do with this)
;
;  Call with:
;      ES:BX -> parameter block addr
;      SI -> disk table
;
;  Returns:
;      CY clear - no errors
;      CY set - errors
;

DSKWFVF:
	MOV	BYTE PTR VERFLG,1	; Flag to verify only
	JMP	DSKWFRDV		; Perform normal read

	PAGE
;
;  DSKWASN - Assign Partition
;

	PUBLIC	ASSNFLG,ASNFL2

ASSNFLG	DB	0				; Bits set when assign done
ASNFL2	DB	0				; Bit set if assign ever done

DSKWASN:
	OR	BYTE PTR DSK_FLAG[SI],DSK_ASN	; Show it has been assigned
	MOV	CX,ES:WORD PTR DSKPR_SECTOR[BX]	; Base sector number
	MOV	WORD PTR DSK_BSEC[SI],CX
	MOV	CX,ES:WORD PTR DSKPR_COUNT[BX]
	MOV	WORD PTR DSKW_NPS[SI],CX	; Partition size
	MOV	AL,ES:BYTE PTR DSKPR_BUFF[BX]
	MOV	BYTE PTR DSK_SEL[SI],AL		; Set in partition flags
	MOV	AL,ES:BYTE PTR DSKPR_BUFF+1[BX]
	MOV	BYTE PTR DSKW_WUN[SI],AL
	MOV	DI,OFFSET BPBVEC
	MOV	AL,ES:BYTE PTR DSKPR_DRIVE[BX]	; Get drive
	PUSH	AX
	SUB	AL,MAXDSK8
	MOV	CL,AL
	MOV	AL,1
	SHL	AL,CL
	OR	BYTE PTR ASSNFLG,AL
	POP	AX
	XOR	AH,AH
	SHL	AX,1
	ADD	DI,AX				; SI points to BPB
	MOV	DI,WORD PTR [DI]

;	DI = Pointer to BPB for this drive, assume it is 1k

	MOV	WORD PTR [DI].BPB_SECSZ,1024	; Assume 1k
	MOV	WORD PTR [DI].BPB_RES,1
	MOV	WORD PTR DSK_BPS[SI],1024
	TEST	BYTE PTR ES:DSKPR_BUFF+2[BX],0FFH
	JNZ	ASN1024
	MOV	WORD PTR [DI].BPB_SECSZ,512	; Nope, is 512
	MOV	WORD PTR [DI].BPB_RES,2
	MOV	WORD PTR DSK_BPS[SI],512
ASN1024:
	MOV	CX,ES:WORD PTR DSKPR_COUNT[BX]	; Number of sectors
	MOV	WORD PTR [DI].BPB_SECS,CX

;	Calculate FAT size for BPB and DSK tables

	SUB	CX,WORD PTR [DI+BPB_RES]	; Subtract out reserved
	MOV	AX,32
	MUL	WORD PTR [DI+BPB_DIRENTS]	; AX = bytes/director
	DIV	WORD PTR [DI+BPB_SECSZ]		; CX = sector size
	SUB	CX,AX
	MOV	AX,CX				; AX = user sectors

;	At this point, calculate the allocation units based on size of user

	PUSH	AX
	PUSH	BX

	MOV	CL,4				; Minimum is 2k
	MOV	BX,8*2*1024
	CMP	WORD PTR [DI].BPB_SECSZ,512
	JZ	DSKWASN1
	MOV	CL,2
	MOV	BX,8*1024
DSKWASN1:
	CMP	AX,BX
	JNA	DSKWASN2			; if <=, CL = SPAU
	SHL	CL,1
	SHR	AX,1				; CL*2, AX/2
	JMP	DSKWASN1
DSKWASN2:
	POP	BX
	POP	AX

	MOV	BYTE PTR [DI+BPB_SPAU],CL	; CL = cluster factor
	XOR	CH,CH
	PUSH	CX				; Save it
	DIV	CX				; AX = user groups
	MOV	CX,3
	MUL	CX				; AX = AX * 3
	MOV	CX,2
	DIV	CX				; AX = 1.5 * (groups)
	OR	DX,DX
	JZ	CALCFAT1
	INC	AX
CALCFAT1:
	MOV	CX,WORD PTR [DI+BPB_SECSZ]
	XOR	DX,DX
	DIV	CX				; AX = sectors in FAT
	OR	DX,DX
	JZ	CALCFAT2
	INC	AX
CALCFAT2:
	MOV	WORD PTR [DI+BPB_FATSECS],AX	; Put it here
	MOV	BYTE PTR [SI+DSKW_FAT],AL	; And here
	POP	CX
	MOV	BYTE PTR [SI+DSKW_SPAU],CL	; Save cluster factor

;	Now see if need to set up the drive

	MOV	AL,ES:BYTE PTR DSKPR_BUFF+1[BX]
	MOV	CL,5
	SHR	AL,CL
	MOV	CL,AL
	MOV	AL,1
	SHL	AL,CL
	TEST	BYTE PTR ASNFL2,AL
	JZ	DOSETUP
	CLC
	JMP	NEAR PTR ASNDONE

DOSETUP:
	OR	BYTE PTR ASNFL2,AL
	MOV	AL,ES:BYTE PTR DSKPR_DRIVE[BX]
	MOV	BYTE PTR DSKPR+DSKPR_DRIVE,AL	; Show drive = E:
	MOV	WORD PTR DSKPR+DSKPR_SECTOR,0	; Sector zero
	MOV	WORD PTR DSKPR+DSKPR_COUNT,1	; only 1
	MOV	WORD PTR DSKPR+DSKPR_BUFF,OFFSET DSK_BUF	; Safe place?
	MOV	WORD PTR DSKPR+DSKPR_BUFF+2,CS	; And segment
	MOV	AL,DSK_PREAD
	MOV	BX,OFFSET DSKPR
	PUSH	SI
	PUSH	ES
	MOV	CX,CS
	MOV	ES,CX
	CALL	DSK				; Read in the block
	POP	ES
	POP	SI
	JNC	INIT217A			; If no errors
Z217INITR:
	JMP	ASNDONE				;not read it

;	Copy in the SDP command from the SBC

INIT217A:
	PUSH	SI
	MOV	SI,OFFSET DSK_BUF
	MOV	BX,WORD PTR [SI]+SBCCRC		; Get CRC value
	PUSH	BX
	MOV	CX,512
	MOV	WORD PTR [SI]+SBCCRC,0
	CALL	NEAR PTR HASH			; Hash the SBC
	POP	BX
	POP	SI
	CMP	AX,BX
	JNZ	Z217INITR			; Bad hash value

;	Save the "next command address" information in the current table

	MOV	AL,BYTE PTR DSK_WCB+WI3NCAH
	MOV	AH,BYTE PTR DSK_WCB+WI3NCAM
	PUSH	AX 
	MOV	AL,BYTE PTR DSK_WCB+WI3NCAL
	PUSH	AX
	PUSH	SI
	MOV	SI,OFFSET DSK_BUF+SBCTSDP	; Pointer to command
	MOV	CL,BYTE PTR [SI+1]		; CL = # of heads
	INC	CL
	AND	CL,7
	MOV	AX,Z217SPT*2			; AX = sectors/track
	CMP	WORD PTR [DI].BPB_SECSZ,512
	JZ	SIZ18
	MOV	AX,Z217SPT
SIZ18:
	MUL	CL
	MOV	DI,SI
	POP	SI				; AL = sectors/cylinder
	MOV	BYTE PTR [SI]+DSK_SPT,AL
	PUSH	SI
	MOV	SI,DI
	MOV	DI,OFFSET DSK_WCB		; Were to put it
	CLD
	MOV	CX,12
	PUSH	ES
	MOV	AX,CS
	MOV	ES,AX
	REP	MOVSB				; Move in the SDP command
	POP	ES

;	Now execute the command

	MOV	DI,SI
	POP	SI
	MOV	DX,WORD PTR [SI]+DSK_PORT	; DX = port number
	MOV	AL,BYTE PTR [SI]+DSKW_WUN
	OR	BYTE PTR DSK_WCB+1,AL		; Set in unit number
	MOV	AL,WICEXE
	MOV	BYTE PTR DSK_WCB+WI3ERR,0FFH	; Ready done flag
	OUT	DX,AL				; Do it
Z217WFC:
	CMP	BYTE PTR DSK_WCB+WI3ERR,0FFH
	JZ	Z217WFC				; Not done yet?

;	Restore old values

	PUSH	SI
	MOV	SI,DI
	MOV	DI,OFFSET DSK_WCB		; Point to command block
	MOV	CX,12
	XOR	AL,AL
	PUSH	ES
	MOV	BX,CS
	MOV	ES,BX
	REP	STOSB				; Clear it all out
	POP	ES
	POP	SI
	POP	AX
	MOV	BYTE PTR DSK_WCB+WI3NCAL,AL	; Set in old command block
	POP	AX				;  address saved earlier
	MOV	BYTE PTR DSK_WCB+WI3NCAM,AH
	MOV	BYTE PTR DSK_WCB+WI3NCAH,AL
ASNDONE:
	RET

;
;   HASH - HASH a sequence of bytes
;
;	SI	=	Source pointer
;	CX	=	Byte count
;
;	Returns AX = HASH value of each individual byte
;

HASH	PROC	NEAR
	XOR	AX,AX				; Clear result
	XOR	DX,DX				; Clear 16bit work area
HASH1:
	MOV	DL,BYTE PTR [SI]		; Get a byte
	ADD	AX,DX				; add it in
	INC	SI
	LOOP	HASH1				; for each byte
	NOT	AX				; so 0 = ffff, not 0
	RET
HASH	ENDP

;
;  DSKWFRD - Read function for winchester
;
;      Reads one or more sectors from the disk
;
;  Call with:
;      ES:BX -> parameter block addr
;      SI -> disk table
;
;  Returns:
;      CY clear - no errors
;      CY set - errors
;

DSKWFRD:
	MOV	BYTE PTR VERFLG,0	; Flag no verify
DSKWFRDV:
	MOV	BYTE PTR PFLAG,0	; Show no PREAD
	MOV	AL,WICBRDL	; Get log read command
	JMP	SHORT DSKWRDWR	; Join common code

DSKWPRD:
	MOV	BYTE PTR VERFLG,0
	MOV	BYTE PTR PFLAG,1	; Show pread
	MOV	AL,WICBRDL
	JMP	SHORT DSKWRDWR	; Common entry


;
;  DSKWFWR - Write function for winchester
;
;      Writes one or more sectors to the disk
;
;  Call with:
;      ES:BX -> parameter block addr
;      SI -> disk table
;
;  Returns:
;      CY clear - no errors
;      CY set - errors
;

DSKWPWR:
	MOV	BYTE PTR VERFLG,0
	MOV	BYTE PTR PFLAG,1	; Physical write
	MOV	AL,WICBWRL
	JMP	SHORT DSKWRDWR		; enter it

DSKWFWR:
	MOV	BYTE PTR VERFLG,0
	MOV	BYTE PTR PFLAG,0	; Show logical
	MOV	AL,WICBWRL	; Get log write command 	
;	JMP	SHORT DSKWRDWR	; Join common code


;
; Common code for read and write
;

DSKWRDWR:
	MOV	BYTE PTR DSK_WCB+WI1COM,AL ; Store command
	MOV	AX,WORD PTR ES:DSKPR_SECTOR[BX] ; Get logical sector number
	TEST	BYTE PTR PFLAG,0FFH
	JNZ	DSKWRDWRP
	ADD	AX,WORD PTR DSK_BSEC[SI] ; Add base sector

DSKWRDWRP:
	MOV	WORD PTR CUR_SECTOR,AX ; Save locally
	MOV	DI,WORD PTR DSK_BPS[SI] ; Get bytes per sector
	MOV	WORD PTR RETRY_SECTOR,0	; Show sector of last error

;	Compute next 256 sector block to read

DSKWRDWR0:
	MOV	AX,WORD PTR CUR_SECTOR ; Get logical sector number
	MOV	BYTE PTR DS:(DSK_WCB+WI1DSHS),0 ; Store sector/drive
	MOV	BYTE PTR DS:(DSK_WCB+WI1SECH),AH ; Store hi sector number
	MOV	BYTE PTR DS:(DSK_WCB+WI1SECL),AL ; Store lo sector number

;	Get number of sectors to read/write

	TEST	BYTE PTR VERFLG,0FFH
	MOV	AL,1
	JNZ	DSKWRDWR0V			; If verify, one at a time
	MOV	AL,BYTE PTR ES:DSKPR_COUNT[BX]
DSKWRDWR0V:
	MOV	BYTE PTR DS:(DSK_WCB+WI1CNT),AL	; Set in number of sectors
	XOR	AH,AH
	TEST	AL,0FFH				; Zero?
	JNZ	DSKWRDWRSC1			; No, save count
	MOV	AH,1				; Zero = 256
DSKWRDWRSC1:
	MOV	CS:WORD PTR SECCNT,AX		; Save count for later

; Compute buffer addr and store in table

	XOR	DX,DX		; Clear high part
	MOV	CX,WORD PTR ES:DSKPR_BUFF+2[BX] ; Get segment
	TEST	BYTE PTR VERFLG,0FFH
	JZ	DSKWRDWRSC2		; If not verifying
	MOV	CX,SEG BIOS_SEG		; Verifying, use temp area
DSKWRDWRSC2:
	SHL	CX,1		; First shift
	RCL	DX,1
	SHL	CX,1		; Second shift
	RCL	DX,1
	SHL	CX,1		; Third shift
	RCL	DX,1
	SHL	CX,1		; Fourth shift
	RCL	DX,1
	MOV	AX,WORD PTR ES:DSKPR_BUFF[BX]
	TEST	BYTE PTR VERFLG,0FFH
	JZ	DSKWRDWRSC3	; Not verifying
	MOV	AX,OFFSET DSK_BUF
DSKWRDWRSC3:
	ADD	CX,AX		; Add offset
	ADC	DX,0		; Propagate cary
	MOV	BYTE PTR DSK_WCB+WI1TMAH,DL ; Store high part
	MOV	BYTE PTR DSK_WCB+WI1TMAM,CH ; Store middle part
	MOV	BYTE PTR DSK_WCB+WI1TMAL,CL ; Store low part

; Setup and do operation

	MOV	DX,WICOM	; Get command port offset
	ADD	DX,WORD PTR DSK_PORT[SI] ; Compute command port

DSKWRDWREXEC:
	MOV	BYTE PTR DS:(DSK_WCB+WI3ERR),0FFH ; Set completion code
	MOV	AL,BYTE PTR DSKW_WUN[SI]
	OR	BYTE PTR DS:DSK_WCB+1,AL
	MOV	AL,WICEXE	; Get execute command
	OUT	DX,AL		; Start operation

DSKWRDWR1:
	MOV	AL,BYTE PTR DSK_WCB+WI3ERR ; Get error code
	CMP	AL,0FFH		; Is command finished ?
	JE	DSKWRDWR1	;   No, keep looking

	CMP	AL,0		; Any errors ?
	JE	DSKWRDWR2	;   No, keep going

;	Here on errors

	CMP	AL,WIEDNR	; Drive not ready?
	JZ	DSKWRDWROE	;  Yes, bail out now!

;	Not a "drive not ready" problem

	PUSH	BX
	CALL	DSKW_RETRY	; Do a disk retry
	POP	BX
	JC	DSKWRDWROE	; If too late, bad errors
	JMP	NEAR PTR DSKWRDWR2

;	Disk error - retries don't help

DSKWRDWROE:
	MOV	AL,BYTE PTR DSK_WCB+WI3ERR	; AL = error code

;	Look up the equivelant Z217 error code

	MOV	SI,OFFSET RW_ERRD
DSKWRDWROE1:
	CMP	BYTE PTR [SI],AL	; This one?
	JZ	DSKWRDWROE2		; Yes
	CMP	BYTE PTR [SI],-1	; Terminator?
	JZ	DSKWRDWROE2		; Yes
	ADD	SI,2			; Search for it
	JMP	SHORT DSKWRDWROE1

;	Found it, pointer in [si+1]

DSKWRDWROE2:
	MOV	AL,BYTE PTR [SI+1]	; AL = error code
	STC
	RET

;	Transfer error, computed count exceeded

DSKWRDWRTE:
	MOV	AX,FDSCRC+FDSLDT ; Make it look like a data error
	STC			; Show error
	RET			;   and return

DSKWRDWR2:
	MOV	AX,CS:WORD PTR SECCNT
	ADD	ES:WORD PTR DSKPR_SECTOR[BX],AX
	SUB	WORD PTR ES:DSKPR_COUNT[BX],AX
	CMP	WORD PTR ES:DSKPR_COUNT[BX],0	; All done?
	JZ	DSKWRDWR3		; Yes

;	Compute next address and current sector number

	ADD	WORD PTR CUR_SECTOR,AX        ; Bump current sector number
	MUL	DI			      ; DX:AX = bytes read
	JC	DSKWRDWRTE		      ; Error, DX must be > 0

;	DX is checked for zero, since transfers must be < 64k bytes

	ADD	WORD PTR ES:DSKPR_BUFF[BX],AX ; Compute next addr in buffer
	JMP	DSKWRDWR0	;   do next one

DSKWRDWR3:
	XOR	AX,AX		; Clear AX and CY to show success
	RET 			;   and return

	PAGE
;
;  DSKWFFT - Format function for winchester
;
;      Formats the disk
;
;  Call with:
;      ES:BX -> parameter block addr
;      SI -> disk table
;
;  Returns:
;      CY clear - no errors
;      CY set - errors
;

DSKWFFT:
	MOV	AX,DSKST_NIERR	; Get not implemented error code
	STC			; Show error
	RET			;   and return

	PAGE
;
;  DSKFSI - Step in function for winchester
;
;      Steps the head in one sector track
;
;  Call with:
;      ES:BX -> parameter block addr
;      SI -> disk table
;
;  Returns:
;      CY clear - no errors
;      CY set - errors
;

DSKWFSI:
	MOV	AX,DSKST_NIERR	; Get not implemented error code
	STC			; Show error
	RET			;   and return

	PAGE
;
;  DSKWFRT - Read track function for winchester
;
;      Reads a track from the disk
;
;  Call with:
;      ES:BX -> parameter block addr
;      SI -> disk table
;
;  Returns:
;      CY clear - no errors
;      CY set - errors
;

DSKWFRT:
	MOV	AX,DSKST_NIERR	; Get not implemented error code
	STC			; Show error
	RET			;   and return

;
;  DSKW_RETRY - Do a winchester retry
;
;	Retry the read/write operation
;
;  Call with:
;	RETRY_SECTOR - Last sector with errors
;	SECCNT	     - Number of sectors attempted
;	WI1HSE-WI1SCLE - Sector of error
;
;  Returns:
;	'cy' set if retries all failed
;	'cy' clear if retry attempted
;		RETRY_SECTOR updated
;		SECCNT updated
;		CUR_SECTOR updated
;

DSKW_RETRY:
	MOV	AX,WORD PTR DSK_WCB+WI1SCHE	; AX = sector of error
	XCHG	AH,AL
	CMP	AX,WORD PTR RETRY_SECTOR	; Same as last time
	JZ	DSKW_RETSS			; Yes, retry same sector

;	New sector, calculate figures

	MOV	WORD PTR RETRY_SECTOR,AX	; Set it here
	MOV	BX,WORD PTR CUR_SECTOR		; BX = old starting
	SUB	AX,BX				; AX = sectors read
	MOV	WORD PTR SECCNT,AX
	MOV	BYTE PTR RETRY_INDX,-1		; Set index for errors
	JMP	SHORT DSKW_RETSS1

;	Here for each subsequent attempt of a single bad sector

DSKW_RETSS:
	MOV	WORD PTR SECCNT,0		; Show none read
DSKW_RETSS1:
	INC	BYTE PTR RETRY_INDX		; 0=first, 1=second, ...
	CMP	BYTE PTR RETRY_INDX,3		; Try 3 at best
	STC
	JNZ	DSKW_RETSS2			; If not bad

;	Had 3 retries, too bad

	RET					; 'cy' is set

;	Try another time

DSKW_RETSS2:
	MOV	BL,BYTE PTR RETRY_INDX
	XOR	BH,BH
	SHL	BX,1				; BX = word index
	JMP	WORD PTR DSKW_RETSSV[BX]	; Try it

;	Jump vector for winchester retries

DSKW_RETSSV	LABEL	NEAR
	DW	OFFSET DSKW_RETSSSH		; Seek to higher cylinder
	DW	OFFSET DSKW_RETSSSL		; Seek to lower cylinder
	DW	OFFSET DSKW_RETSSRS		; Restore system

;
;	DSKW_RETSSSH - Seek to higher cylinder
;

DSKW_RETSSSH:
	MOV	BX,WORD PTR [SI+DSK_SPT]	; Get sectors/cylinder
	JMP	SHORT DSKW_RETSSSX

;
;	DSKW_RETSSSL - Seek to lower cylinder
;

DSKW_RETSSSL:
	MOV	BX,WORD PTR [SI+DSK_SPT]	; Sectors/cylinder
	NEG	BX				; Make it minus
;	JMP	SHORT DSKW_RETSSSX

DSKW_RETSSSX:
	MOV	AX,WORD PTR RETRY_SECTOR
	ADD	AX,BX				; AX = target
	XCHG	AH,AL
	MOV	WORD PTR DSK_WCB+WI1SECH,AX
	MOV	BL,BYTE PTR DSK_WCB		; Save the old one
	MOV	BYTE PTR DSK_WCB,WICBSKL	; Seek logical

DSKW_RETSSSX0:
	MOV	BYTE PTR DS:(DSK_WCB+WI3ERR),0FFH ; Set completion code
	MOV	DX,WICOM			; Get command port offset
	ADD	DX,WORD PTR DSK_PORT[SI] 	; Compute command port
	MOV	AL,WICEXE			; Get execute command
	OUT	DX,AL				; Start operation

DSKW_RETSSSX1:
	MOV	AL,BYTE PTR DSK_WCB+WI3ERR	; Get error code
	CMP	AL,0FFH				; Is command finished ?
	JE	DSKW_RETSSSX1			;   No, keep looking
	MOV	BYTE PTR DSK_WCB,BL		; Restore old op-code
	CLC
	RET					; Return to caller

;
;	DSKW_RETSSRS - Restore head
;

DSKW_RETSSRS:
	MOV	BL,BYTE PTR DSK_WCB
	MOV	BYTE PTR DSK_WCB,WICBRCL	; Recal drive
	JMP	SHORT DSKW_RETSSSX0		; Execute it
	PAGE
;
;  Variables used by disk routines
;

CUR_SECTOR	DW ?		; Current logical sector
RETRY_INDX 	DB ?		; Index in cycle of retry procedure
RETRY_FLAG	DB ?		; Flag (00 = retry without seek)
RETRY_SECTOR	DW ?		; sector of last retry
RETRY_CREM	DB ?		; Remaining number of retry cycles

SECCNT		DW ?		; Sectors transfered in DSKW
PFLAG		DB 0		; =0 if logical read, else physical read

BDSK217	ENDP
