;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;
;
;  DSK - This routine provides the necessary code to perform all disk I/O.
;
;        The particular function to perform is passed in the AL register.
;
;  Call with:
;
;    The register pair ES:BX points to a parameter block(for all functions
;    except GBIOSVEC and  MAPDSK) with the following fields:
;
;      DSKPR_DRIVE (byte):
;         Logical drive number (0-MAXDSK allowed)
;      DSKPR_SECTOR (word):
;         Logical sector number
;            (0-drive_max allowed)
;         (On read/write track function, side flag:
;            0 - side zero, 1 - side one)
;      DSKPR_COUNT (word):
;	transfer count
;            (1-?? (total bytes must fit within the same segment))
;      DSKPR_BUFF (double word):
;         Address of buffer. The first word is the offset, the second word is
;         the segment.
;
;  Register AL has the function to perform
;   (AL) = DSK_RESET - Reset disk(home head)
;   (AL) = DSK_STATUS - Get disk status(on success AH=aux status,AL=status)
;   (AL) = DSK_STEPIN - Step in head
;   (AL) = DSK_READ - Read the specified sectors to the buffer addr
;   (AL) = DSK_WRITE - Write the specified sectors from the buffer addr
;   (AL) = DSK_VERIFY - Verify the specified sectors. (Not implemented yet)
;   (AL) = DSK_FORMAT - Format a track.
;           The write track command is used to write the data at DSK_BUFF.
;   (AL) = DSK_READTRK - Perform the read track command.
;   (AL) = DSK_GBIOSVEC - Get addr of disk vector used by the BIOS in ES:BX.
;   (AL) = DSK_MAPDSK - Maps logical in AH to physical in AL
;   (AL) = DSK_SETFDC - Set force disk has been changed flag(DSK_FDC)
;   (AL) = DSK_PREAD - Same as DSK_READ but do not apply BSEC value
;   (AL) = DSK_ASSIGN - Set up BSEC and FATS values in partition
;
;  Returns:
;   AX = Status of operation
;         (See DEFDSK.ASM)
;   CY = 0 - Operation was a success
;   CY = 1 - Operation failed (see AX)
;   For DSK_READ and DSK_WRITE:
;     DSKPR_COUNT = number of sectors not read/written
;     DSKPR_BUFF = Addr at end of read/write
;   For DSK_GBIOSVEC:
;     ES:BX -> vector of disk table addresses
;
;
;  All register are used.
;  Segment registers are perserved.
;  (DS must be set up before call)
;
;  Last modified: 9/28/82 - bcb
;

DSK	PROC NEAR

; Check if the function is legal

	CMP	AL,DSK_FMAX	; Is function legal ?
	JNA 	D0A 		;   Yes, keep going
	STC			;   No, turn on CY to show error
	MOV	AX,DSKST_FNERR	; Show function error
	RET			;  and return

; Check for special functions

D0A:	
	CMP	AL,DSK_GBIOSVEC	; Is function Get Disk Vector ?
	JE	D0A1		;   Yes, skip to it
	CMP	AL,DSK_SETFDC	; Is it FORCE DISK CHANGE
	JE	D0A2
	CMP	AL,DSK_DRVNUM
	JE	D0A3		; Get number of drives
	CMP	AL,DSK_MAPDSK	; Is function Map Disk ?
	JNE	D0B		;   No, must be regular function

	PAGE
;
; Map device function
;
;     AH = current drive name
;     If AH = 0FFH
;         returns ES:BX pointer to map table
;     Else
;         returns AL mapped from AH
;

	CMP	AH,0FFH		; Is subfunction, Get Pointer to table?
	JNE	DSKFMAP1	;   No, map a particular drive

; Get pointer to the map table

	PUSH	CS		; Get segment
	POP	ES
	MOV	BX,OFFSET DSKMAP ; Get offset
	RET			;  and return

; Map drive in AH to one in AL

DSKFMAP1:
	MOV	AL,AH		; Make index into table
	XOR	AH,AH
	MOV	SI,AX		; Make index available
	MOV	AL,BYTE PTR DSKMAP[SI+1] ; Map disk
	RET			;  and return

; Disk map table
;
;     First entry is count of entries that follow
;     each following entry contains the physical
;     drive to access when referencing that logical
;     number.
;

DSKMAP	DB	12,0,1,2,3,4,5,6,7,8,9,10,11

;
; Get BIOS disk vector function
;

D0A1:
	MOV	BX,OFFSET DSK_TPTR ; Get offset of vector
	PUSH	CS		; Get segment of vector
	POP	ES	
	XOR	AX,AX		; Show success(clear CY)
	RET			;   and return

;
; SETFDC - Set the FDC bit in the (AH) drive table
;	AH = Drive name (0=a, 1=b) NOT already mapped
;

D0A2:
	PUSH	SI
	CALL	NEAR PTR DSKFMAP1	;Map to real drive

;	AL = real mapped drive name

	CBW
	SHL	AX,1
	MOV	SI,AX
	MOV	SI,WORD PTR DSK_TPTR[SI]	;SI = pointer to table
	OR	BYTE PTR DSK_FLAG[SI],DSK_FDC	;Set the FDC bit
	POP	SI
	XOR	AX,AX
	RET			;Return with no error

;
; DRVNUM - AL = number of 5 inch drives
;	   AH = number of 8 inch drives
;

D0A3:
	MOV	AL,MAXDSK5
	MOV	AH,MAXDSK8-MAXDSK5
	CLC
	RET

	PAGE
;
; Regular disk function
;

D0B:
	MOV	DSK_FUN,AL	; Save function
	CBW	 		; Extend AL to AX
	SHL	AX,1		; Compute word offset
	MOV	DI,AX		; Make avail as index


; Check if drive number is legal
;   (DI has function)

	MOV     AL,ES:DSKPR_DRIVE[BX] ; Get logical drive number
	CMP	AL,0FFH		; Is drive special one ?
	JE	D0D		;    Yes, then Ok
	CMP	AL,MAXDSK	; Is drive number within range ?
	JB	D0D		;   Yes, skip
D0C:	STC			;   No, illegal drive number
	MOV	AX,DSKST_DNERR	; Get error code
	RET			;   and return

D0D:
	CBW			; Extend AL to AX
	SHL	AX,1		; Compute word offset
	MOV	SI,AX		; Make avail as index
	MOV	SI,DSK_TPTR[SI] ; Get addr of disk parameter table
	CMP	SI,-1		; Does table exist ?
	JE	D0C		;   No, show error and return

; Check if drive type valid

	CMP	BYTE PTR DSK_TYPE[SI],DSK_TZ217	; Winchester?
	JNZ	D0D1		; Nope
	JMP	NEAR PTR BDSK217	; Yes, dispatch it
D0D1:
	CMP	BYTE PTR DSK_TYPE[SI],DSK_TZ2075 ; Is it disk type valid ?
	JZ	D0E1		; If 5" disk type
	CMP	BYTE PTR DSK_TYPE[SI],DSK_TZ2078 ; Is it valid 8" disk type
	JNZ	D0E
D0E1:
	JMP	NEAR PTR BDSK207
D0E:
	STC			; Show error
	MOV	AX,DSKST_DTERR	; Get error code
	RET			;    and return
DSK	ENDP
 
