;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;
;
; Definitions for 8259A interrupt controller
;

;	REGISTER DISPLACEMENTS

ICW1	EQU	0		;ICW1
ICW2	EQU	1		;ICW2
ICW3	EQU	1		;ICW3
ICW4	EQU	1		;ICW4
OCW1	EQU	1		;OCW1
OCW2	EQU	0		;OCW2
OCW3	EQU	0		;OCW3

;	ICW1 REGISTER FLAGS

ICW1A	EQU	11100000B	;A7-A5
ICW1OP	EQU	00010000B	;1=ICW1 , 0=OCW'S
ICW1LT	EQU	00001000B	;TRIGGER MODE (0=EDGE , 1=LEVEL)
ICW1ADI	EQU	00000100B	;CALL INTERVAL (0=8 , 1=4)
ICW1SNG	EQU	00000010B	;0=CASCADE , 1=SINGLE
ICW1IL4	EQU	00000001B	;ICW4 (0=NOT USED , 1=USED)

;	ICW3 REGISTER FLAGS (MASTER DEVICE)

ICW3S0	EQU	00000001B	;IR INPUT 0 HAS SLAVE
ICW3S1	EQU	00000010B	;IR INPUT 1 HAS SLAVE
ICW3S2	EQU	00000100B	;IR INPUT 2 HAS SLAVE
ICW3S3	EQU	00001000B	;IR INPUT 3 HAS SLAVE
ICW3S4	EQU	00010000B	;IR INPUT 4 HAS SLAVE
ICW3S5	EQU	00100000B	;IR INPUT 5 HAS SLAVE
ICW3S6	EQU	01000000B	;IR INPUT 6 HAS SLAVE
ICW3S7	EQU	10000000B	;IR INPUT 7 HAS SLAVE

;	ICW3 REGISTER FLAGS (SLAVE DEVICE)

ICW3SID	EQU	00000111B	;SLAVE ID MASK

;	ICW4 REGISTER FLAGS

ICW4SFN	EQU	00010000B	;1=SPECIAL FULLY NESTED MODE
ICW4BMS	EQU	00001000B	;BUFFERED MODE SLAVE
ICW4BMM	EQU	00001100B	;BUFFERED MODE MASTER
ICW4AE	EQU	00000010B	;AUTO EOI
ICW4UPM	EQU	00000001B	;MICRO-PROCESSOR MODE
				; (0=8080/85 , 1=8086/88)

;	OCW1 REGISTER (INTERRUPT MASK REGISTER)

OCW1IM0	EQU	00000001B	;IR0
OCW1IM1	EQU	00000010B	;IR1
OCW1IM2	EQU	00000100B	;IR2
OCW1IM3	EQU	00001000B	;IR3
OCW1IM4	EQU	00010000B	;IR4
OCW1IM5	EQU	00100000B	;IR5
OCW1IM6	EQU	01000000B	;IR6
OCW1IM7	EQU	10000000B	;IR7

;	OCW2 REGISTER

OCW2OP	EQU	00000000B	;OCW2
OCW2R	EQU	10000000B	;PRIORITY ROTATION
OCW2SL	EQU	01000000B	;SELECT A SPECIFIC LEVEL
OCW2EOI	EQU	00100000B	;END OF INTERRUPT COMMAND
OCW2L	EQU	00000111B	;IR LEVEL TO BE ACTED UPON

;	OCW3 REGISTER

OCW3OP	EQU	00001000B	;OCW3
OCW3RSM	EQU	01000000B	;RESET SPECIAL MASK MODE
OCW3SSM	EQU	01100000B	;SET SPECIAL MASK MODE
OCW3P	EQU	00000100B	;POLL COMMAND
OCW3RIR	EQU	00000010B	;READ IR REG
OCW3RIS	EQU	00000011B	;READ IS REG

