;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;
;**	DEF8274 - Define the 8274 Multi-Protocol Controller
;

;	Port displacements

MPADAT	=	0			; Data for channel A
MPBDAT	=	1			; Data for channel B
MPACMD	=	2			; Command for channel A
MPBCMD	=	3			; Command for channel B
MPASTT	=	2			; Status for channel A
MPBSTT	=	3			; Status for channel B

;	8274 Internal registers

WR0	=	0			; Write Register 0
 WPRPM	=	00000111B		;  Command/Status pointer mask
 MPSA	=	00001000B		;  Send Abort (SDLC)
 MPRESI	=	00010000B		;  Reset external/Status interrupts
 MPCHNR	=	00011000B		;  Channel Reset
 MPEINR	=	00100000B		;  Enable Interrupt on next rx
 MPRTI	=	00101000B		;  Reset transmitter interrupt
 MPER	=	00110000B		;  Error reset
 MPEOI	=	00111000B		;  Interrupt Ack channel A
 PRRCRC	=	01000000B		;  Reset rx CRC generator
 MPRTCRR  =	10000000B		;  Reset tx CRC generator
 MPRTU	=	11000000B		;  Reset tx underflow/EOM

WR1	=	1			; Write Register 1
 MPESIE	=	00000001B		;  External/Status interrupt enable
 MPTIE	=	00000010B		;  Transmitter Interrupt enable
 MPSAV	=	00000100B		;  Status effects vector channel B
 MPRID	=	00000000B		;  Rx interrupts disabled
 MPRI1	=	00001000B		;  Rx interrupt on first character
 MPRIAP	=	00010000B		;  Rx interrupt on all chars w/parity
 MPRIA	=	00011000B		;  Rx interrupt on all chars wo/parity

WR2	=	2			; Write Register 2
 MPPR	=	00000100B		;  Interrupt priority channel A
					;  0=rxa,txa,rxb,txb; 1=rxa,rxb,txa,txb
 MPVM	=	11111111B		;  Interrupt vector mask channel B
 MP88M	=	00010000B		;  In 8088 mode

WR3	=	3			; Write Register 3
 MPRXE	=	00000001B		;  Rx enable
 MPSCLI	=	00000010B		;  Sync character load inhibit
 MPASM	=	00000100B		;  Address search mode
 MPRXCRC =	00001000B		;  Rx CRC enable
 MPEHP	=	00010000B		;  Set HUNT mode
 MPAE	=	00100000B		;  Auto-enable
 MPRX5	=	00000000B		;  5 bit data length
 MPRX6	=	01000000B		;  6 bit data length
 MPRX7	=	10000000B		;  7 bit data length
 MPRX8	=	11000000B		;  8 bit data length

WR4	=	4			; Write Register 4
 MPPA	=	00000001B		;  0=parity disable
 MPEP	=	00000010B		;  0=odd parity
 MPSYN	=	00000000B		;  Enabel sync mode
 MP1S	=	00000100B		;  Async, 1 stop bit
 MP15S	=	00001000B		;  Async, 1.5 stop bits
 MP2S	=	00001100B		;  Async, 2 stop bits
 MP8SYN	=	00000000B		;  8 bit sync character
 MP16SYN =	00010000B		;  16 bit sync character
 MPSHDLC =	00100000B		;  HDLC/SDLC mode
 MPEXSYN =	00110000B		;  External sync mode
 MPX1	=	00000000B		;  x1 clock
 MPX16	=	01000000B		;  x16 clock
 MPX32	=	10000000B		;  x32 clock
 MPX64	=	11000000B		;  x64 clock

WR5	=	5			; Write Register 5
 MPTXCRC =	00000001B		;  Tx CRC enable
 MPRTS	=	00000010B		;  Force RTS high
 MPCRC16 =	00000100B		;  0=CCITT-CRC, 1=CRC-16
 MPTXE	=	00001000B		;  Tx enable
 MPBRK	=	00010000B		;  Send break character
 MPTX5	=	00000000B		;  5 (or less) word length
 MPTX6	=	01000000B		;  6 bit word length
 MPTX7	=	00100000B		;  7 bit word length
 MPTX8	=	01100000B		;  8 bit word length
 MPDTR	=	10000000B		;  Force DTR active

WR6	=	6			; Write register 6

WR7	=	7			; Write Register 7

RR0	=	0			; Read Register 0
 MPRXA	=	00000001B		;  Rx character ready
 MPIP	=	00000010B		;  Channel A interrupt pending
 MPTXA	=	00000100B		;  Tx buffer available
 MPCD	=	00001000B		;  Carrier Detect Status
 MPSH	=	00010000B		;  Sync/Hunt
 MPCTS	=	00100000B		;  Clear to Send Status
 MPTU	=	01000000B		;  Tx underflow/EOM
 MPBA	=	10000000B		;  Break/abort detect

RR1	=	1			; Read Register 1
 MPACS	=	00000001B		;  All characters sent
 MPRCM	=	00001110B		;  Residue mask
 MPPERR	=	00010000B		;  Parity error
 MPROE	=	00100000B		;  Overrun on rx
 MPCFE	=	01000000B		;  CRC/Frame error
 MPEOF	=	10000000B		;  End of Frame (SDLC)

RR2	=	2			; Read Register 2

;	WD1943 Dual baud clock generator

BRCRM	=	00001111B		; Rx mask
BRCTM	=	11110000B		; Tx mask

;	Baud rate selections

BRC050	=	0			; 50
BRC075	=	1			; 75
BRC110	=	2			; 110
BRC134	=	3			; 134.5
BRC150	=	4			; 150
BRC300	=	5			; 300
BRC600	=	6			; 600
BRC120	=	7			; 1200
BRC180	=	8			; 1800
BRC200	=	9			; 2000
BRC240	=	10			; 2400
BRC360	=	11			; 3600
BRC480	=	12			; 4800
BRC720	=	13			; 7200
BRC960	=	14			; 9600
BRC192	=	15			; 19.2k
