	PAGE	,132
;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;
;	06-14-85 JSB - Converted to Ver 3 device driver.
;

	TITLE	Z204 - Z204 device driver

	.LFCOND
	.TFCOND		; Use the /X switch to cause FALSE conds not to list

	INCLUDE	  PARMS.ASM

    IF LISTI
	IF1
	%OUT	*Full listing being generated*
	ENDIF
    ELSE
	IF1
	%OUT	*Include files are not part of listing*
	ENDIF

	.XLIST
    ENDIF

	INCLUDE	  MACLIB.ASM
	INCLUDE	  DEFDEV.ASM
	INCLUDE	  DEFDOSI.ASM
	INCLUDE	  DEFZ204.ASM
	INCLUDE	  DEF8259A.ASM
	INCLUDE	  DEF8274.ASM
	INCLUDE	  DEFEP2.ASM
	INCLUDE	  DEFCONFG.ASM

	.LIST
	PAGE

CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

BIOS_DEVS LABEL	BYTE
DVH_Z204 LABEL	NEAR
	ERRNZ	DVH_Z204,DVH_OFF
	DW	-1
	ERRNZ	DVH_Z204,DVH_SEG
	DW	-1	
	ERRNZ	DVH_Z204,DVH_ATTR
	DW	DVHA_CHR
	ERRNZ	DVH_Z204,DVH_STRAT
	DW	OFFSET STRATEGY
	ERRNZ	DVH_Z204,DVH_INTR
	DW	OFFSET INTR_Z204
	ERRNZ	DVH_Z204,DVH_NAME
	DB	"Z204    "
	ERRNZ	DVH_Z204,<SIZE DVH_STRUC>

Z204TBL	LABEL	NEAR
	ERRNZ	Z204TBL,SRHC_INIT
	DW	Z204_INIT		; Initialization (0)
	ERRNZ	Z204TBL,SRHC_MCHK*2
	DW	EXIT_SUCC		; Media check (1)
	ERRNZ	Z204TBL,SRHC_BPB*2
	DW	EXIT_SUCC		; Build BPB (2)
	ERRNZ	Z204TBL,SRHC_ICTL*2
	DW	EXIT_SUCC		; IOCTL input (3)
	ERRNZ	Z204TBL,SRHC_IN*2
	DW	Z204_IN			; Input (4)
	ERRNZ	Z204TBL,SRHC_ICHK*2
	DW	Z204_ICHK		; Non-destructive input no wait (5)
	ERRNZ	Z204TBL,SRHC_ISTAT*2
	DW	Z204_ISTAT		; Input status (6)
	ERRNZ	Z204TBL,SRHC_IFL*2
	DW	Z204_IFL		; Input flush (7)
	ERRNZ	Z204TBL,SRHC_OUT*2
	DW	Z204_OUT		; Output (8)
	ERRNZ	Z204TBL,SRHC_OUTV*2
	DW	Z204_OUT		; Output (write) with verify (9)
	ERRNZ	Z204TBL,SRHC_OSTAT*2
	DW	Z204_OSTAT		; Output status (10)
	ERRNZ	Z204TBL,SRHC_OFL*2
	DW	Z204_OFL		; Output flush (11)
	ERRNZ	Z204TBL,SRHC_OCTL*2
	DW	EXIT_SUCC		; IOCTL output (12)
	ERRNZ	Z204TBL,SRHC_OPEN*2	
	DW	EXIT_SUCC		; OPEN FILE (13)
	ERRNZ	Z204TBL,SRHC_CLOSE*2	
	DW	EXIT_SUCC		; CLOSE FILE (14)
	ERRNZ	Z204TBL,SRHC_REMOV*2	
	DW	EXIT_SUCC		; DEVICE REMOVABLE (15)
	ERRNZ	Z204TBL,SRHC_OUTB*2
	DW	Z204_OUTB		; OUTPUT UNTIL BUSY (16)
	ERRNZ	Z204TBL,(SRHC_MAX+1)*2


;	Input and Output ques for the device. These ques are accessed
;	only by the users routines, through QUE_xxx below.

QUESTR	STRUC				; Que structure
HEADPTR	DW	0			; Head pointer
TAILPTR	DW	0			; Tail pointer
QUESTR	ENDS

QUE_LENGTH	=	120		; 120 character buffer

INPUT_QUE	LABEL	BYTE
	QUESTR	<>
	DB	QUE_LENGTH DUP (0)	; Data

OUTPUT_QUE	LABEL	BYTE
	QUESTR	<>
	DB	QUE_LENGTH DUP (0)	; Data

STRATP	PROC	FAR

PTRSAV		DD ?		; Request packet pointer

STRATEGY:
	MOV	WORD PTR CS:PTRSAV,BX
	MOV	WORD PTR CS:PTRSAV+2,ES
	RET
STRATP	ENDP

; Get addr of dispatch table and join common code

INTRP	PROC	FAR

INTR_Z204:
	PUSH	SI
	MOV	SI,OFFSET Z204TBL
	PUSH	AX		; Save regs
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	BP
	PUSH	ES
	

; Check if command valid, and then dispatch to it

	LES	BX,CS:PTRSAV	; Get packet addr
	MOV	CL,ES:SRH_CMD[BX]	; Get command
	CMP	CL,SRHC_MAX	; Is command valid ?
	JA	CMDERR		;   No, show error
	XOR	CH,CH		; Clear upper half
	SHL	CX,1		; Make into word offset
	ADD	SI,CX		; Compute table entry
	JMP	WORD PTR CS:[SI] ; Dispatch to command


; Busy exit

EXIT_BUS:
	MOV	AH,SRHS_BUI OR SRHS_DON ; Mark busy and done
	JMP	SHORT EXIT1	; Join common code


; Command error exit

CMDERR:
	MOV	AL,SRHS_EUKC	; Get UNKNOWN CODE
;	JMP	SHORT EXIT_ERR	; Join common code


; Error exit

EXIT_ERR:
	MOV	AH,SRHS_ERR OR SRHS_DON ; Mark error and done
	JMP	SHORT EXIT1	; Join code


; Success exit	

EXIT_SUCC:
	MOV	AH,SRHS_DON	; Mark as done
;	JMP	SHORT EXIT1	; Join common code


; Common exit code

EXIT1:
	LES	BX,CS:PTRSAV	; Get packet addr
	MOV	ES:SRH_STAT[BX],AX ; Store status

	POP	ES		; Restore regs
	POP	BP
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	POP	SI
	RET
INTRP	ENDP

;**	Interrupt routine.
;
;	INT_RTN provides the interrupt service routine
;	by:
;
;	1. Reading the 8259a to see if it is our interrupt
;	2. If ZMPSC_RTX, set AH to the 8274 interrupt value
;	3. Dispatch to CHR_INT with AH/AL setup
;	4. Acknowledge the interrupt with EOI
;	5. Return to system
;

INT_RTN	PROC	FAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	PUSH	DS
	PUSH	BP

;	Set up local segmentation

	MOV	AX,CS
	MOV	ES,AX
	MOV	DS,AX

;	Now see if it is one of ours

	MOV	AL,OCW3OP+OCW3P
	OUT	Z204PIC+OCW3,AL			; Poll the device
	IN	AL,Z204PIC+OCW3			; Who did it!
	TEST	AL,080H				; Was it ours?
	JZ	INT_EXIT			; Nope

;	It was one of ours!

	AND	AL,7				; AL = the id mask
	XOR	AH,AH
	CALL	CHR_INT				; AH/AL set up

;	Now acknowledge them

	MOV	AL,OCW2OP+OCW2EOI		; Acknowledge it
	OUT	Z204PIC+OCW2,AL
	OUT	ZM8259A+OCW2,AL
	OUT	ZS8259A+OCW2,AL

;	All done with the interrupt

INT_EXIT:
	POP	BP
	POP	DS
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET
INT_RTN	ENDP

;
; Z204_INIT - Set up device
;

Z204_INIT:
	MOV	AX,CS
	MOV	DS,AX
	MOV	DX,OFFSET END_DRIVER		; DS:DX Points to end
	MOV	ES:WORD PTR CIN_KADDR[BX],DX
	MOV	ES:WORD PTR CIN_KADDR[BX+2],AX	

;	Flush the ques

	MOV	WORD PTR INPUT_QUE.HEADPTR,SIZE QUESTR+OFFSET INPUT_QUE
	MOV	WORD PTR INPUT_QUE.TAILPTR,SIZE QUESTR+OFFSET INPUT_QUE
	MOV	WORD PTR OUTPUT_QUE.HEADPTR,SIZE QUESTR+OFFSET OUTPUT_QUE
	MOV	WORD PTR OUTPUT_QUE.TAILPTR,SIZE QUESTR+OFFSET OUTPUT_QUE

;	Initialize the 8259a and the proper Z-204 device

	CLI
	CALL	DEV_INIT			; Pre-init devices
	CALL	CHR_INIT			; User Init device
	CALL	INIT_8259			; Initialize 8259a
	STI
	JMP	EXIT_SUCC

;
; Read from console
;

Z204_IN:
	MOV	CX,ES:CRW_CNT[BX]	; Get byte count
	LES	DI,ES:CRW_TADDR[BX] ; Get transfer addr
ALL_IN1:
	PUSH	DI		; Save regs
	PUSH	CX
ALL_IN2:
	CALL	CHR_GET		; Get one from the que
	JC	ALL_IN2		;   Yes, try again

	POP	CX		; Restore regs
	POP	DI
	STOSB			; Store char
	LOOP	ALL_IN1		; Continue until done
	JMP	EXIT_SUCC	; Join common code
	

;
; Non-destructive read
;

Z204_ICHK:
	MOV	BP,BX		; Save BX
	CALL	CHR_LOOK	; Peek at the que
	MOV	BX,BP		; Recover BX
	JNC	ALL_ICHK1	;    No, skip
	JMP	EXIT_BUS	;    Yes, show busy
ALL_ICHK1:
	MOV	ES:CIC_CHAR[BX],AL	;    No, store char
	JMP	EXIT_SUCC	; and return

;
; Input status
;

Z204_ISTAT:
	CALL	CHR_STATUSI	; Get input status
	JC	ALL_ISTAT1	; If nothing there
	JMP	EXIT_SUCC	;   Yes, show it
ALL_ISTAT1:
	JMP	EXIT_BUS

;
; Input flush
;

Z204_IFL:
	CALL	CHR_FLUSHI
	MOV	WORD PTR INPUT_QUE.HEADPTR,SIZE QUESTR+OFFSET INPUT_QUE
	MOV	WORD PTR INPUT_QUE.TAILPTR,SIZE QUESTR+OFFSET INPUT_QUE
	JMP	EXIT_SUCC	; Join common code

;
; Write to console
;	
;	

Z204_OUT:
	MOV	CX,ES:CRW_CNT[BX]	; Get byte count
	LES	SI,ES:CRW_TADDR[BX] ; Get transfer addr
ALL_OUT1:
	MOV	AL,ES:[SI]
	INC	SI
	PUSH	CX
	PUSH	SI
ALL_OUT2:
	MOV	BP,AX		; Save char and function
	CALL	CHR_PUT		; Put one in the que
	MOV	AX,BP		; Recover AX
	JC	ALL_OUT2	;   Yes, try again

	POP	SI
	POP	CX
	LOOP	ALL_OUT1	; Continue until done
	JMP	EXIT_SUCC	; Join common code

;
; Output until busy
;


Z204_OUTB:
	PUSH	DX			; SAVE DX
	MOV	DX,0			; HAVE NOT TRANSFERED ANY BYTES.
	MOV	CX,ES:CRW_CNT[BX]	; Get byte count
	LES	SI,ES:CRW_TADDR[BX] 	; Get transfer addr
OUTB1:

	MOV	AL,ES:[SI]
	INC	SI
	PUSH	CX
	PUSH	SI
	CALL	CHR_PUT			; Put one in the que
	JC	OUTB2			;   Yes, try again
	INC	DX			; WE DID OUTPUT THE CHAR.
	POP	SI
	POP	CX
	LOOP	OUTB1			; Continue until done
	JMP	OUTB3			;
OUTB2:

	
	MOV	ES:CRW_CNT[BX],DX	; COUNT OF BYTES TRANSFERED.
	POP	DX			; RESTORE DX
	JMP	EXIT_BUS		; BUSY EXIT.
OUTB3:
	MOV	ES:CRW_CNT[BX],DX	; COUNT OF BYTES TRANSFERD.
	POP	DX
	JMP	EXIT_SUCC		; OK EXIT.

;
; Output status
;

Z204_OSTAT:
	CALL	CHR_STATUSO	; Get output que status
	JC	ALL_OSTAT1	; If no room at the inn
	JMP	EXIT_SUCC	;   Yes, show it
ALL_OSTAT1:
	JMP	EXIT_BUS

;
; Flush output 
;

Z204_OFL:
	CALL	CHR_FLUSHO
	MOV	WORD PTR OUTPUT_QUE.HEADPTR,SIZE QUESTR+OFFSET OUTPUT_QUE
	MOV	WORD PTR OUTPUT_QUE.TAILPTR,SIZE QUESTR+OFFSET OUTPUT_QUE
	JMP	EXIT_SUCC	; Join common code

;**	QUE_GET, QUE_PUT, QUE_LOOK
;
;	These routines are provided for use by the users
;	I/O routines. He should set SI to the offset of
;	the appropriate que, AL = character if applicable,
;	and call one of these routines. In all cases, CY is
;	set if an error occurs. AL = character returned if
;	applicable.
;

QUE_GET	PROC	NEAR		; Get one character from que
	PUSH	BX
	MOV	BX,CS:WORD PTR [SI.HEADPTR]
	CMP	BX,CS:WORD PTR [SI.TAILPTR]
	STC
	JZ	QUE_GET1	; If que is empty

;	Not empty, Get character

	MOV	AL,CS:BYTE PTR [BX]
	CALL	QUE_BUMP	; Bump it
	MOV	CS:WORD PTR [SI.HEADPTR],BX
	CLC
QUE_GET1:
	POP	BX
	RET
QUE_GET	ENDP

QUE_PUT	PROC	NEAR		; Put one in the buffer
	PUSH	BX
	MOV	BX,CS:WORD PTR [SI.TAILPTR]
	CALL	QUE_BUMP
	CMP	BX,CS:WORD PTR [SI.HEADPTR]	; Collision?
	STC
	JZ	QUE_PUT1
	MOV	BX,CS:WORD PTR [SI.TAILPTR]
	MOV	CS:BYTE PTR [BX],AL	; Save the character
	CALL	QUE_BUMP
	MOV	CS:WORD PTR [SI.TAILPTR],BX	; And the new pointer
	CLC
QUE_PUT1:
	POP	BX
	RET
QUE_PUT	ENDP

QUE_LOOK	PROC	NEAR		; Peek at next character
	PUSH	BX
	MOV	BX,CS:WORD PTR [SI.HEADPTR]
	CMP	BX,CS:WORD PTR [SI.TAILPTR]
	STC
	JZ	QUE_LOOK1	; If que is empty

;	Not empty, Get character

	MOV	AL,CS:BYTE PTR [BX]
	CLC
QUE_LOOK1:
	POP	BX
	RET
QUE_LOOK	ENDP

;	QUE_BUMP - Bump a que pointer
;
;	BX = A pointer into one of the que
;	SI = pointer to the start of the que
;	Returns BX updated

QUE_BUMP:
	INC	BX			; Bump it up one
	MOV	CX,SI
	ADD	CX,SIZE QUESTR + QUE_LENGTH
	CMP	BX,CX			; ZR set if too far
	JNZ	QUE_BUMP1
	SUB	BX,OFFSET QUE_LENGTH
QUE_BUMP1:
	RET

	INCLUDE	 Z204IO.ASM			; Get the real I/O routines

;	NOTE: The label END_DRIVER is defined in Z204IO.ASM, and therefore,
;	everything defined beyond this point is overlayed after the INIT
;	call is made.

;	This routine initializes the 8259a

INIT_8259:
	MOV	AL,ICW1OP+ICW1SNG+ICW1LT
	OUT	Z204PIC+ICW1,AL
	XOR	AL,AL
	OUT	Z204PIC+ICW2,AL
	MOV	AL,NOT (OCW1IM0+OCW1IM1+OCW1IM2+OCW1IM3+OCW1IM6)
	OUT	Z204PIC+OCW1,AL

;	Now reset the master 8259a on the motherboard

	IN	AL,ZM8259A+OCW1
	AND	AL,NOT (1 SHL ZINTSLV)
	OUT	ZM8259A+OCW1,AL

	MOV	AL,NOT OCW1IM0
	OUT	ZS8259A+OCW1,AL

;	Read and clear the interrupts from both devices

	MOV	AL,OCW3OP+OCW3P
	OUT	ZS8259A+OCW3,AL			; Poll the device
	IN	AL,ZS8259A+OCW3			; Clear pendings here too

;	Now set up the interrupt vectors

	PUSH	ES
	XOR	AX,AX
	MOV	ES,AX				; AX = interrupt page
	MOV	SI,OFFSET Z204_INTVEC*4		; ES:SI points to it

;	We hope that CHR_INIT has made the device hospitable!

	MOV	ES:WORD PTR [SI],OFFSET INT_RTN
	MOV	ES:WORD PTR [SI+2],CS
	POP	ES
	RET

;**	DEV_INIT - Initialize the devices
;
;	DEV_INIT pre-initializes the devices so that devices
;	not used by the user routine will not cause
;	spurious interrupts, etc.
;

DEV_INIT:

;	First, 2661 #1

	XOR	AL,AL
	OUT	Z204EP2A+EPCMD,AL		; Turn it off
	IN	AL,Z204EP2A+EPCMD		; Reset mode pointer
	MOV	AL,EPSB1+EPCL8+EPA16X		; 1 stop bit, 8bit words x16
	OUT	Z204EP2A+EPMODE,AL		;   Set in mode 1
	MOV	AL,EPB960+EPMR2A		; 9600 baud Internal clocks
	OUT	Z204EP2A+EPMODE,AL		;   Set in mode 2
	MOV	AL,EPRTS+EPRESE+EPRXEN+EPDTR	; RTS, DTR, Rx enable, reset
	OUT	Z204EP2A+EPCMD,AL		;   Set in command reg
	IN	AL,Z204EP2A+EPDATA
	IN	AL,Z204EP2A+EPDATA		; Clear any data

;	Next, 2661 #2

	XOR	AL,AL
	OUT	Z204EP2B+EPCMD,AL		; Turn it off
	IN	AL,Z204EP2B+EPCMD		; Reset mode pointer
	MOV	AL,EPSB1+EPCL8+EPA16X		; 1 stop bit, 8bit words x16
	OUT	Z204EP2B+EPMODE,AL		;   Set in mode 1
	MOV	AL,EPB960+EPMR2A		; 9600 baud Internal clocks
	OUT	Z204EP2B+EPMODE,AL		;   Set in mode 2
	MOV	AL,EPRTS+EPRESE+EPRXEN+EPDTR	; RTS, DTR, Rx enable, reset
	OUT	Z204EP2B+EPCMD,AL		;   Set in command reg
	IN	AL,Z204EP2B+EPDATA
	IN	AL,Z204EP2B+EPDATA		; Clear them out

;	Now set up the clock generator

	MOV	AL,(BRC960 SHL 4)+BRC960	; Both Tx and Rx
	OUT	Z204BRCA,AL
	OUT	Z204BRCB,AL			; Set them both up

;	And finally, the 8274 channels A and B

	XOR	AL,AL
	OUT	Z204MPSC+MPACMD,AL		; Reset command pointer
	MOV	AL,MPCHNR
	OUT	Z204MPSC+MPACMD,AL		; Reset the device
	IN	AL,ZDIPSW			; Pause for reset
	MOV	AL,WR4				; Address register 4
	OUT	Z204MPSC+MPACMD,AL		; Point to it
	MOV	AL,MP1S+MPX16			; 1 stop bit, x16
	OUT	Z204MPSC+MPACMD,AL
	MOV	AL,WR2				; Set register 2
	OUT	Z204MPSC+MPACMD,AL
	MOV	AL,MP88M+MPPR			; 88 mode and reset
	OUT	Z204MPSC+MPACMD,AL
	MOV	AL,WR1
	OUT	Z204MPSC+MPACMD,AL		; Set to register 1
	MOV	AL,MPRIA+MPSAV+MPESIE+MPTIE	; INT on rx,tx,extern w/reset
	OUT	Z204MPSC+MPACMD,AL
	MOV	AL,WR5				; Go to register 5
	OUT	Z204MPSC+MPACMD,AL
	MOV	AL,MPDTR+MPTX8+MPTXE+MPRTS	; 8 bit tx, enable, DTR, RTS
	OUT	Z204MPSC+MPACMD,AL
	MOV	AL,WR3				; Now to register 3
	OUT	Z204MPSC+MPACMD,AL
	MOV	AL,MPRX8+MPRXE			; 8 bit rx, enable
	OUT	Z204MPSC+MPACMD,AL
	MOV	AL,MPRTU+MPRESI
	OUT	Z204MPSC+MPACMD,AL		; Reset it
	IN	AL,Z204MPSC+MPADAT
	IN	AL,Z204MPSC+MPADAT
	IN	AL,Z204MPSC+MPADAT		; Clear inputs
	IN	AL,Z204MPSC+MPADAT

;	Do channel B

	XOR	AL,AL
	OUT	Z204MPSC+MPBCMD,AL		; Reset command pointer
	MOV	AL,MPCHNR
	OUT	Z204MPSC+MPBCMD,AL		; Reset the device
	IN	AL,ZDIPSW			; Pause for reset
	MOV	AL,WR4				; Address register 4
	OUT	Z204MPSC+MPBCMD,AL		; Point to it
	MOV	AL,MP1S+MPX16			; 1 stop bit, x16
	OUT	Z204MPSC+MPBCMD,AL
	MOV	AL,WR2				; Set register 2
	OUT	Z204MPSC+MPBCMD,AL
	MOV	AL,MP88M+MPPR			; 88 mode and reset
	OUT	Z204MPSC+MPBCMD,AL
	MOV	AL,WR1
	OUT	Z204MPSC+MPBCMD,AL		; Set to register 1
	MOV	AL,MPRIA+MPSAV+MPESIE+MPTIE	; INT on rx,tx,extern w/reset
	OUT	Z204MPSC+MPBCMD,AL
	MOV	AL,WR5				; Go to register 5
	OUT	Z204MPSC+MPBCMD,AL
	MOV	AL,MPDTR+MPTX8+MPTXE+MPRTS	; 8 bit tx, enable, DTR, RTS
	OUT	Z204MPSC+MPBCMD,AL
	MOV	AL,WR3				; Now to register 3
	OUT	Z204MPSC+MPBCMD,AL
	MOV	AL,MPRX8+MPRXE			; 8 bit rx, enable
	OUT	Z204MPSC+MPBCMD,AL
	MOV	AL,MPRTU+MPRESI
	OUT	Z204MPSC+MPBCMD,AL		; Reset it
	IN	AL,Z204MPSC+MPBDAT
	IN	AL,Z204MPSC+MPBDAT
	IN	AL,Z204MPSC+MPBDAT		; Clear inputs
	IN	AL,Z204MPSC+MPBDAT

	RET

CODE	ENDS
	END

