;
; Definitions for MS-DOS
;

    IFDEF BIOS
	FBIOS = BIOS
    ELSE
	FBIOS = 0
    ENDIF

    IF NOT FBIOS

LORGADDR	=	400H	; Loader org address


;
; BIOS entry points
;

BIOS_SEG SEGMENT AT 40H		; Segment where the BIOS is located

; MicroSoft(MS) defined entry points

	ORG 0*3
  BIOS_INIT	LABEL FAR	; Initialization routine (only exists
				;   at boot time)
	ORG 1*3
  BIOS_STATUS	LABEL FAR	; Console input status
	ORG 2*3
  BIOS_CONIN	LABEL FAR	; Console input
	ORG 3*3
  BIOS_CONOUT	LABEL FAR	; Console output
	ORG 4*3
  BIOS_PRINT	LABEL FAR	; Printer output
	ORG 5*3
  BIOS_AUXIN	LABEL FAR	; Aux input
	ORG 6*3
  BIOS_AUXOUT	LABEL FAR	; Aux output
	ORG 7*3
  BIOS_READ	LABEL FAR	; Disk input
	ORG 8*3
  BIOS_WRITE	LABEL FAR	; Disk output
	ORG 9*3
  BIOS_DSKCHG	LABEL FAR	; Disk change status
	ORG 10*3
  BIOS_SETDATE	LABEL FAR	; Set current date
	ORG 11*3
  BIOS_SETTIME	LABEL FAR	; Set current time
	ORG 12*3
  BIOS_GETDATE	LABEL FAR	; Get current date
	ORG 13*3
  BIOS_FLUSH	LABEL FAR	; Flush keyboard buffer
	ORG 14*3
  BIOS_MAPDEV	LABEL FAR	; Device mapping
	ORG 15*3
  BIOS_MRES9	LABEL FAR	; Reserved for MicroSoft entry points
	ORG 16*3
  BIOS_MRES8	LABEL FAR
	ORG 17*3
  BIOS_MRES7	LABEL FAR
	ORG 18*3
  BIOS_MRES6	LABEL FAR
	ORG 19*3
  BIOS_MRES5	LABEL FAR
	ORG 20*3
  BIOS_MRES4	LABEL FAR
	ORG 21*3
  BIOS_MRES3	LABEL FAR
	ORG 22*3
  BIOS_MRES2	LABEL FAR
	ORG 23*3
  BIOS_MRES1	LABEL FAR


; Zenith Data System(ZDS) defined entry points

	ORG 24*3
  BIOS_DSKFUNC	LABEL FAR	; Disk function
	ORG 25*3
  BIOS_PRNFUNC	LABEL FAR	; PRN(Printer) function
	ORG 26*3
  BIOS_AUXFUNC	LABEL FAR	; AUX(modem) function
	ORG 27*3
  BIOS_CONFUNC	LABEL FAR	; CON(console) function
 	ORG 28*3
  BIOS_ZRES4	LABEL FAR	; Reserved for Zenith entry points
	ORG 29*3
  BIOS_ZRES3	LABEL FAR
	ORG 30*3
  BIOS_ZRES2	LABEL FAR
	ORG 31*3
  BIOS_ZRES1	LABEL FAR
	ORG 32*3
  BIOS_REL	LABEL BYTE	; Bios release number in hex 
				;  (ie 012H is release 1.2x)
	ORG OFFSET BIOS_REL+1
  BIOS_CTADDR	LABEL WORD	; Addr of configuration information
	ORG OFFSET BIOS_CTADDR+2

BIOS_SEG ENDS

;
; Configuration vecter
;

CONFG_DSK	EQU 0		; Addr of disk vector
CONFG_PRN	EQU CONFG_DSK+2	; Addr of PRN configuraiton table
CONFG_AUX	EQU CONFG_PRN+2	; Addr of AUX configuration table
CONFG_CON	EQU CONFG_AUX+2	; Addr of CON configuration table
CONFG_FNT	EQU CONFG_CON+2	; Addr of Font information
  FNT_RAM	  EQU 0		  ; Ptr to font table in RAM
  FNT_ROM	  EQU FNT_RAM+4	  ; Ptr to font table in ROM
  FNT_SIZE	  EQU FNT_ROM+4	  ; Size of font table in ROM
  FNT_MSIZE	  EQU FNT_SIZE+2  ; Space allocated for font table in RAM
CONFG_CLOCK	EQU CONFG_FNT+2	; Addr of Date and time fields
  BIOS_DATE	  EQU 0		  ; Days since Jan 1, 1980
  BIOS_HRS	  EQU BIOS_DATE+2 ; Hours since midnight
  BIOS_MIN	  EQU BIOS_HRS+1  ; Minutes
  BIOS_SEC	  EQU BIOS_MIN+1  ; Seconds
  BIOS_HSEC	  EQU BIOS_SEC+1  ; Hundredths of seconds(a word)
CONFG_DOSTB	EQU CONFG_CLOCK+2	; Addr of DOS disk tables 
CONFG_MCL	EQU CONFG_DOSTB+2	; Addr of memory control info
CONFG_ASP	EQU CONFG_MCL+2	; Addr of aspect ratio & light pen info
  ASP_XVAL	  EQU 0		  ; X aspect ratio value
  ASP_YVAL	  EQU ASP_XVAL+1  ; Y aspect ratio value
  ASP_LPEF	  EQU ASP_YVAL+1  ; Light pen error (in character cells)
  ASP_LPHF	  EQU ASP_LPEF+2  ; Light pen hit flag (=1 when hit)
  ASP_LPHCA	  EQU ASP_LPHF+1  ; Character address of hit
  ASP_LPHPA	  EQU ASP_LPHCA+2 ; Pixel address within character address
  ASP_PRSCF	  EQU ASP_LPHPA+1 ; Flag for PRINT SCREEN function
CONFG_QCON	EQU CONFG_ASP+2	; Address of con que descriptor
CONFG_QSRA	EQU CONFG_QCON+2 ; Address of Serial A descriptor
CONFG_QSRB	EQU CONFG_QSRA+2 ; Address of Serial B descriptor
CONFG_SIZE	EQU CONFG_QSRB+2 ; Length of configuration vector

    ENDIF

ASP_X		EQU 31		; Default aspect ratio X
ASP_Y		EQU 64		; Default aspect ratio Y
BIOS_CREL	EQU 10H		; Current release of BIOS
BIOS_WORKSP	EQU 256		; Number of bytes needed for
				;   workspace in BIOS
BIOS_RELDATE	EQU 1200	; Release date 04/15/83 (this changes
				;   for each release)
MS_SIZEMEM	EQU 1		; Flag for DOS to size memory at init


;
;  System functions for "interrupt 21"
;    (Note: functions followed by "*" are
;           not CP/M compatable
;

DOSF_TERM	EQU  0		; Program terminate
DOSF_CONIN	EQU  1		; Console input
DOSF_CONOUT	EQU  2		; Console output
DOSF_AUXIN	EQU  3		; Aux input
DOSF_AUXOUT	EQU  4		; Aux output
DOSF_PRINTOUT	EQU  5		; Printer output
DOSF_DRCIO	EQU  6		; Direct console I/O
DOSF_DRCI	EQU  7		; * Direct console input
DOSF_DRCINE	EQU  8		; * Console input(no echo)
DOSF_OUTSTR	EQU  9		; Output string
DOSF_INSTR	EQU 10		; Input string
DOSF_STCON	EQU 11		; Status of console
DOSF_CONINF	EQU 12		; * Flush keyboard buffer and input
DOSF_RSDISK	EQU 13		; Disk system reset
DOSF_SELDISK	EQU 14		; Select default disk
DOSF_OPFILE	EQU 15		; Open file
DOSF_CLFILE	EQU 16		; Close file
DOSF_SRHFI	EQU 17		; Search for first
DOSF_SRHNX	EQU 18		; Search for next
DOSF_DEFILE	EQU 19		; Delete file
DOSF_SEQREAD	EQU 20		; Sequential read
DOSF_SEQWRITE	EQU 21		; Sequential write
DOSF_CRFILE	EQU 22		; Create file
DOSF_REFILE	EQU 23		; Rename file
DOSF_24		EQU 24		; * not used
DOSF_GETDISK	EQU 25		; Get default disk
DOSF_SDIOA	EQU 26		; Set disk I/O address
DOSF_GFATA	EQU 27		; * Get file allocation table addr

;* The remaining functions are not CP/M compatable

DOSF_GFATA128	EQU 28		; Get file allocation table addr
DOSF_29		EQU 29		; not used
DOSF_30		EQU 30		; not used
DOSF_31		EQU 31		; not used
DOSF_32		EQU 32		; not used
DOSF_RANREAD	EQU 33		; Random read
DOSF_RANWRITE	EQU 34		; Random write
DOSF_GFSIZE	EQU 35		; Get file size
DOSF_SFPOS	EQU 36		; Set file position
DOSF_SIVEC	EQU 37		; Set interrupt vecter
DOSF_CESEG	EQU 38		; Create segment
DOSF_RBLREAD	EQU 39		; Random block read
DOSF_RBLWRITE	EQU 40		; Random block write
DOSF_PARSE	EQU 41		; Parse file name
DOSF_GDATE	EQU 42		; Get date
DOSF_SDATE	EQU 43		; Set date
DOSF_GTIME	EQU 44		; Get time
DOSF_STIME	EQU 45		; Set time
DOSF_CVERF	EQU 46		; Set/Reset verify flag


;
; Define the interrupts
;

DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
DOSI_TADDR	EQU 22H		; Terminate address
DOSI_CADDR	EQU 23H		; ^C Exit address
DOSI_FERADDR	EQU 24H		; Fatal error exit addr
DOSI_ADREAD	EQU 25H		; Absolute disk read
DOSI_ADWRITE	EQU 26H		; Absolute disk write
DOSI_TERMR	EQU 27H		; Program terminate, but stay resident


;
; Define the program header
;

PHD_TERM	EQU 000H	; Termination point (has INT 20H)
PHD_MEMSIZE	EQU 002H	; Memory size (first seg num 
				;   after end of mem)
PHD_AFUNC	EQU 005H	; Alternate function entry point
PHD_EXADDR	EQU 00AH	; Exit handler addr
PHD_ABADDR	EQU 00EH	; ^C handler addr
PHD_FEADDR	EQU 012H	; Fatal error handler addr
PHD_STACK	EQU 05BH	; End of stack area
PHD_FCB1	EQU 05CH	; First program argument
PHD_FCB2	EQU 06CH	; Second program argument
PHD_DIOA	EQU 080H	; Default disk transfer area
PHD_CODESTART	EQU 100H	; Start of code (Size of a PHD)


;
; Define the "User" File control block (FCB)
;

FCB_DRIVE	EQU 0		; Drive number
FCB_FNAME	EQU FCB_DRIVE+1	; File name
FCB_EXT		EQU FCB_FNAME+8	; Extension to file name
FCB_CURBLK	EQU FCB_EXT+3	; Current block
FCB_RECSZ	EQU FCB_CURBLK+2 ; Record size
FCB_FILSZ	EQU FCB_RECSZ+2	; File size
FCB_DATE	EQU FCB_FILSZ+4 ; Date file modified
FCB_TIME	EQU FCB_DATE+2	; Time file modified
FCB_RES		EQU FCB_TIME+2  ; Reserved
FCB_CURREC	EQU FCB_RES+8	; Current record(in block)
FCB_RANREC	EQU FCB_CURREC+1 ; Random record number
FCB_SIZE	EQU FCB_RANREC+4 ; Size of a FCB


;
; Define the extended file control block
;

XFCB_FLAG	EQU 0		; Flag field
XFCB_RES	EQU XFCB_FLAG+1	; Reserved
XFCB_ATTR	EQU XFCB_RES+5	; Attribute byte
  XFCBA_HID	  EQU 02H	  ; Hidden files
  XFCBA_SYS	  EQU 04H	  ; System files
XFCB_FCB	EQU XFCB_ATTR+1	; Normal FCB
XFCB_SIZE	EQU XFCB_FCB+FCB_SIZE ; Size of a XFCB

 		
;
; Define the directory entries
;

DE_FNAME	EQU 0		; File name
DE_EXT		EQU DE_FNAME+8  ; Extension to file name
DE_ATTR		EQU DE_EXT+3	; File attribute
  DEA_HID	  EQU 02H	  ; Hidden file
  DEA_SYS	  EQU 04H	  ; System file
DE_RES		EQU DE_ATTR+1	; Reserved
DE_TIME		EQU DE_RES+10	; Time the file was modified
DE_DATE		EQU DE_TIME+2	; Date the file was modified
DE_START	EQU DE_DATE+2	; Starting allocation unit
DE_FSIZE	EQU DE_START+2	; File size
DE_SIZE		EQU DE_FSIZE+4	; Size of a DE (should be 32)


;
; Define the "Drive parameter table" for MS-DOS usage
;  (Used only by the BIOS at init time)

DPT_SECSIZ	EQU 0		; Size in bytes of a physical sector
DPT_CLUSIZ	EQU DPT_SECSIZ+2 ; Number of sectors in an
				 ;   allocation unit
DPT_RESSEC	EQU DPT_CLUSIZ+1 ; Number of reserved sectors at
				 ;   start of disk
DPT_FATCNT	EQU DPT_RESSEC+2 ; Number of FAT's
DPT_MAXENT	EQU DPT_FATCNT+1 ; Number of directory entries
DPT_DSKSIZ	EQU DPT_MAXENT+2 ; Number of physical sectors on
				 ;   the disk
DPT_SIZE	EQU DPT_DSKSIZ+2 ; Size of a DPT


;
; Define the disk errors
;

DSKE_WRITEP	EQU 0		; Write protect
DSKE_NREADY	EQU 2		; Not ready
DSKE_DATA	EQU 4		; Data error
DSKE_SEEK	EQU 6		; Seek
DSKE_SECT	EQU 8		; Sector not found
DSKE_WFAULT	EQU 10		; Write fault
DSKE_OTHER	EQU 12		; Anything else

