

;	MACLIB - library of commonly used macro definitions

SVC	MACRO	DOSF   			;Supervisor (DOS function) call
	MOV	AH,DOSF   	
	INT	21H
	ENDM

RETF	MACRO				;Return far instruction emulation
	LOCAL	TEMP1
TEMP1	PROC	FAR
	RET
TEMP1	ENDP
	ENDM

PUSHALL	MACRO				;Save all registers
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	ENDM

POPALL	MACRO				;Restore all registers
	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	ENDM

ERRNZ	MACRO	LABEL,ADDRESS		;Check current location
   IF	(($-OFFSET LABEL)-ADDRESS NE 0)
#1:	DW	LABEL,ADDRESS
   ENDIF
	ENDM

ERRZR	MACRO	LABEL,ADDRESS		;Error if zero
   IF	(($-OFFSET LABEL)-ADDRESS EQ 0)
#1:	DW	LABEL,ADDRESS
   ENDIF
	ENDM
