	XLIB FileEprRandomID

	LIB SafeSegmentMask
	LIB MemReadLong
	LIB FlashStoreFileEpr


if QDOS
	INCLUDE "flstore_def"
	INCLUDE "#error_def"
else
	include "flstore.def"
	INCLUDE "#error.def"
endif


; ************************************************************************
;
; Standard Z88 File Eprom Format, including support for sub File Eprom
; Area in application cards (below application banks in first free 64K boundary)
;
; Return File Eprom "oz" Header Random ID from slot x (1, 2 or 3)
;
; -----------------------------------------------------------------------
;
; $Header: /Z88/StdLib/FileEprom/EprRndID.asm 3     16-08-98 16:04 Gbs $
;
; $History: EprRndID.asm $
; 
; *****************  Version 3  *****************
; User: Gbs          Date: 16-08-98   Time: 16:04
; Updated in $/Z88/StdLib/FileEprom
; Extended for Sub File Eprom handling.
; 
; *****************  Version 2  *****************
; User: Gbs          Date: 24-01-98   Time: 20:41
; Updated in $/Z88/StdLib/FileEprom
; INCLUDE directives optimized (if any)
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 20-01-98   Time: 8:55
; Created in $/Z88/StdLib/FileEprom
; Added to SourceSafe
;
; -----------------------------------------------------------------------
;
; Design & programming by Gunther Strube, InterLogic, Dec 1997 - Aug 1998
;
; -----------------------------------------------------------------------
;
; In:
;	C = slot number (1, 2 or 3)
;
; Out:
;	Success:
;		Fc = 0,
;			DEBC = Random ID (32bit integer)
;
;	Failure:
;		Fc = 1,
;		A = RC_ONF, File Eprom not found
;
; Registers changed after return:
;	......../IXIY same
;	AFBCDEHL/.... different
;
.FileEprRandomID
				LD	E,C				; preserve slot number
				LD	A, FSFLE_SCPT
				CALL FlashStoreFileEpr	; check for presence of "oz" File Eprom in slot
				JR	C, err_nofileepr
				JR	NZ, err_nofileepr	; File Eprom not available in slot...
				LD	A,$C0
				CP	L				; offset $3FC0 (beginning of "oz" header) ?
				JR	NZ,err_nofileepr	; no, a FS II partition header was found...

				LD	A,E
				AND	@00000011			; slots (0), 1, 2 or 3 possible
				RRCA
				RRCA					; Converted to Slot mask $40, $80 or $C0
				OR	B				; absolute bank number of "oz" header...

				CALL SafeSegmentMask	; Get a safe segment address mask
				OR	$3F
				LD	H,A
				LD	L,0				; address $3Foo in top bank of slot B

				LD	A,$F8			; offset $F8, position of Random ID
				CALL MemReadLong
				EXX					; return Random ID in DEBC...
				CP	A				; Fc = 0...
				RET
.err_nofileepr
				SCF
				LD	A,RC_ONF
				RET
