	XLIB FileEprType

	LIB FlashStoreFileEpr
	
if QDOS
	include "flstore_def"
	include "#flashepr_def"
	include "#error_def"
	include "#memory_def"
endif
if MSDOS | Z88 | UNIX
	include "flstore.def"
	include "#flashepr.def"
	include "#error.def"
	include "#memory.def"
endif


; ************************************************************************
;
; Standard Z88 File Eprom Format, including support for sub File Eprom
; area in application cards (below application banks in first free 64K boundary)
;
; Return pointer to Standard File Eprom "oz" header in slot x (1, 2 or 3).
;
; ------------------------------------------------------------------------
;
; $Header: /Z88/StdLib/FileEprom/EprType.asm 3     16-08-98 16:04 Gbs $
;
; $History: EprType.asm $
; 
; *****************  Version 3  *****************
; User: Gbs          Date: 16-08-98   Time: 16:04
; Updated in $/Z88/StdLib/FileEprom
; Extended for Sub File Eprom handling.
; Now return BHL pointer to header and size of File Area in C.
; 
; *****************  Version 2  *****************
; User: Gbs          Date: 24-01-98   Time: 20:41
; Updated in $/Z88/StdLib/FileEprom
; INCLUDE directives optimized (if any)
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 20-01-98   Time: 8:55
; Created in $/Z88/StdLib/FileEprom
; Added to SourceSafe
;
; ------------------------------------------------------------------------
;
; Design & programming by Gunther Strube, InterLogic, Dec 1997 - Aug 1998
;
; ------------------------------------------------------------------------
;
; In:
;	C = slot number (1, 2 or 3)
;
; Out:
;	Success:
;		Fc = 0,
;			A = Sub type of Eprom.
;				Standard 32K, 128K, 256K Eprom (or 1MB Flash Eprom)
;			BHL = Pointer to "oz" header in slot.
;			C = size of File Eprom in total of banks.
;
;	Failure:
;		Fc = 1,
;			A = RC_ONF, File Eprom not found
;
; Registers changed after return:
;	....DE../IXIY same
;	AFBC..HL/.... different
;
.FileEprType
				PUSH DE

				LD	A, FSFLE_SCPT
				CALL FlashStoreFileEpr	; check for presence of "oz" File Eprom in slot C
				LD	E,A				; preserve sub-type for a moment...
				JR 	C,err_fileepr
				JR	NZ,err_fileepr		; File Eprom not available in slot...
				LD	A,$C0
				CP	L				; offset $3FC0 (beginning of "oz" header) ?
				JR	NZ,err_fileepr		; no, a FS II partition header was found...

				LD	C,D				; return size of File Eprom Area in 16K banks
				LD	A,E
				CP	A				; A = sub type of File Eprom, Fc = 0

				POP	DE				; original DE restored
				RET

.err_fileepr		POP	DE
				LD	A,RC_ONF
				SCF
				RET
