	XLIB FlashStoreFileEpr

	LIB MemReadByte, MemAbsPtr
	LIB FlashStore_CheckPartitionID
	LIB FlashStore_NextPartitionID
	LIB ApplEprType
	LIB FlashEprType

if QDOS
	include "flstore_def"
	include "#flashepr_def"
	include "#error_def"
	include "#memory_def"
else
	include "flstore.def"
	include "#flashepr.def"
	include "#error.def"
	include "#memory.def"
endif


; ************************************************************************
;
; FlashStore File Eprom/"oz File Eprom.
;
; Request for partition and "oz" File Eprom information on 
; Flash Eprom Application Card.
;
; ---------------------------------------------------------------
;
; Design & programming by Gunther Strube, InterLogic, Dec 1997 - Aug 1998
;
; ----------------------------------------------------------------------
; Version History:
;
; $Header: /Z88/StdLib/FlashStore/FStFepr.asm 5     16-08-98 16:11 Gbs $
;
; $History: FStFepr.asm $
; 
; *****************  Version 5  *****************
; User: Gbs          Date: 16-08-98   Time: 16:11
; Updated in $/Z88/StdLib/FlashStore
; Extended to recognize an "oz" File Area below application Rom Area, and
; as on true File Eprom Cards.
; 
; *****************  Version 4  *****************
; User: Gbs          Date: 18-04-98   Time: 0:02
; Updated in $/Z88/StdLib/FlashStore
; Added more comments (no code change).
; 
; *****************  Version 3  *****************
; User: Gbs          Date: 16-04-98   Time: 21:02
; Updated in $/Z88/StdLib/FlashStore
; Re-written. Now implemented for full partioning logic on Application
; Card.
; 
; *****************  Version 2  *****************
; User: Gbs          Date: 24-01-98   Time: 20:42
; Updated in $/Z88/StdLib/FlashStore
; INCLUDE directives optimized (if any)
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 20-01-98   Time: 9:24
; Created in $/Z88/StdLib/FlashStore
; Added to SourceSafe
; ---------------------------------------------------------------
;
; In:
;	A = function reason codes
; 		FSFLE_SCPT 	SCan for first ParTition File Area
; 		FSFLE_NXPT	Get NeXt ParTition File Area
;
;	entry arguments depending on request code
;
; Out:
;	results depend on entry arguments
;
.FlashStoreFileEpr	
				CP	FSFLE_SCPT
				JP	Z, FSFE_ScanFirstPartition
				CP	FSFLE_NXPT
				JP	Z, FSFE_GetNextpartition

				LD	A,RC_Unk				; Unknown request
				SCF
				RET


; ************************************************************************
;
; A = FSFLE_SCPT
;	1) Check for a standard "oz" File Eprom, if that fails -
; 	2) Check that slot contains an Application ROM, then check for the 
; 	   Header Identifier in the first top block below reserved 
; 	   application banks on the card.
;	3) If a Rom Front Dor is located in a RAM Card, then this slot
;	   is regarded as a non-valid card as a File Eprom, ie. not present.
;
; 	On partial success, if a Header Identifier is not found, the
; 	returned pointer indicates that the card might hold a file area, 
; 	beginning at this location.
;
;	If the routine returns HL = @3FE0, it's a FS II partition (32 byte header)
;	If the routine returns HL = @3FC0, it's an "oz" partition (64 byte header)
;
; In:
;		C = slot number (1, 2 or 3)
;
; Out:
;	Success, first (top) partition (or potential) available:
;		Fc = 0,

;			BHL = pointer to top Partition ID for slot C (B = slot relative).
;				 (or pointer to free space in File Area).
;			Fz = 1, File Header found
;				A = Device Code of Flash Eprom (or "oz" File Eprom sub type)
;				C = size of card in 16K banks (0 - 64)
;				D = size of partition in 16K banks
;			Fz = 0, File Header not found
;				A undefined
;				C undefined
;				D undefined
;	Failure:
;		Fc = 1,
;			RC_ONF:
;				FlashStore File Area not available (possibly no ROM card)
;				nor any std. File Eprom "oz" header.
;			RC_ROOM, No room for File Area (all banks used for applications)
;
; Registers changed after return:
;	.....E../IXIY same
;	AFBCD.HL/.... different
;
.FSFE_ScanFirstPartition
				PUSH	DE

				LD	B,$3F
				CALL	FlashEprType		; check for std, "oz" File Eprom in slot C...
				JR	C, eval_applrom
					POP	DE
					LD	C,B			; return C = number of 16K banks of card
					LD	D,B			; return D = size of partition (= size of card)
					LD	B,$3F
					LD	HL, $3FC0		; pointer to "oz" header at top of card...
					CP	A			; indicate "Header found" (Fz = 1)
					RET
.eval_applrom
				LD	D,C				; copy of slot number
				CALL ApplEprType
				JR	C,no_appldor		; Application ROM Header not present...
				CP	$82				; Front Dor located in RAM Card?
				JR	Z,no_fstepr		; Yes - indicate Card Not Available...
				
				LD	E,C				; preserve size of card			
				CALL DefPartitionID		; locate and validate Partition ID
				JR	C, no_filespace	; whole card used for Applications...
				LD	H,D				
				LD	C,E				; C = size of card in 16K banks
				POP	DE
				LD	D,H				; D = size of Partition in 16K banks
				RES	7,B
				RES	6,B
				LD	H,$3F			; BHL = ptr. to Partition Identifier, B $3Fxx
				RET					; Fc = 0, Fz = ?
.no_filespace
				POP	DE
				SCF
				LD	A,RC_ROOM
				RET
.no_fstepr							; the slot cannot hold a File Area.
				POP	DE
				SCF
				LD	A,RC_ONF
				RET
.no_appldor							; the slot is empty, but might
				POP	DE
				LD	B,$3F
				LD	HL,$3FC0
				OR	B				; Fc = 0, Fz = 0, indicate no header found
				RET					; but potential "oz" File Eprom header.
								

; ************************************************************************
;
; A = FSFLE_NXPT
; 	Check that BHL points to a real Partition ID, then return pointer
; 	to the next (lower) Partition ID on the Flash Eprom.
; 	If a Partition ID is not found, the returned pointer indicates the
; 	beginning of free Partition File Area that might be created.
;
; In:
;		C = slot number (1, 2 or 3)
;		BHL = pointer to existing Partition ID on card.
;
; Out:
;	Success, next partition (or potential) found:
;		Fc = 0,
;			Fz = 1, Partition ID found
;				BHL = pointer to Partition ID for slot C.
;				A = Device Code of Flash Eprom
;				C = size of card in 16K banks (0 - 64)
;				D = size of partition in 16K banks
;			Fz = 0, Partition ID not found, but free space
;				BHL = pointer to potential Partition ID for slot C.
;				A undefined
;				C undefined
;				D undefined
;	Failure:
;		Fc = 1,
;			RC_ONF, Current Partition ID not found or recognized
;			RC_ROOM, Current Partition ID was the last in File Area
;
; Registers changed after return:
;	.....E../IXIY same
;	AFBCD.HL/.... different
;
.FSFE_GetNextpartition				
				PUSH	DE

				LD	A,C				
				CALL	MemAbsPtr			; convert ptr. for slot C.
				CALL	FlashStore_CheckPartitionID
				JR	C,no_fstepr		; Partition ID not recognised...
				CALL	FlashStore_NextPartitionID

				RES	7,B
				RES	6,B
				LD	H,$3F			; return pointer info as relative...

				POP	DE
				RET


; ************************************************************************
;
; Define the position of the Partition Identifier, starting from top bank 
; of free card space area, calculated by number of reserved banks for 
; application usage, then using the top bank of the first free 64K block
; below the last used 64K block containg application code.
;
; If no space is left for a file area (all banks used for applications),
; then Fc = 1 is returned.
;
; IN:
;		B = number of banks reserved (used) for ROM applications
;		D = slot number
; OUT:
;		Fc = 0 (success),
;			Fz = 1, Top Partition Identifier found
;				A = Intel Chip Device Code
;				C = size of Card in 16K banks (defined by Device Code)
;				D = size of Partition in 16K banks
;			Fz = 0, Partition Identifier not found
;				A undefined
;				C undefined
;				D undefined
;			BHL = pointer to Partition Identifier/"oz" header (or potential)
;		Fc = 1 (failure),
;			No room for File Area.
;
; Registers changed after return:
;	.....E../IXIY same
;	AFBCD.HL/.... different
;
.DefPartitionID
				LD	A,$3F
				SUB	B				; $3F - <ROM banks>
				INC	A				; A = lowest bank of ROM area

				CP	3				;
				JR	Z, hdr_not_found	; Application card uses banks 
				RET	C				; in lowest 64K block of card...

				AND	@11111100
				DEC	A				; A = Top Bank of File Area (in isolated 64K block)

				LD	B,A
				LD	C,D
				LD	D,B				; preserve bank number of pointer
				CALL	FlashEprType
				JR	C, check_fsptid	; "oz" File Eprom Header not found, check for FS partition...
					LD	C,B
					LD	B,D
					LD	D,C			; D = The size of banks in "oz" File Eprom Area
					LD	HL,$3FC0		; BHL = pointer to "oz" File Eprom Header
					CP	A			; return flag status = found!
					RET
.check_fsptid							; "oz" header not found, check for FS partition in same bank
				LD	B,D
				LD	HL,$3FE0
				LD	A,C				; Physical top bank of File Area (for Partition ID)
				CALL	MemAbsPtr			; for slot C.
				CALL	FlashStore_CheckPartitionID
				RET
.hdr_not_found
				SCF
				RET
