	XLIB FlashStoreFileEntryInfo

	LIB MemReadByte
	LIB FileEprReadByte
	LIB PointerNextByte
	LIB AddPointerDistance


; ****************************************************************************
;
; FlashStore File Entry Information.
;
; A identifies information request:
;
; 	FSFEI_PFFE 	Pointer to First File Entry in specified Partition
; 	FSFEI_PNFE 	Pointer to Next File Entry
; 	FSFEI_CPFN 	CoPy FileName to local buffer, null-terminated.
;	FSFEI_GFLA	Get FiLe Attributes
; 	FSFEI_GFLS 	Get FiLe Size of File Entry
; 	FSFEI_OFDS 	Original File Date Stamp to local buffer
; 	FSFEI_FEDS 	File Entry Date Stamp to local buffer
; 	FSFEI_FEVS 	File Entry VerSion
; 	FSFEI_PFLI 	Pointer to FiLe Image
;
; ----------------------------------------------------------------------------
;
; $Header: /Z88/StdLib/FlashStore/FstFinfo.asm 4     28-02-99 12:22 Gbs $
;
; $History: FstFinfo.asm $
; 
; *****************  Version 4  *****************
; User: Gbs          Date: 28-02-99   Time: 12:22
; Updated in $/Z88/StdLib/FlashStore
; ReadEprByte renamed to FileEprReadByte.
; 
; *****************  Version 3  *****************
; User: Gbs          Date: 16-08-98   Time: 16:12
; Updated in $/Z88/StdLib/FlashStore
; Cosmetic changes.
; 
; *****************  Version 2  *****************
; User: Gbs          Date: 24-01-98   Time: 20:42
; Updated in $/Z88/StdLib/FlashStore
; INCLUDE directives optimized (if any)
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 20-01-98   Time: 9:24
; Created in $/Z88/StdLib/FlashStore
; Added to SourceSafe
; 
; ----------------------------------------------------------------------------
;
; Design & programming by Gunther Strube, InterLogic, Dec 1997 - Apr 1998
;
; ----------------------------------------------------------------------------
;
; IN:
;	A = reason code
;	C = slot number
;	BHL = pointer to start of FlashStore File Entry
;
; OUT:
;	Fc = 0, FlashStore File Entry available
;		A = File Entry ID ($01 = active file, $11 = deleted file)
;		BCDEHL = return arguments, depending on reason code
;
;	Fc = 1, FlashStore File Entry not available.
;
; Registers changed after return:
;	..B...HL/IXIY same
;	AF.CDE../.... different
;
.FlashStoreFileEntryInfo

				PUSH HL
				PUSH BC					; preserve BHL pointer

				XOR	A
				CALL MemReadByte			; Read first byte of File Entry
				CP	$FF
				JR	Z, exit_eprfile		; previous File Entry was last in FlashStore File Eprom
				CP	$00
				JR	Z, exit_eprfile		; pointing at start of FlashStore Partition ID!
				CP	$01
				JR	Z, valid_entry			; File Entry marked as active
				CP	$11
				JR	NZ, exit_eprfile
.valid_entry
				PUSH AF					; preserve file status on return...

				PUSH HL
				PUSH BC
				LD	HL,routines
				LD	B,0					; request code in C...
				ADD	HL,BC
				LD	C,(HL)
				INC	HL
				LD	H,(HL)
				LD	L,C
				POP	BC
				EX	(SP),HL				; offset restored (SP) = subroutine addr.
				RET						; call routine

.routines			DEFW FS_NextEntry
				DEFW FS_FileName
				DEFW FS_FileSize
				DEFW FS_FileCreateStamp
				DEFW FS_FileEntryStamp
				DEFW FS_FileEntryVersion
				DEFW FS_FileEntryImage

.return			POP	IY					; restore original IY
				POP	AF					; A = FlashStore File Entry status
				POP	HL
				LD	B,H					; original B restored
				POP	HL					; original HL restored
				RET						; CDE are return arguments

.exit_eprfile		SCF
				POP	BC
				POP	HL
				RET



; ****************************************************************************
;
; Return pointer to next FlashStore File Entry in CDE
;
; IN:
;	BHL = pointer to FlashStore File Entry
;
; OUT:
;	CDE = pointer to next File Entry
;
.FS_NextEntry
				JR	return



; ****************************************************************************
;
; Store FlashStore File Entry Filename at (DE)
;
; IN:
;	BHL = pointer to FlashStore File Entry
;
; OUT:
;	C = length of filename
;	(DE) = copy of filename, null-terminated
;
.FS_FileName
				JR	return



; ****************************************************************************
;
; Return size of File Image in CDE
;
; IN:
;	BHL = pointer to FlashStore File Entry
;
; OUT:
;	CDE = size of file image, (24bit integer, C = most signf. byte)
;
.FS_FileSize
				JR	return



; ****************************************************************************
;
; Return original RAM File Create Date Stamp at (DE).
; (6 bytes are copied; 3 byte internal date, 3 byte internal time)
;
; IN:
;	BHL = pointer to FlashStore File Entry
;
; OUT:
;	(DE) = File stamp copied.
;
.FS_FileCreateStamp
				JR	return




; ****************************************************************************
;
; Return File Entry Create Date Stamp at (DE).
; (6 bytes are copied; 3 byte internal date, 3 byte internal time)
;
; IN:
;	BHL = pointer to FlashStore File Entry
;
; OUT:
;	(DE) = File Entry Create Date Stamp
;
.FS_FileEntryStamp
				JR	return



; ****************************************************************************
;
; Return File Entry Version number.
;
; IN:
;	BHL = pointer to FlashStore File Entry
;
; OUT:
;	C = File Entry File Version number
;
.FS_FileEntryVersion
				JR	return



; ****************************************************************************
;
; Return pointer to File Entry File Image in CDE
;
; IN:
;	BHL = pointer to FlashStore File Entry
;
; OUT:
;	CDE = pointer to next File Entry File Image
;
.FS_FileEntryImage
				JR	return



