
; Overview of bank usage in 128K ROM:
;
; Bank $38 (56):    Reserved for Intuition
; Bank $39 (57):    Z80asm application bank 0 ($8000)
; Bank $3A (58):    Z80asm application bank 1 ($C000)
; Bank $3B (59):    Z80asm MTH.
; Bank $3C (60):    Zprom application, FreeRam popdown
; Bank $3D (61):    Z80debug application
; Bank $3E (62):    Z80debug MTH, Zprom MTH
; Bank $3F (63):    Token base, MultiLink & PClink applications, Front DOR & ROM Header

DEFGROUP  {    Intuition_bank = $38,
               ZetriZ_bank = $38,
               Z80asm_bank1,
               z80asm_bank2,
               z80asm_MTH_bank,
               Zprom_bank, FreeRam_bank = Zprom_bank
               Z80dbg_bank,
               Z80dbg_MTH_bank, Zprom_MTH_bank = Z80dbg_MTH_bank,
               Easylink_bank,
               tokens_bank = Easylink_bank
          }

DEFC MTH_Z80asm_ORG = 0
DEFC MTH_Z80dbg_ORG = 0
DEFC MTH_Zprom_ORG = $1200         ; MTH Z80dbg & MTH Zprom in same bank
DEFC Token_base = 0

DEFC Intuition_init = $2000
DEFC ZetriZ_DOR = $0000
DEFC Z80asm_DOR = $8000, Z80asm_workspace = $1ffe-$1b00
DEFC Zprom_DOR = $C000, Zprom_workspace = 256
DEFC Z80dbg_DOR = $C000, Z80dbg_workspace = 0
DEFC Easylink_DOR = $C400, EasyLink_workspace = 1072
DEFC FreeRam_DOR = $F800, FreeRam_Workspace = 32

; Command Codes for Zprom application:
DEFC  Zprom_CC_mbl   = $80, Zprom_CC_mbs   = $8A, Zprom_CC_mbcl  = $8D, Zprom_CC_me    = $87, Zprom_CC_ms   = $8C
DEFC  Zprom_CC_mv    = $81, Zprom_CC_eprog = $89, Zprom_CC_eprd  = $8B, Zprom_CC_epck  = $8E, Zprom_CC_epvf = $86
DEFC  Zprom_CC_ev    = $82, Zprom_CC_es    = $88, Zprom_CC_et    = $85, Zprom_CC_eb    = $83, Zprom_CC_er   = $84
DEFC  Zprom_CC_rbw   = $8F, Zprom_CC_br    = $90, Zprom_CC_be    = $91, Zprom_CC_bv    = $92, Zprom_CC_rbcl = $93
DEFC  Zprom_CC_rclc  = $94, Zprom_CC_copy  = $95, Zprom_CC_clone = $96, Zprom_CC_bs    = $97, Zprom_CC_flbe =$98
DEFC  Zprom_CC_fli   = $99, Zprom_CC_fltst = $9A
