
     MODULE Input_buffer

     XREF Calc_HL_Ptr
     XREF Save_alternate, Restore_alternate

     XREF SkipSpaces, GetChar, UpperCase
     XREF Display_Char, Display_string, Write_CRLF

     ; Defined in 'Windows_asm':
     XREF Set_CurPos, ToggleWindow

     XREF GetKey

     XDEF InputCommand, Input_buffer, Prompt

     INCLUDE "Defs_h"


; **************************************************************************
;
; Command line input, 17 bytes max. input.
;
; BIT 5,(IY+77) = 1 indicates previous buffer contents.
;
; Register status after return:
;
;       ......../IXIY     same
;       AFBCDEHL/....afb  different
;
; Stack usage:  2 bytes
;
.InputCommand     LD   C, 48
                  CALL Calc_HL_Ptr          ; HL = IY + 48 , input buffer...
                  LD   D,H
                  LD   E,L                  ; get a copy of start of buffer...
                  LD   A,16                 ; size of input buffer (excl. size byte)    ** V0.19c
                  EX   AF,AF'               ;                                           ** V0.19c
                  XOR  A                    ;                                           ** V0.19c
                  BIT  0,(IY+78)            ; set parameter to 0 if no prev. contents   ** V0.19c
                  JR   Z, continue_input    ;                                           ** V0.19c
                  LD   A,255                ; indicate prev. contents in buffer         ** V0.19c
.continue_input   EX   AF,AF'               ;                                           ** V0.19c
                  CALL Input_Buffer         ;                                           ** V0.19c
                  LD   A,C                  ; get length of input                       ** V0.19c
                  CP   0                    ; no input?                                 ** V0.19c
                  JR   Z, no_contents       ;                                           ** V0.19c
                  SET  0,(IY+78)            ; Yes, this can be recalled next time...    ** V0.19c
                  RET
.no_contents      RES  0,(IY+78)            ;                                           ** V0.19c
                  RET



; *****************************************************************************************
;
; Command line input.
;
; Entry:
;
; A' = flag to indicate if buffer contains information that can be recalled
; A  = size of input buffer.
; DE = start of true buffer
;
; On return, HL will point to start of buffer
;
; register usage:
;         A    = char fetched from keyboard in buffer.
;         B    = relative ptr. to current char from start of buffer.
;         C    = relative ptr. to null-terminator in buffer (not end of buffer).
;         DE   = absolute ptr. to start of buffer.
;         (DE) = size of input buffer                                                   ** V0.19c
;         HL   = absolute ptr. to current position in input buffer.
;
; Register status after return:
;
;       ......../IXIY     same
;       AFBCDEHL/....afb  different
;
.Input_Buffer     CALL DisplayPrompt        ; display command prompt                    ** V0.19c
                  LD   (DE),A               ; store max. length of input buffer
                  LD   BC,0
                  LD   H,D
                  LD   L,E
                  INC  HL                   ; point at first char to input.
                  CALL GetKey               ;                                           ** V0.91c
                  CP   $D1                  ; <SHIFT><ENTER> pressed?                   ** V0.19c
                  JP   Z, get_prev_line     ; try to recall prev. buffer                ** V0.19c
                  LD   (HL),0               ; not possible, initialise start of buffer  ** V0.20
                  JR   eval_key             ; Not pressed - check the other keys        ** V0.19c
.input_loop       CALL GetKey
.eval_key         CP   $FC                  ; left cursor key?                          ** V0.18
                  JP   Z, move_left         ;                                           ** V0.18
                  CP   $FD                  ; right cursor key?                         ** V0.18
                  JP   Z, move_right        ;                                           ** V0.18
                  CP   $D3                  ; <SHIFT><DEL> ?                            ** V0.27d
                  JP   Z, shft_delete_key   ;                                           ** V0.27d
                  CP   13
                  JR   Z, enter_key
                  CP   27
                  JR   Z, escape_key
                  CP   9                    ; <TAB>?
                  JP   Z, inp_togglewindow
                  CP   3                    ; <Diamond>C ?
                  JP   Z, Clear_window
                  CP   32
                  JP   M, input_loop
                  CP   127                  ; <DEL> ?
                  JP   Z, delete_key
                  JP   P, input_loop        ; all chars > 127 ignored...                ** V0.19c
;
; store char...
                  EXX                       ;                                           ** V0.18
                  LD   B,A                  ; tmp store of char                         ** V0.18
                  EXX                       ;                                           ** V0.18
                  LD   A,(DE)               ; get rel. ptr to last char                 ** V0.19c
                  DEC  A                    ;                                           ** V0.19c
                  CP   C                    ; buffer full?                              ** V0.19c
                  JR   Z, input_loop        ; yes, don't save char...                   ** V0.18
                  LD   A,C                  ; get rel. ptr. to last in buffer           ** V0.18
                  CP   B                    ;                                           ** V0.18
                  JR   Z, cursor_at_end     ;                                           ** V0.18
                  SUB  B                    ; A = no. of char to move...                ** V0.18
                  PUSH BC                   ; remember rel. pointers                    ** V0.18
                  LD   H,D                  ;                                           ** V0.18
                  LD   L,E                  ;                                           ** V0.18
                  INC  HL                   ; HL = start of input buffer                ** V0.20
                  LD   B,0                  ;                                           ** V0.18
                  ADD  HL,BC                ; HL = ptr. to last char (null-terminator)  ** V0.18
                  PUSH DE                   ; save ptr. to start of buffer              ** V0.18
                  LD   D,H                  ;                                           ** V0.18
                  LD   E,L                  ; DE = destination                          ** V0.18
                  INC  HL                   ;                                           ** V0.18
                  LD   (HL),0               ; null-terminate new end                    ** V0.18
                  DEC  HL                   ;                                           ** V0.18
                  DEC  HL                   ;                                           ** V0.18
                  LD   C,A                  ; no. of chars to move...                   ** V0.18
                  LDDR                      ; move chars 1 byte to the right...         ** V0.18
                  POP  DE                   ; restore ptr. to start of input buffer     ** V0.18
                  POP  BC                   ; restore rel. ptr. to last char            ** V0.18
                  EXX                       ;                                           ** V0.18
                  LD   A,B                  ; get char from keyboard                    ** V0.18
                  EXX                       ;                                           ** V0.18
                  INC  HL                   ;                                           ** V0.18
                  LD   (HL),A               ; put char from keyboard at cursor pos.     ** V0.18
                  INC  HL                   ; ptr. ready for next char                  ** V0.18
                  INC  C                    ; rel. ptr. to last char...                 ** V0.18
                  INC  B                    ;                                           ** V0.18
                  CALL Display_Char         ; display new char                          ** V0.18
                  PUSH BC                   ;                                           ** V0.18
                  PUSH HL                   ;                                           ** V0.18
                  PUSH DE                   ;                                           ** V0.18
                  CALL Get_CurPos           ; BC = current cursor pos. in window        ** V0.18
                  CALL Display_String       ; write string from cursor to last char     ** V0.18
                  CALL Set_CurPos           ; put cursor back at (C,B)                  ** V0.18
                  POP  DE                   ;                                           ** V0.18
                  POP  HL                   ;                                           ** V0.18
                  POP  BC                   ; restore rel. ptr. to last char
                  JP   input_loop

.cursor_at_end    EXX                       ;                                           ** V0.18
                  LD   A,B                  ;                                           ** V0.18
                  EXX                       ;                                           ** V0.18
                  LD   (HL),A               ; no, save char in buffer
                  INC  C                    ;                                           ** V0.18
                  INC  B                    ;                                           ** V0.18
                  INC  HL                   ; inc. pointer for next char
                  LD   (HL),0               ; null-terminate
                  CALL Display_Char
                  JP   input_loop           ; get next input key

.enter_key        LD   H,D                  ;                                           ** V0.18
                  LD   L,E                  ; get a copy of start of input buffer       ** V0.18
                  INC  HL                   ; set HL to point at start of buffer        ** V0.19c
                  CALL Write_CRLF           ; execute a 'new line'
                  RET

.escape_key       CALL  Write_CRLF          ; execute a new line...
                  CALL  DisplayPrompt       ;                                           ** V0.19c
                  LD    H,D
                  LD    L,E
                  INC   HL                  ;                                           ** V0.19c
                  LD    BC,0                ; relative pointers to start of buffer      ** V0.18
                  LD    (HL),0              ; null-terminate start of buffer
                  JP    input_loop

.move_left        LD   A,B                  ; fetch relative pointer                    ** V0.18
                  CP   0                    ; cursor at start of buffer?                ** V0.18
                  JP   Z, input_loop        ; yes, continue                             ** V0.18
                  DEC  B                    ; update relative pointer                   ** V0.18
                  DEC  HL                   ; adjust ptr. in buffer one char left       ** V0.18
                  LD   A,8                  ;                                           ** V0.18
                  CALL Display_Char         ; move cursor one char left...              ** V0.18
                  JP   input_loop

.move_right       LD   A,B                  ; fetch relative pointer                    ** V0.18
                  CP   C                    ; cursor at end of buffer?                  ** V0.18
                  JP   Z, input_loop        ; yes, continue                             ** V0.18
                  INC  B                    ; update relative pointer                   ** V0.18
                  INC  HL                   ; adjust ptr. in buffer one char left       ** V0.18
                  LD   A,9                  ;                                           ** V0.18
                  CALL Display_Char         ; move cursor one char right...             ** V0.18
                  JP   input_loop

.delete_key       LD   A,B                  ; fetch relative pointer                    ** V0.18
                  CP   0                    ; start of buffer?
                  JP   Z, input_loop        ; nothing to delete, continue
                  CP   C                    ; at last char or somewhere in the middle?  ** V0.18
                  JR   Z, del_last_char     ; delete character at the end...
                  LD   A,C                  ;                                           ** V0.18
                  SUB  B                    ; A = no. of char to move...                ** V0.18
                  PUSH DE                   ;                                           ** V0.18
                  LD   D,H                  ;                                           ** V0.18
                  LD   E,L
                  DEC  DE                   ; DE = destination                          ** V0.18
                  PUSH BC                   ;                                           ** V0.18
                  PUSH DE                   ; remember new cursor position              ** V0.18
                  LD   B,0                  ;                                           ** V0.18
                  LD   C,A                  ; no. of chars to move...                   ** V0.18
                  LDIR                      ; move chars 1 byte to the left...          ** V0.18
                  DEC  HL                   ;                                           ** V0.18
                  LD   (HL),0               ; null-terminate new end                    ** V0.18
                  LD   A,8                  ;                                           ** V0.18
                  CALL Display_Char         ; execute BACKSPACE                         ** V0.18
                  CALL Get_CurPos           ; BC = current cursor pos. in window        ** V0.18
                  POP  HL                   ; HL = abs. ptr. to cursor pos. in  buffer  ** V0.18
                  PUSH HL                   ; remember cur. ptr. in buffer              ** V0.18
                  CALL Display_String       ; write string from cursor to last char     ** V0.18
                  LD   A,32                 ; and display a space at the end            ** V0.18
                  CALL Display_Char         ;                                           ** V0.18
                  CALL Set_CurPos           ; put cursor back at (C,B)                  ** V0.18
                  POP  HL                   ;                                           ** V0.18
                  POP  BC                   ; restore C = rel. ptr. to last char...     ** V0.18
                  DEC  C                    ; ptr. to last char also one less           ** V0.18
                  DEC  B                    ;                                           ** V0.18
                  POP  DE                   ;                                           ** V0.18
                  JP   input_loop

.del_last_char    DEC  C                    ;                                           ** V0.18
                  DEC  B                    ;                                           ** V0.18
                  DEC  HL
                  LD   (HL),0               ; null-terminate current position
                  PUSH HL
                  LD   HL,delete_string
                  CALL Display_String
                  POP  HL
                  JP   input_loop
.delete_string    DEFM 8 & 32 & 8 & 0

.shft_delete_key  LD   A,B                  ; fetch relative pointer                    ** V0.27d
                  CP   C                    ; at last char or somewhere in the middle?  ** V0.27d
                  JP   Z, input_loop        ; nothing to delete...                      ** V0.27d
                  LD   A,C                  ;                                           ** V0.27d
                  SUB  B                    ; A = no. of char to move...                ** V0.27d
                  PUSH DE                   ;                                           ** V0.27d
                  LD   D,H                  ;                                           ** V0.27d
                  LD   E,L                  ; DE = destination                          ** V0.27d
                  INC  HL                   ; HL = source                               ** V0.27d
                  PUSH BC                   ;                                           ** V0.27d
                  PUSH DE                   ; remember new cursor position              ** V0.27d
                  LD   B,0                  ;                                           ** V0.27d
                  LD   C,A                  ; no. of chars to move...                   ** V0.27d
                  LDIR                      ; move chars 1 byte to the left...          ** V0.27d
                  CALL Get_CurPos           ; BC = current cursor pos. in window        ** V0.27d
                  POP  HL                   ; HL = abs. ptr. to cursor pos. in  buffer  ** V0.27d
                  PUSH HL                   ; remember cur. ptr. in buffer              ** V0.27d
                  CALL Display_String       ; write string from cursor to last char     ** V0.27d
                  LD   A,32                 ; and display a space at the end            ** V0.27d
                  CALL Display_Char         ;                                           ** V0.27d
                  CALL Set_CurPos           ; put cursor back at (C,B)                  ** V0.27d
                  POP  HL                   ;                                           ** V0.27d
                  POP  BC                   ; restore C = rel. ptr. to last char...     ** V0.27d
                  DEC  C                    ; ptr. to last char also one less           ** V0.27d
                  POP  DE                   ;                                           ** V0.27d
                  JP   input_loop           ;                                           ** V0.27d

.get_prev_line    PUSH BC
                  EX   AF,AF'               ;                                           ** V0.19c
                  LD   B,A                  ; don't destroy key press                   ** V0.19c
                  EX   AF,AF'               ;                                           ** V0.19c
                  LD   C,A                  ; original key press in C                   ** V0.19c
                  LD   A,B                  ; get flag
                  OR   A                    ; anything in buffer?   (A' <> 0)           ** V0.19c
                  LD   A,C                  ; restore key press                         ** V0.19c
                  POP  BC                   ;                                           ** V0.19c
                  JR   NZ, recall_line      ; Yes...                                    ** V0.20
                  LD   (HL),0               ; null-terminate start of buffer            ** V0.20
                  JP   input_loop           ; then let user input...                    ** V0.20
.recall_line      CALL Display_String       ; display contents                          ** V0.19c
                  PUSH HL                   ;                                           ** V0.19c
                  CP   A                    ;                                           ** V0.19c
                  SBC  HL,DE                ; calc. rel. ptrs from start of buffer      ** V0.19c
                  DEC  L                    ;                                           ** V0.19c
                  LD   B,L                  ;                                           ** V0.19c
                  LD   C,L                  ; rel. pointers set up                      ** V0.19c
                  POP  HL                   ;                                           ** V0.19c
                  JP   input_loop           ;                                           ** V0.19c


; *****************************************************************************************
;
; Select Z88-Monitor window 1 or 2.  (toggle)           V0.18 / V0.22b
;
.inp_togglewindow CALL ToggleWindow         ; display Intuition window...               ** V0.22/V0.28
.check_input      LD   A,C                  ; get length of input string
                  CP   0
                  JR   Z, disp_prompt       ; nothing typed in...
                  CALL DisplayPrompt        ; Yes,
                  LD   H,D
                  LD   L,E
                  INC  HL                   ; display prompt and
                  JR   recall_line          ; ...

.disp_prompt      CALL DisplayPrompt
                  JP   input_loop


; **********************************************************************************
;
; Clear (CLS) current Z88-Monitor window    V0.22b
;
.Clear_window     LD   A,12
                  CALL Display_Char         ; clear window
                  JR   check_input          ; and recall input line, if any...


; ***********************************************************************************
;
; Display Intuition input prompt                                                        ** V0.19c
;
.DisplayPrompt    PUSH HL
                  LD   HL, Prompt
                  CALL Display_String
                  POP  HL
                  RET
.Prompt           DEFM 1 & "B?>" & 1 & "B" & 0


; *************************************************************************************
;
; Get cursor position in current window     V0.18
;
; OUT:
;         C,B  =  (X,Y)
;
; Register status after return:
;
;       AF...EHL/..IY  same
;       ..BCD.../IX..  different
;
.Get_CurPos       PUSH AF
                  PUSH DE
                  PUSH HL
                  LD   A,0                  ; get cursor information from cur. window   ** V0.18
                  LD   BC, Nq_Wcur          ;                                           ** V0.18
                  CALL Save_alternate
                  CALL_OZ(Os_Nq)            ; cursor at (C,B) in current window         ** V0.18
                  CALL Restore_Alternate
                  POP  HL
                  LD   A,D
                  POP  DE
                  LD   D,A
                  POP  AF
                  RET

