
    MODULE MemorySearch_command

if QDOS
	INCLUDE "defs_h"				   ;	assembly directives	& various	constants
	INCLUDE "#memory_def"
endif
if MSDOS | UNIX
	INCLUDE "defs.h"
	INCLUDE "#memory.def"
endif
if Z88
	INCLUDE "defs.h"
	INCLUDE "#memory.def"
endif

    XREF Input_Buffer
    XREF inp_msg, search_msg
    XREF Write_Msg
    XREF Syntax_error, Write_Err_Msg
    XREF Write_CRLF
    XREF SkipSpaces, GetChar
    XREF ConvHexByte
    XREF Mem_dump, AdjustAddress
    XREF Get_Constant
    XREF Save_alternate,	Restore_alternate
    XREF Get_addrparameters

    XDEF Mem_search
    XDEF Search_Memory



; *******************************************************************************************
;
; Input memory	address parameters
;
.Mem_search	   EXX
			   LD   L,(IY + VP_PC)
			   LD   H,(IY + VP_PC+1)
			   EXX
			   CALL Get_addrparameters
			   RET  C
			   JP   NZ, Search_Memory
			   CALL Save_alternate
    if SEGMENT3
			   LD   C, MS_S3
    endif
    if SEGMENT2
			   LD   C, MS_S2
    endif
			   CALL_OZ(Os_Mpb)
			   CALL Restore_alternate
			   PUSH BC					; preserve prev. binding	state
			   CALL Search_Memory
			   POP  BC
			   CALL_OZ(Os_Mpb)
			   RET


; ***********************************************************************
;
; Search memory facility.
;
; The user specifies a search	string, inputted either as binary hex
; values or as	an ASCII string (no	equal case search!). A ' symbol
; identifies an ASCII string,	default identifies HEX bytes.
;
; The user simply specifies the symbol followed by the	search string.
;
;
; The routine allocates 17 bytes on the	stack to input	& store the string.
;
; The search start search address and an optional	bank	number are installed
; in	DE' and HL'. BC' = HL' to test whether searching has wrapped to original
; search address.
;
; Registers affected on return:
;
; ......../...cde../..IY	same
; AFBCDEHL/afb...hl/IX..	different
;
.Search_memory	   LD   HL, inp_msg
			   CALL Write_Msg		    ; 'Input search string:'
			   LD   HL, $0000
			   ADD  HL,SP
			   LD   D,H
			   LD   E,L			    ; DE = current SP
			   LD   BC,-20
			   ADD  HL,BC			    ; HL = input buffer
			   LD   SP,HL			    ; new	SP Top of	stack installed
			   PUSH DE			    ; remember	old SP
			   LD   D,H			    ; remember	start of buffer
			   LD   E,L
			   INC  HL
			   LD   (HL),0			    ; initiate	search string to null		   ** V0.31
			   CALL Save_alternate	    ; preserve	search parameters			   ** V0.31
			   LD   A,20			    ; max. size of input					   ** V0.31
			   CALL Input_Buffer	    ; now	let the user input a search string
			   LD   C,A			    ;								   ** V0.31
			   CALL Restore_alternate    ;								   ** V0.31
			   CALL Write_CRLF		    ; execute a line feed after input...
								    ; DE = start of	buffer, HL ptr. to first	byte
			   CALL SkipSpaces		    ; ignore any leading	spaces
			   CALL GetChar
			   CP   39			    ; '
			   JR   Z, get_ascii_str
			   DEC  HL			    ;								   ** V0.27d
			   JR   get_hex_str		    ;								   ** V0.27d

.get_ascii_str	   LD   D,H			    ; C =	lenght of	search string + 1
			   LD   E,L			    ; DE = start of	search string
			   DEC  C				    ; length of string excl. ' identifier
			   JR   search_string	    ; HL always points at start of	string

.get_hex_str	   LD   C,0			    ; counter of search string length
.get_hexstr_loop  CALL GetChar
			   OR   A				    ; an illegal hex byte or the null-terminator?
			   JR   Z, end_hexinput	    ; end	of line reached
			   DEC  HL			    ; let	subroutine read the	char...
			   CALL ConvHexByte		    ; get	a hex byte
			   JR   C, quit_hexinput
			   LD   (DE),A			    ; store hex byte into string
			   INC  DE
			   INC  C
			   JR   get_hexstr_loop	    ; get	next	hex byte until	null-terminator.

.end_hexinput	   LD   H,D
			   LD   L,E
			   LD   B,0
			   SBC  HL,BC			    ; HL = start of	search string
			   LD   D,H			    ; DE = start of	search string
			   LD   E,L			    ; HL always points at start of	string
			   INC  C
			   JR   search_string	    ; now	try to find string in memory...

.quit_hexinput	   LD   A, $01
			   CALL Write_Err_Msg	    ; 'Escape'
			   JR   quit_search


; begin search	in memory...
;
.search_string	   EXX
			   LD   B,H
			   LD   C,L			    ; BC = start search address
			   EXX
			   LD   B,0			    ; index counter	of match in string reset...
			   DEC  C				    ; length of search string	excl. null-terminator

.search_loop	   LD   A,B
			   CP   C				    ; whole string match	with	memory?
			   JR   Z, string_match	    ; Yes, search finished...
; search not finished,
; compare	string with memory...
			   LD   A,(DE)			    ; get	char	from	current string	search pointer
			   EXX				    ; use	alternate	set...
			   CP   (HL)			    ; does memory match with string byte?
			   INC  HL
			   EXX				    ; use	main	set.
			   CALL AdjustAddress	    ; get	ready for	next	memory fetch...
			   JR   Z, bytes_match	    ; Yes, byte equal, update	various pointers...
			   LD   B,0
			   LD   D,H			    ; No match, reset to	start of search string
			   LD   E,L			    ; reset pointers to start	of string
			   JR   search_address	    ; how	far has the search gone?

.bytes_match	   INC  B				    ; a match in the string was found,
			   INC  DE			    ; update string	pointers...

.search_address   EXX				    ; before next string	comparison, check
			   LD   A,H			    ; whether search address has reached
			   CP   B				    ; start search address
			   EXX
			   JR   NZ, search_loop	    ; addresses do not match,	continue searching...
			   EXX
			   LD   A,L			    ; high byte of addresses are equal!
			   CP   C				    ; now	test	low byte of addresses...
			   EXX
			   JR   NZ, search_loop	    ; addresses do not match,	continue searching...
			   LD   A, ERR_not_found
			   CALL Write_Err_Msg
			   JR   quit_search

.string_match	   LD   B,0
			   PUSH BC
			   EXX				    ; get	alternate	registers
			   POP  BC
			   SBC  HL,BC			    ; set	found address to start of string
			   EXX				    ; (C = length of string)
			   CALL AdjustAddress	    ; do bank wrap,	if necessary,
			   SET  Flg_EditMode,(IY	+ FlagStat1) ;	edit	mode	available...
			   CALL Mem_dump		    ; display a dump of the found string.

.quit_search	   POP  HL			    ; get	old stack	pointer
			   LD   SP,HL			    ; re-install
			   RET				    ; back to command line...

.inp_msg		   DEFM "String:" &	0
