module z80

org $4000

	INCLUDE "#stdio.def"
	INCLUDE "#fileio.def"
	INCLUDE "#director.def"
	INCLUDE "#syspar.def"
	INCLUDE "#saverst.def"
	INCLUDE "#integer.def"
	INCLUDE "#error.def"
	INCLUDE "#memory.def"
	INCLUDE "#dor.def"
	INCLUDE "#fpp.def"
	INCLUDE "#serintfc.def"
	INCLUDE "#screen.def"
	INCLUDE "#time.def"
	INCLUDE "#char.def"
	INCLUDE "#map.def"
	INCLUDE "#alarm.def"
	INCLUDE "#filter.def"
	INCLUDE "#tokens.def"
	INCLUDE "#misc.def"
	INCLUDE "#interrpt.def"
	
	NOP
	LD   BC,$0000
	LD   (BC),A
	INC  BC
	INC  B
	DEC  B
	LD   B,0
	RLCA
	EX   AF,AF'
	ADD  HL,BC
	LD   A,(BC)
	DEC  BC
	INC  C
	DEC  C
	LD   C,0
	RRCA
	.reljump
	DJNZ reljump
	LD   DE,$0000
	LD   (DE),A
	INC  DE
	INC  D
	DEC  D
	LD   D,0
	RLA
	JR   reljump
	ADD  HL,DE
	LD   A,(DE)
	DEC  DE
	INC  E
	DEC  E
	LD   E,FDh
	RRA
	JR   NZ, reljump
	LD   HL,$0000
	LD   ($0000),HL
	INC  HL
	INC  H
	DEC  H
	LD   H,0
	DAA
	JR   Z, reljump
	ADD  HL,HL
	LD   HL,($0000)
	DEC  HL
	INC  L
	DEC  L
	LD   L,0
	CPL
	JR   NC, reljump
	LD   SP,$0000
	LD   ($0000),A
	INC  SP
	INC  (HL)
	DEC  (HL)
	LD   (HL),0
	SCF
	JR   C, reljump
	ADD  HL,SP
	LD   A,($0000)
	DEC  SP
	INC  A
	DEC  A
	LD   A,0
	CCF
	LD   B,B
	LD   B,C
	LD   B,D
	LD   B,E
	LD   B,H
	LD   B,L
	LD   B,(HL)
	LD   B,A
	LD   C,B
	LD   C,C
	LD   C,D
	LD   C,E
	LD   C,H
	LD   C,L
	LD   C,(HL)
	LD   C,A
	LD   D,B
	LD   D,C
	LD   D,D
	LD   D,E
	LD   D,H
	LD   D,L
	LD   D,(HL)
	LD   D,A
	LD   E,B
	LD   E,C
	LD   E,D
	LD   E,E
	LD   E,H
	LD   E,L
	LD   E,(HL)
	LD   E,A
	LD   H,B
	LD   H,C
	LD   H,D
	LD   H,E
	LD   H,H
	LD   H,L
	LD   H,(HL)
	LD   H,A
	LD   L,B
	LD   L,C
	LD   L,D
	LD   L,E
	LD   L,H
	LD   L,L
	LD   L,(HL)
	LD   L,A
	LD   (HL),B
	LD   (HL),C
	LD   (HL),D
	LD   (HL),E
	LD   (HL),H
	LD   (HL),L
	HALT
	LD   (HL),A
	LD   A,B
	LD   A,C
	LD   A,D
	LD   A,E
	LD   A,H
	LD   A,L
	LD   A,(HL)
	LD   A,A
	ADD  A,B
	ADD  A,C
	ADD  A,D
	ADD  A,E
	ADD  A,H
	ADD  A,L
	ADD  A,(HL)
	ADD  A,A
	ADC  A,B
	ADC  A,C
	ADC  A,D
	ADC  A,E
	ADC  A,H
	ADC  A,L
	ADC  A,(HL)
	ADC  A,A
	SUB  B
	SUB  C
	SUB  D
	SUB  E
	SUB  H
	SUB  L
	SUB  (HL)
	SUB  A
	SBC  A,B
	SBC  A,C
	SBC  A,D
	SBC  A,E
	SBC  A,H
	SBC  A,L
	SBC  A,(HL)
	SBC  A,A
	AND  B
	AND  C
	AND  D
	AND  E
	AND  H
	AND  L
	AND  (HL)
	AND  A
	XOR  B
	XOR  C
	XOR  D
	XOR  E
	XOR  H
	XOR  L
	XOR  (HL)
	XOR  A
	OR   B
	OR   C
	OR   D
	OR   E
	OR   H
	OR   L
	OR   (HL)
	OR   A
	CP   B
	CP   C
	CP   D
	CP   E
	CP   H
	CP   L
	CP   (HL)
	CP   A
	RET  NZ
	POP  BC
	JP   NZ,$0000
	JP   $0000
	CALL NZ,$0000
	PUSH BC
	ADD  A,0
	RST  0
	RET  Z
	RET
	JP   Z,$0000
	RLC  B
	RLC  C
	RLC  D
	RLC  E
	RLC  H
	RLC  L
	RLC  (HL)
	RLC  A
	RRC  B
	RRC  C
	RRC  D
	RRC  E
	RRC  H
	RRC  L
	RRC  (HL)
	RRC  A
	RL   B
	RL   C
	RL   D
	RL   E
	RL   H
	RL   L
	RL   (HL)
	RL   A
	RR   B
	RR   C
	RR   D
	RR   E
	RR   H
	RR   L
	RR   (HL)
	RR   A
	SLA  B
	SLA  C
	SLA  D
	SLA  E
	SLA  H
	SLA  L
	SLA  (HL)
	SLA  A
	SRA  B
	SRA  C
	SRA  D
	SRA  E
	SRA  H
	SRA  L
	SRA  (HL)
	SRA  A
	SRL  B
	SRL  C
	SRL  D
	SRL  E
	SRL  H
	SRL  L
	SRL  (HL)
	SRL  A
	BIT  0,B
	BIT  0,C
	BIT  0,D
	BIT  0,E
	BIT  0,H
	BIT  0,L
	BIT  0,(HL)
	BIT  0,A
	BIT  1,B
	BIT  1,C
	BIT  1,D
	BIT  1,E
	BIT  1,H
	BIT  1,L
	BIT  1,(HL)
	BIT  1,A
	BIT  2,B
	BIT  2,C
	BIT  2,D
	BIT  2,E
	BIT  2,H
	BIT  2,L
	BIT  2,(HL)
	BIT  2,A
	BIT  3,B
	BIT  3,C
	BIT  3,D
	BIT  3,E
	BIT  3,H
	BIT  3,L
	BIT  3,(HL)
	BIT  3,A
	BIT  4,B
	BIT  4,C
	BIT  4,D
	BIT  4,E
	BIT  4,H
	BIT  4,L
	BIT  4,(HL)
	BIT  4,A
	BIT  5,B
	BIT  5,C
	BIT  5,D
	BIT  5,E
	BIT  5,H
	BIT  5,L
	BIT  5,(HL)
	BIT  5,A
	BIT  6,B
	BIT  6,C
	BIT  6,D
	BIT  6,E
	BIT  6,H
	BIT  6,L
	BIT  6,(HL)
	BIT  6,A
	BIT  7,B
	BIT  7,C
	BIT  7,D
	BIT  7,E
	BIT  7,H
	BIT  7,L
	BIT  7,(HL)
	BIT  7,A
	RES  0,B
	RES  0,C
	RES  0,D
	RES  0,E
	RES  0,H
	RES  0,L
	RES  0,(HL)
	RES  0,A
	RES  1,B
	RES  1,C
	RES  1,D
	RES  1,E
	RES  1,H
	RES  1,L
	RES  1,(HL)
	RES  1,A
	RES  2,B
	RES  2,C
	RES  2,D
	RES  2,E
	RES  2,H
	RES  2,L
	RES  2,(HL)
	RES  2,A
	RES  3,B
	RES  3,C
	RES  3,D
	RES  3,E
	RES  3,H
	RES  3,L
	RES  3,(HL)
	RES  3,A
	RES  4,B
	RES  4,C
	RES  4,D
	RES  4,E
	RES  4,H
	RES  4,L
	RES  4,(HL)
	RES  4,A
	RES  5,B
	RES  5,C
	RES  5,D
	RES  5,E
	RES  5,H
	RES  5,L
	RES  5,(HL)
	RES  5,A
	RES  6,B
	RES  6,C
	RES  6,D
	RES  6,E
	RES  6,H
	RES  6,L
	RES  6,(HL)
	RES  6,A
	RES  7,B
	RES  7,C
	RES  7,D
	RES  7,E
	RES  7,H
	RES  7,L
	RES  7,(HL)
	RES  7,A
	SET  0,B
	SET  0,C
	SET  0,D
	SET  0,E
	SET  0,H
	SET  0,L
	SET  0,(HL)
	SET  0,A
	SET  1,B
	SET  1,C
	SET  1,D
	SET  1,E
	SET  1,H
	SET  1,L
	SET  1,(HL)
	SET  1,A
	SET  2,B
	SET  2,C
	SET  2,D
	SET  2,E
	SET  2,H
	SET  2,L
	SET  2,(HL)
	SET  2,A
	SET  3,B
	SET  3,C
	SET  3,D
	SET  3,E
	SET  3,H
	SET  3,L
	SET  3,(HL)
	SET  3,A
	SET  4,B
	SET  4,C
	SET  4,D
	SET  4,E
	SET  4,H
	SET  4,L
	SET  4,(HL)
	SET  4,A
	SET  5,B
	SET  5,C
	SET  5,D
	SET  5,E
	SET  5,H
	SET  5,L
	SET  5,(HL)
	SET  5,A
	SET  6,B
	SET  6,C
	SET  6,D
	SET  6,E
	SET  6,H
	SET  6,L
	SET  6,(HL)
	SET  6,A
	SET  7,B
	SET  7,C
	SET  7,D
	SET  7,E
	SET  7,H
	SET  7,L
	SET  7,(HL)
	SET  7,A
	CALL Z,$0000
	CALL $0000
	ADC  A,0
	RST  08h
	RET  NC
	POP  DE
	JP   NC,$0000
	OUT  (0),A
	CALL NC,$0000
	PUSH DE
	SUB  0
	RST  10h
	EXX
	JP   C,$0000
	IN   A,(0)
	CALL C,$0000
	ADD  IX,BC
	ADD  IX,DE
	LD   IX,$0000
	LD   ($0000),IX
	INC  IX
	ADD  IX,IX
	LD   IX,($0000)
	DEC  IX
	INC  (IX+0)
	DEC  (IX+0)
	LD   (IX+0),01h
	ADD  IX,SP
	LD   B,(IX+0)
	LD   C,(IX+0)
	LD   D,(IX+0)
	LD   E,(IX+0)
	LD   H,(IX+0)
	LD   L,(IX+0)
	LD   (IX+0),B
	LD   (IX+0),C
	LD   (IX+0),D
	LD   (IX+0),E
	LD   (IX+0),H
	LD   (IX+0),L
	LD   (IX+0),A
	LD   A,(IX+0)
	ADD  A,(IX+0)
	ADC  A,(IX+0)
	SUB  (IX+0)
	SBC  A,(IX+0)
	AND  (IX+0)
	XOR  (IX+0)
	OR   (IX+0)
	CP   (IX+0)
	RLC  (IX+0)
	RRC  (IX+0)
	RL   (IX+0)
	RR   (IX+0)
	SLA  (IX+0)
	SRA  (IX+0)
	SRL  (IX+0)
	BIT  0,(IX+0)
	BIT  1,(IX+0)
	BIT  2,(IX+0)
	BIT  3,(IX+0)
	BIT  4,(IX+0)
	BIT  5,(IX+0)
	BIT  6,(IX+0)
	BIT  7,(IX+0)
	RES  0,(IX+0)
	RES  1,(IX+0)
	RES  2,(IX+0)
	RES  3,(IX+0)
	RES  4,(IX+0)
	RES  5,(IX+0)
	RES  6,(IX+0)
	RES  7,(IX+0)
	SET  0,(IX+0)
	SET  1,(IX+0)
	SET  2,(IX+0)
	SET  3,(IX+0)
	SET  4,(IX+0)
	SET  5,(IX+0)
	SET  6,(IX+0)
	SET  7,(IX+0)
	POP  IX
	EX   (SP),IX
	PUSH IX
	JP   (IX)
	LD   SP,IX
	SBC  A,0
	RST  $18
	FPP(FP_AND)
	FPP(FP_IDV)
	FPP(FP_EOR)
	FPP(FP_MOD)
	FPP(FP_OR)
	FPP(FP_LEQ)
	FPP(FP_NEQ)
	FPP(FP_GEQ)
	FPP(FP_LT)
	FPP(FP_EQ)
	FPP(FP_MUL)
	FPP(FP_ADD)
	FPP(FP_GT)
	FPP(FP_SUB)
	FPP(FP_PWR)
	FPP(FP_DIV)
	FPP(FP_ABS)
	FPP(FP_ACS)
	FPP(FP_ASN)
	FPP(FP_ATN)
	FPP(FP_COS)
	FPP(FP_DEG)
	FPP(FP_EXP)
	FPP(FP_INT)
	FPP(FP_LN)
	FPP(FP_LOG)
	FPP(FP_NOT)
	FPP(FP_RAD)
	FPP(FP_SGN)
	FPP(FP_SIN)
	FPP(FP_SQR)
	FPP(FP_TAN)
	FPP(FP_ZER)
	FPP(FP_ONE)
	FPP(FP_TRU)
	FPP(FP_PI)
	FPP(FP_VAL)
	FPP(FP_STR)
	FPP(FP_FIX)
	FPP(FP_FLT)
	FPP(FP_TST)
	FPP(FP_CMP)
	FPP(FP_NEG)
	FPP(FP_BAS)
	RET  PO
	POP  HL
	JP   PO,$0000
	EX   (SP),HL
	CALL PO,$0000
	PUSH HL
	AND  0
	RST  $20
	CALL_OZ(OS_WRT)
	CALL_OZ(OS_WTB)
	CALL_OZ(OS_ISQ)
	CALL_OZ(OS_AXP)
	CALL_OZ(OS_SCI)
	CALL_OZ(OS_DLY)
	CALL_OZ(OS_BLP)
	CALL_OZ(OS_BDE)
	CALL_OZ(OS_BHL)
	CALL_OZ(OS_FTH)
	CALL_OZ(OS_VTH)
	CALL_OZ(OS_GTH)
	CALL_OZ(OS_REN)
	CALL_OZ(OS_DEL)
	CALL_OZ(OS_CL)
	CALL_OZ(OS_OP)
	CALL_OZ(OS_OFF)
	CALL_OZ(OS_USE)
	CALL_OZ(OS_EPR)
	CALL_OZ(OS_HT)
	CALL_OZ(OS_MAP)
	CALL_OZ(OS_EXIT)
	CALL_OZ(OS_STK)
	CALL_OZ(OS_ENT)
	CALL_OZ(OS_POLL)
	CALL_OZ(OS_DOM)
	CALL_OZ(GN_GDT)
	CALL_OZ(GN_PDT)
	CALL_OZ(GN_GTM)
	CALL_OZ(GN_PTM)
	CALL_OZ(GN_SDO)
	CALL_OZ(GN_GDN)
	CALL_OZ(GN_PDN)
	CALL_OZ(GN_DIE)
	CALL_OZ(GN_DEI)
	CALL_OZ(GN_GMD)
	CALL_OZ(GN_GMT)
	CALL_OZ(GN_PMD)
	CALL_OZ(GN_PMT)
	CALL_OZ(GN_MSC)
	CALL_OZ(GN_FLO)
	CALL_OZ(GN_FLC)
	CALL_OZ(GN_FLW)
	CALL_OZ(GN_FLR)
	CALL_OZ(GN_FLF)
	CALL_OZ(GN_FPB)
	CALL_OZ(GN_NLN)
	CALL_OZ(GN_CLS)
	CALL_OZ(GN_SKC)
	CALL_OZ(GN_SKD)
	CALL_OZ(GN_SKT)
	CALL_OZ(GN_SIP)
	CALL_OZ(GN_SOP)
	CALL_OZ(GN_SOE)
	CALL_OZ(GN_RBE)
	CALL_OZ(GN_WBE)
	CALL_OZ(GN_CME)
	CALL_OZ(GN_XNX)
	CALL_OZ(GN_XIN)
	CALL_OZ(GN_XDL)
	CALL_OZ(GN_ERR)
	CALL_OZ(GN_ESP)
	CALL_OZ(GN_FCM)
	CALL_OZ(GN_FEX)
	CALL_OZ(GN_OPW)
	CALL_OZ(GN_WCL)
	CALL_OZ(GN_WFN)
	CALL_OZ(GN_PRS)
	CALL_OZ(GN_PFS)
	CALL_OZ(GN_WSM)
	CALL_OZ(GN_ESA)
	CALL_OZ(GN_OPF)
	CALL_OZ(GN_CL)
	CALL_OZ(GN_DEL)
	CALL_OZ(GN_REN)
	CALL_OZ(GN_AAB)
	CALL_OZ(GN_FAB)
	CALL_OZ(GN_LAB)
	CALL_OZ(GN_UAB)
	CALL_OZ(GN_ALP)
	CALL_OZ(GN_M16)
	CALL_OZ(GN_D16)
	CALL_OZ(GN_M24)
	CALL_OZ(GN_D24)
	CALL_OZ(DC_INI)
	CALL_OZ(DC_BYE)
	CALL_OZ(DC_ENT)
	CALL_OZ(DC_NAM)
	CALL_OZ(DC_IN)
	CALL_OZ(DC_OUT)
	CALL_OZ(DC_PRT)
	CALL_OZ(DC_ICL)
	CALL_OZ(DC_NQ)
	CALL_OZ(DC_SP)
	CALL_OZ(DC_ALT)
	CALL_OZ(DC_RBD)
	CALL_OZ(DC_XIN)
	CALL_OZ(DC_GEN)
	CALL_OZ(DC_POL)
	CALL_OZ(DC_SCN)
	CALL_OZ(OS_BYE)
	CALL_OZ(OS_PRT)
	CALL_OZ(OS_OUT)
	CALL_OZ(OS_IN)
	CALL_OZ(OS_TIN)
	CALL_OZ(OS_XIN)
	CALL_OZ(OS_PUR)
	CALL_OZ(OS_UGB)
	CALL_OZ(OS_GB)
	CALL_OZ(OS_PB)
	CALL_OZ(OS_GBT)
	CALL_OZ(OS_PBT)
	CALL_OZ(OS_MV)
	CALL_OZ(OS_FRM)
	CALL_OZ(OS_FWM)
	CALL_OZ(OS_MOP)
	CALL_OZ(OS_MCL)
	CALL_OZ(OS_MAL)
	CALL_OZ(OS_MFR)
	CALL_OZ(OS_MGB)
	CALL_OZ(OS_MPB)
	CALL_OZ(OS_BIX)
	CALL_OZ(OS_BOX)
	CALL_OZ(OS_NQ)
	CALL_OZ(OS_SP)
	CALL_OZ(OS_SR)
	CALL_OZ(OS_ESC)
	CALL_OZ(OS_ERC)
	CALL_OZ(OS_ERH)
	CALL_OZ(OS_UST)
	CALL_OZ(OS_FN)
	CALL_OZ(OS_WAIT)
	CALL_OZ(OS_ALM)
	CALL_OZ(OS_CLI)
	CALL_OZ(OS_DOR)
	CALL_OZ(OS_FC)
	CALL_OZ(OS_SI)
	RET  PE
	JP   (HL)
	JP   PE,$0000
	EX   DE,HL
	CALL PE,$0000
	IN   B,(C)
	OUT  (C),B
	SBC  HL,BC
	LD   ($0000),BC
	NEG
	RETN
	IM   0
	LD   I,A
	IN   C,(C)
	OUT  (C),C
	ADC  HL,BC
	LD   BC,($0000)
	RETI
	LD   R,A
	IN   D,(C)
	OUT  (C),D
	SBC  HL,DE
	LD   ($0000),DE
	IM   1
	LD   A,I
	IN   E,(C)
	OUT  (C),E
	ADC  HL,DE
	LD   DE,($0000)
	IM   2
	LD   A,R
	IN   H,(C)
	OUT  (C),H
	SBC  HL,HL
	LD   ($0000),HL
	RRD
	IN   L,(C)
	OUT  (C),L
	ADC  HL,HL
	LD   HL,($0000)
	RLD
	SBC  HL,SP
	LD   ($0000),SP
	IN   A,(C)
	OUT  (C),A
	ADC  HL,SP
	LD   SP,($0000)
	LDI
	CPI
	INI
	OUTI
	LDD
	CPD
	IND
	OUTD
	LDIR
	CPIR
	INIR
	OTIR
	LDDR
	CPDR
	INDR
	OTDR
	XOR  0
	RST  28h
	RET  P
	POP  AF
	JP   P,$0000
	DI
	CALL P,$0000
	PUSH AF
	OR   0
	RST  30h
	RET  M
	LD   SP,HL
	JP   M,$0000
	EI
	CALL M,$0000
	ADD  IY,BC
	ADD  IY,DE
	LD   IY,$0000
	LD   ($0000),IY
	INC  IY
	ADD  IY,IY
	LD   IY,($0000)
	DEC  IY
	INC  (IY+0)
	DEC  (IY+0)
	LD   (IY+0),01h
	ADD  IY,SP
	LD   B,(IY+0)
	LD   C,(IY+0)
	LD   D,(IY+0)
	LD   E,(IY+0)
	LD   H,(IY+0)
	LD   L,(IY+0)
	LD   (IY+0),B
	LD   (IY+0),C
	LD   (IY+0),D
	LD   (IY+0),E
	LD   (IY+0),H
	LD   (IY+0),L
	LD   (IY+0),A
	LD   A,(IY+0)
	ADD  A,(IY+0)
	ADC  A,(IY+0)
	SUB  (IY+0)
	SBC  A,(IY+0)
	AND  (IY+0)
	XOR  (IY+0)
	OR   (IY+0)
	CP   (IY+0)
	RLC  (IY+0)
	RRC  (IY+0)
	RL   (IY+0)
	RR   (IY+0)
	SLA  (IY+0)
	SRA  (IY+0)
	SRL  (IY+0)
	BIT  0,(IY+0)
	BIT  1,(IY+0)
	BIT  2,(IY+0)
	BIT  3,(IY+0)
	BIT  4,(IY+0)
	BIT  5,(IY+0)
	BIT  6,(IY+0)
	BIT  7,(IY+0)
	RES  0,(IY+0)
	RES  1,(IY+0)
	RES  2,(IY+0)
	RES  3,(IY+0)
	RES  4,(IY+0)
	RES  5,(IY+0)
	RES  6,(IY+0)
	RES  7,(IY+0)
	SET  0,(IY+0)
	SET  1,(IY+0)
	SET  2,(IY+0)
	SET  3,(IY+0)
	SET  4,(IY+0)
	SET  5,(IY+0)
	SET  6,(IY+0)
	SET  7,(IY+0)
	POP  IY
	EX   (SP),IY
	PUSH IY
	JP   (IY)
	LD   SP,IY
	CP   0
	RST  38h
