
;	 ZZZZZZZZZZZZZZZZZZZZ	8888888888888		00000000000
;   ZZZZZZZZZZZZZZZZZZZZ	   88888888888888888    0000000000000
;			  ZZZZZ	   888		  888  0000		0000
;			ZZZZZ	   88888888888888888  0000		0000
;		   ZZZZZ			8888888888888	  0000		0000		 AAAAAA		 SSSSSSSSSSS	MMMM		 MMMM
;		 ZZZZZ		   88888888888888888  0000		0000		AAAAAAAA	    SSSS			MMMMMM   MMMMMM
;	    ZZZZZ			   8888		 8888  0000		0000	    AAAA	AAAA	    SSSSSSSSSSS	MMMMMMMMMMMMMMM
;	  ZZZZZ			   8888		 8888  0000		0000	   AAAAAAAAAAAA	 SSSSSSSSSSS	MMMM	MMMMM MMMM
;	ZZZZZZZZZZZZZZZZZZZZZ  88888888888888888    0000000000000	  AAAA	  AAAA		  SSSSS	MMMM		 MMMM
;  ZZZZZZZZZZZZZZZZZZZZZ		8888888888888		00000000000	 AAAA	   AAAA  SSSSSSSSSSS	MMMM		 MMMM
;
; Copyright (C) Gunther Strube, InterLogic 1995

	MODULE Error_handler

	LIB Release_pools

	XREF	Z80asm_windows, Display_status				; windows_asm

	XREF	Close_files								; fileio_asm
	XREF	Delete_bufferfiles							;

	XDEF	Z80asm_ERH

if QDOS
	INCLUDE "defs_h"
	INCLUDE "symbol_def"
	INCLUDE "#director_def"
	INCLUDE "#error_def"
else
	INCLUDE "defs.h"
	INCLUDE "symbol.def"
	if MSDOS | UNIX
		INCLUDE "#error.def"
		INCLUDE "#director.def"
	endif
	if Z88
		INCLUDE ":*//director.def"
		INCLUDE ":*//error.def"
	endif
endif


; ******************************************************************************************
;
; Z80asm error	handler
;
.Z80asm_ERH		CP	RC_SUSP
				RET	Z
				CP	RC_DRAW					 ; application	screen corrupted
				JR	Z,corrupt_scr
				CP	RC_QUIT
				JR	Z,Zprom_suicide
				CP	RC_ESC
				JR	Z, ackn_esc
				JR	return_ERH

.corrupt_scr		PUSH	BC
				PUSH	DE
				PUSH	HL
				PUSH	IX
				CALL	Z80asm_windows				 ; redraw	screen before suspension
				CALL	Display_status
				POP	IX
				POP	HL
				POP	DE
				POP	BC
				LD	A,-1
				JR	return_ERH

.ackn_esc			CALL_OZ(Os_Esc)				 ; acknowledge	ESC key
				LD	A, $1B					 ; ESC were pressed
.return_ERH		OR	A						 ; Fc = 0, Fz = 0
				RET

.Zprom_suicide		CALL	Close_files				 ; close any open files...
				CALL	Delete_bufferfiles
				CALL	Release_pools				 ; free any open memory pools	back	to OZ...
				XOR	A
				CALL_OZ(Os_Bye)				 ; kill Zprom and return	to Index
