; ******************************************************************************************
;
; Get pointer to variable in HL
;
; IN: DE = rel. pointer to variable
;
; Register status on return:
;
; AFBCDE../IXIY/afbcdehl  same
; ......HL/..../........  different
;
.GetVarPtr          PUSH AF
                    PUSH IY
                    POP  HL
                    ADD  HL,DE
                    POP  AF
                    RET


; ******************************************************************************************
;
; Get contents of variable in DE
;
; IN: DE = rel. pointer to variable
;
; Register status on return:
;
; AFBC..HL/IXIY/afbcdehl  same
; ....DE../..../........  different
;
.GetVar             PUSH AF
                    PUSH HL
                    PUSH IY
                    POP  HL
                    ADD  HL,DE
                    LD   E,(HL)
                    INC  HL
                    LD   D,(HL)
                    POP  HL
                    POP  AF
                    RET


; ******************************************************************************************
;
; Update contents of pointer to variable.
;
; IN: HL = contents
;     DE = rel. pointer to variable
;
; No registers changed on return
;
.StoreVar           PUSH DE
                    PUSH HL
                    PUSH HL
                    CALL GetVarPtr                      ; ptr to variable returned in HL
                    POP  DE                             ; pointer to subroutine
                    LD   (HL),E                         ; low byte of pointer
                    INC  HL                             ; then high byte
                    LD   (HL),D                         ; is updated with new window subroutine
                    POP  HL
                    POP  DE
                    RET

