/***************************************************************************
 *                       Bookmarks.h  -  description
 *                               -------------------
 *  begin                : Tue Sep 10 10:40:21 BST 2002
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qtextstream.h>
#include <qaction.h>
#include <qfile.h>
#include <qstring.h>
#include <qlistview.h>
#include <qmenubar.h>
#include <qpushbutton.h>
#include <qvbox.h>
#ifndef __FOR_QT__
#include <qpe/resource.h>
#include <qpe/global.h>
#endif

class MQListViewItem : public QListViewItem
{
    public:
	MQListViewItem( QListView* parent, QString bookmark,QString page, QString filePos, QString newparagraph);
        QString key( int column, bool ascending ) const;
};


class Bookmarks : public QWidget
{
    Q_OBJECT
    public:
	Bookmarks(QWidget *parent=0, const char *name=0);
	~Bookmarks();
	QString fontname;
	int filePos;
	bool newparagraph,itemChanged;
    public slots:
		void loadBookmarks(QString filename);
		void saveBookmarks(QString filename);
		void addBookmark(QString markname,int filePos,int page,bool newparagraph);
		void deleteSelected();
    private slots:
		void resizeEvent(QResizeEvent *);
		void showEvent(QShowEvent *);
		void BookmarkSelected(QListViewItem *item);
		void currentItemChanged(QListViewItem *item);
    protected slots:
    signals:
		void BookmarkSignal();
    private:
		QListView *bookmarkslistview;
		QVBox *boxAll;
};

