/***************************************************************************
 *                       IntDict.h  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qstring.h>
#include <qregexp.h>
#include "dictionary.h"

class IntDict;

class IntDict
{
    private:
	QString dictName;
	Dictionary *dict;
	QString word,translatedWord,meaning,error,info,sense,headWord,partOfSpeech,pron;
	int ndef;
	bool ret,subword;
	QString dictFormat(const QString&, const QString&);
	int dictProcessBody(const QString&, int, QString&, QString&);
    public:
	IntDict();
	~IntDict();
	QString getDictName();
	void setDictName(QString);
	void findWord(QString);
	void nextWord();
	void prevWord();
	QString getWord();
	QString getSense();
	QString getError();
	QString getInfo();
};

