/***************************************************************************
 *                       TextReader.h  -  description
 *                               -------------------
 *  begin                : Tue Sep 10 10:40:21 BST 2002
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qmainwindow.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qaction.h>
#ifndef __FOR_QT__
#include <qpe/menubutton.h>
#endif
#include <qpopupmenu.h>
#include <qtextstream.h>
#include <qaction.h>
#include <qpainter.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qfile.h>
#include <qstring.h>
#include <qdialog.h>
#include <qvbox.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include "Control.h"

class QAction;
class QActionGroup;
class QPopupMenu;
class QPainter;
class QPixmap;
class SettingsDlg;
class Bookmarks;

class GetFileName;

class TextReader : public QMainWindow
{
    Q_OBJECT
    public:
	TextReader(QMainWindow *parent=0, const char *name=0, WFlags f=WType_TopLevel);
	~TextReader();
	QString filename;
	Control *textview;
	Bookmarks *bookmarks;
	Bookmarks *contents;
	GetFileName *filedialog;
	SettingsDlg *settingsdlg;
	QAction *goBackAction;
    private slots:
	void closeEvent(QCloseEvent *);
    public slots:
	void fileOpen();
	void fileOpenedSlot();
	void fileNotOpenedSlot();

	void settings();
	void toggleFullScreenSlot();	
	void focusOutEvent(QFocusEvent *);
	void focusInEvent(QFocusEvent *);
	void loadSettings();
	void saveSettings();
	void keyPressEvent(QKeyEvent * e);
	void gotoMarkSlot();
	void addMarkSlot();
	void gotBookmark();
	void saveBookmarks();
	void closeBookmark();
	void generateContents();
	void gotoContentsSlot();
	void gotContents();
	void closeContents();
	void setupMenus();
	void setMainMenu();
	void setBookmarksMenu();
	void setContentsMenu();
	void setSettingsMenu();
	void setFileOpenMenu();
	void showToolbar();
	void hideToolbar();
	void closeSettings();
	void acceptSettings();
    private:
	QWidget * grabber;
	QPopupMenu *filemenu,*optionsmenu,*navigationmenu;
	QMenuBar *menubar;
	QToolBar *toolbar,*menutoolbar,*iconstoolbar;
	QAction  *openAction,*settingsAction,
		*addBookmarkAction,*gotoBookmarkAction,*closeBookmarksAction,*okBookmarksAction,*saveBookmarksAction,
		*contentsAction,*buildContentsAction,*closeContentsAction,*okContentsAction,
		*closeSettingsAction,*acceptSettingsAction,
		*closeFileOpenAction,*findAction;
	bool fullscreen;
	QString folderpath,fullfilename,basefilename;
	QPixmap IconScale(QString);
	QSize appSize;
};

