/***************************************************************************
 *                       Unzip.cpp  -  description
 *                               -------------------
 *  begin                : Tue Sep 10 10:40:21 BST 2002
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "Unzip.h"
#include "zlib.h"
#include <stdlib.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qdir.h>
// 2002-09-13, Psimon Ghim, Filename passed to unzOpen() of gzopen() must not be unicode.
#include <qapplication.h>
#include <qtextcodec.h>
#define LOCAL_ENCODED_STRING( unicode ) \
					( \
					( qApp->defaultCodec() != 0 ) ? \
					qApp->defaultCodec()->fromUnicode( unicode ) : \
					unicode \
					)

#define WRITEBUFFERSIZE (8192)
#define BUFLEN      16384

Unzip::Unzip(QString filename)
{
    fullfilename = filename;
}

bool Unzip::uncompress()
{
    QDir dir;    
    QString ext,newName;
    QFileInfo fileinfo;
    fileinfo.setFile(fullfilename);
    ext = fileinfo.extension(false);
    newName = fileinfo.fileName();
    newName.truncate(newName.length()-ext.length()-1);
    dir.mkdir("/tmp/justreader/");
    //uncompressed = "/tmp/justreader/"+fileinfo.baseName()+".txt";
    uncompressed = "/tmp/justreader/"+newName;
    fileinfo.setFile(uncompressed);
    if (fileinfo.exists())
    {
	return TRUE;
    }

    unzFile uf = NULL;
    int err;
    unz_global_info gi;
    unz_file_info file_info;
    char filename_inzip[256];
    uInt size_buf;
    void *buf;

    // 2002-09-13, Psimon Ghim, See #define LOCAL_ENCODED_STRING
    // uf = unzOpen(fullfilename);
    uf = unzOpen( LOCAL_ENCODED_STRING( fullfilename ) );
    if (uf==NULL)
    {
	return FALSE;
    }
    err = unzGetGlobalInfo (uf,&gi);
    if (err!=UNZ_OK)
    {
	//printf("error %d with zipfile in unzGetGlobalInfo \n",err);
	return FALSE;
    }
    err = unzGetCurrentFileInfo(uf,&file_info,filename_inzip,sizeof(filename_inzip),NULL,0,NULL,0);
    if (err!=UNZ_OK)
    {
	//printf("error %d with zipfile in unzGetCurrentFileInfo\n",err);
	return FALSE;
    }
    size_buf = WRITEBUFFERSIZE;
    buf = (void*)malloc(size_buf);
    if (buf==NULL)
    {
	//printf("Error allocating memory\n");
	return FALSE;
    }
    err = unzOpenCurrentFile(uf);
    if (err!=UNZ_OK)
    {
	//printf("error %d with zipfile in unzOpenCurrentFile\n",err);
	return FALSE;
    }
    FILE *fout=NULL;
    // // 2002-09-13, Psimon Ghim, See #define LOCAL_ENCODED_STRING
    // fout=fopen(uncompressed,"wb");
    fout=fopen( LOCAL_ENCODED_STRING( uncompressed ),"wb");
    do
    {
	err = unzReadCurrentFile(uf,buf,size_buf);
	if (err<0)
	{
	    //printf("error %d with zipfile in unzReadCurrentFile\n",err);
	    break;
	}
	if (err>0)
	{
	    if (fwrite(buf,err,1,fout)!=1)
	    {
		//printf("error in writing extracted file\n");
		err=UNZ_ERRNO;
		break;
	    }
	}
    } while (err>0);
    fclose(fout); 
    if (err==UNZ_OK)
    {
	err = unzCloseCurrentFile (uf);
	if (err!=UNZ_OK)
	{
	    //printf("error %d with zipfile in unzCloseCurrentFile\n",err);
	}
    } else {
	unzCloseCurrentFile(uf);
    }
    free(buf);
    if (err!=UNZ_OK) return FALSE;
    else return TRUE;
}

bool Unzip::ungzip()
{
    QDir dir;    
    QString ext,newName;
    QFileInfo fileinfo;
    fileinfo.setFile(fullfilename);
    ext = fileinfo.extension(false);
    newName = fileinfo.fileName();
    newName.truncate(newName.length()-ext.length()-1);
    if (ext.lower() == "gz") ext = "";
    dir.mkdir("/tmp/justreader/");
    //uncompressed = "/tmp/justreader/"+fileinfo.baseName()+"_tmp."+QFileInfo::QFileInfo(ext).baseName();
    uncompressed = "/tmp/justreader/"+newName;
    fileinfo.setFile(uncompressed);
    /*if (fileinfo.exists())
    {
	return true;
    }*/
    gzFile in;
    FILE *out;
    // 2002-09-13, Psimon Ghim, See #define LOCAL_ENCODED_STRING
    // in = gzopen(fullfilename, "rb");
    in = gzopen( LOCAL_ENCODED_STRING( fullfilename ), "rb");
    if (in == NULL)
    {
	//printf("gzopen error\n");
	return false;
    }
    // 2002-09-13, Psimon Ghim, See #define LOCAL_ENCODED_STRING
    // out = fopen(uncompressed, "wb");
    out = fopen( LOCAL_ENCODED_STRING( uncompressed ), "wb");
    if (out == NULL)
    {
	//printf("error opening file for writing\n");
	return false;
    }
    char buf[BUFLEN];
    int len;
    //int err;
    for (;;)
    {
	len = gzread(in, buf, sizeof(buf));
	if (len < 0)
	{
	    //error (gzerror(in, &err));
	    return false;
	}
	if (len == 0) break;
	if ((int)fwrite(buf, 1, (unsigned)len, out) != len)
	{
	    //error writing file
	    fclose(out);
	    return false;
	}
    }
    if (fclose(out))
    {
	return false;
    }
    if (gzclose(in) != Z_OK)
    {
	return false;
    }
    
    return true;

}
