.\" $XConsortium: xmessage.man,v 1.8 95/03/08 22:28:48 gildea Exp $
.\"
.\" $XFree86: xc/programs/xmessage/xmessage.man,v 1.4 2005/02/11 03:03:20 dawes Exp $
.\"
.TH XMESSAGE 1 __vendorversion__
.SH NAME
xmessage \- display a message or query in a window (X-based /bin/echo)
.SH SYNOPSIS
.B xmessage
[
.B \-buttons
.I label1\fR[\fP\fB:\fPvalue1\fR]\fP\fB,\fPlabel2\fR[\fP\fB:\fPvalue2\fR]\fP\fB,\fP
\&\|.\|.\|.
] [
.I options
]
.B \-file
.I filename
.br
.B xmessage
[
.B \-buttons
.I label1\fR[\fP\fB:\fPvalue1\fR]\fP\fB,\fPlabel2\fR[\fP\fB:\fPvalue2\fR]\fP\fB,\fP
\&\|.\|.\|.
] [
.I options
]
.I message
\&.\|.\|.
.SH DESCRIPTION
The 
.I xmessage
program
displays a window containing a message from the command line, a file,
or standard input.
Along the lower edge of the message is row
of buttons; clicking the left mouse button
on any of these buttons will cause \fIxmessage\fP to exit.
Which button was pressed is returned in the exit status and,
optionally, by writing the label of the button to standard output.
.PP
The program
is typically used by shell scripts to display information to the user
or to ask the user to make a choice.
.PP
Unless a size is specified, \fIxmessage\fP
sizes itself to fit the message, up to a maximum size.
If the message is too big for the window, \fIxmessage\fP will display
scroll bars.
.SH OPTIONS
These are the command line options that \fIxmessage\fP understands.
.TP 8
.B \-buttons \fIbutton,button,.\|.\|.\fP
This option will cause \fIxmessage\fP to create one button for each
comma-separated \fIbutton\fP argument.
The corresponding resource is \fBbuttons\fP.
Each \fIbutton\fP consists of a label optionally followed by a colon
and an exit value.
The label is the name of the Command button widget created and will be the 
default text displayed to the user.  Since this is the name of the widget
it may be used to change any of the resources associated with that button.
The exit value will be returned by \fIxmessage\fP
if that button is selected.  The default exit value is 100 plus the
button number.  Buttons are numbered from the left starting with one.
The default string if no \fB\-buttons\fP option is given is \fBokay:0\fP.
.TP 8
.B \-default \fIlabel\fP
Defines the button with a matching \fIlabel\fP to be the default.
If not specified there is no default.
The corresponding resource is \fBdefaultButton\fP.
Pressing Return anywhere in the \fIxmessage\fP window will activate
the default button.
The default button has a wider border than the others.
.TP 8
.B \-file \fIfilename\fP
File to display.
The corresponding resource is \fBfile\fP.
A \fIfilename\fP of `\fB\-\fP' reads from standard input.
If this option is not supplied, \fIxmessage\fP will
display all non-option arguments in the style of \fIecho\fP.
Either \fB\-file\fP or a message on the command line
should be provided, but not both.
.TP 8
.B \-print
This will cause the program to write the label of the button pressed to
standard output.  Equivalent to setting the \fBprintValue\fP resource
to TRUE.
This is one way to get feedback as to which button was pressed.
.TP 8
.B \-center
Pop up the window at the center of the screen.
Equivalent to setting the \fBcenter\fP resource to TRUE.
.TP 8
.B \-nearmouse
Pop up the window near the mouse cursor.
Equivalent to setting the \fBnearMouse\fP resource to TRUE.
.TP 8
.B \-timeout \fIsecs\fP
Exit with status 0 after \fIsecs\fP seconds if the user has not
clicked on a button yet.
The corresponding resource is \fBtimeout\fP.
.SH "WIDGET HIERARCHY"
Knowing the name and position in the hierarchy of each widget is
useful when specifying resources for them.  In the following chart, the
class and name of each widget is given.
.LP
.nf
Xmessage (xmessage)
	Form form
		Text message
		Command (label1)
		Command (label2)
		.
		.
		.
.fi
.SH RESOURCES
The program has a few top-level application resources that allow
customizations that are specific to \fIxmessage\fP. 
.TP 8
.B file
A String specifying the file to display.
.TP 8
.B buttons
A String specifying the buttons to display.
See the \fB\-buttons\fP command-line option.
.TP 8
.B defaultButton
A String specifying a default button by label.
.TP 8
.B printValue
A Boolean value specifying whether the label of the 
button pressed to exit the program is written to standard output.
The default is FALSE.
.TP 8
.B center
A Boolean value specifying whether to pop up the window at the center
of the screen.  The default is FALSE.
.TP 8
.B nearMouse
A Boolean value specifying whether to pop up the window near the mouse
cursor.  The default is FALSE.
.TP 8
.B timeout
The number of seconds after which to exit with
status 0.  The default is 0, which means never time out.
.TP 8
.B "maxHeight (\fPclass\fB Maximum)
The maximum height of the text part of the window in pixels,
used if no size was specified in the geometry.
The default is 0, which means use 70% of the height of the screen.
.TP 8
.B "maxWidth (\fPclass\fB Maximum)
The maximum width of the text part of the window in pixels,
used if no size was specified in the geometry.
The default is 0, which means use 70% of the width of the screen.
.SH ACTIONS
.TP 8
.B exit(\fIvalue\fP)
exit immediately with an exit status of \fIvalue\fP (default 0).  This
action can be used with translations to provide alternate ways of
exiting \fIxmessage\fP.
.TP 8
.B default-exit()
exit immediately with the exit status specified by the default button.
If there is no default button, this action has no effect.
.SH "EXIT STATUS"
If it detects an error, \fIxmessage\fP returns 1, so this value should
not be used with a button.
.SH "SEE ALSO"
.IR X (__miscmansuffix__),
.IR echo (1),
.IR cat (1)
.br
.SH AUTHORS
Chris Peterson, MIT Project Athena 
.br
Stephen Gildea, X Consortium
