/* AbiSource Program Utilities
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_STYLE_LIST_H_
#define _OD_STYLE_LIST_H_

// Internal includes
#include "OD_ListenerState.h"

// AbiWord includes
#include <ut_string_class.h>
#include <ut_vector.h>

// Internal classes
class OD_ListLevelStyle;

// AbiWord classes
class PD_Document;


/**
 * Represents a <text:list-style> element.
 */
class OD_Style_List : public OD_ListenerState {
    
public:

    OD_Style_List(OD_ElementStack& rElementStack) :
		OD_ListenerState("StyleList", rElementStack) {}
                                     
    virtual ~OD_Style_List();
    
    void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                               OD_ListenerStateAction& rAction);
                               
    void endElement (const XML_Char* pName,
                             OD_ListenerStateAction& rAction);
                             
    void charData (const XML_Char* pBuffer, int length);
    
    void defineAbiList(PD_Document* pDocument);

    OD_ListLevelStyle* getLevelStyle(UT_uint32 level) {
        // Levels starts from 1, but our vector starts from 0 (zero).
        return m_levelStyles[level-1];
    }
    
    UT_uint32 getLevelCount() const {return m_levelStyles.getItemCount();}
    
    void buildAbiPropertiesString();

private:
    // style:name attribute
    UT_UTF8String m_name;
    
    // style:display-name attribute
    UT_UTF8String m_displayName;
    
    // text:consecutive-numbering attribute
    bool m_bConsecutiveNumbering;
    
    UT_GenericVector<OD_ListLevelStyle*> m_levelStyles;
};

#endif //_OD_STYLE_LIST_H_
