//
//
//
//
//
//

typedef	unsigned int u_int ;
typedef	unsigned long u_long ;
typedef	unsigned short u_short ;


#ifndef _MEMORY_CS_H
#define	_MEMORY_CS_H
//----------------------------------------------------------------------
//include
//----------------------------------------------------------------------
#include <linux/ioctl.h>

//----------------------------------------------------------------------
//driver version	[100 -> 1.00]
//----------------------------------------------------------------------
#define	DRVIER_VERSION	005

//----------------------------------------------------------------------
//define
//----------------------------------------------------------------------
#define	RESO_256		0			//1: 256 color support 
#define	MEM_SPEED		500			//
#define	BUSY_TIMEOUT	0x10000		//
#define	FIFO_TIMEOUT	0x100		//

//----------------------------------------------------------------------
//ioctl commmand No.
//----------------------------------------------------------------------
#define	CFXGA_MAGIC_NO		'c'
#define	CFXGA_GET_STATUS	_IOR(CFXGA_MAGIC_NO, 1, struct status_t)
#define	CFXGA_GET_RESONUM	_IOR(CFXGA_MAGIC_NO, 2, unsigned int)
#define	CFXGA_GET_RESOINFO	_IOR(CFXGA_MAGIC_NO, 3, struct reso_info_t)
#define	CFXGA_SET_RESO		_IOW(CFXGA_MAGIC_NO, 4, unsigned int)
#define	CFXGA_COPY_FB		_IOW(CFXGA_MAGIC_NO, 5, struct copy_info_t)
#define	CFXGA_COPY_FB2		_IOW(CFXGA_MAGIC_NO, 6, struct copy2_info_t)
#define	CFXGA_CLEAR_SCREEN	 _IO(CFXGA_MAGIC_NO, 7)

//----------------------------------------------------------------------
//structure
//----------------------------------------------------------------------
typedef struct reso_t {
    u_int	cx;		//resolution x
    u_int	cy;		//resolution y
    u_int	ref;	//refresh rate (Hz)
    u_int	bpp;	//color depth (bits/pixel)
    u_int	dclk;	//dot clock (kHz)
    u_int	flags;	//resolution flags
} reso_t;
//resolution flags
#define	MODE_VGA		0x00000001
#define	MODE_NTSC		0x00000002
#define	MODE_PAL		0x00000004
#define	OUT_VGA			0x00000010
#define	OUT_COMPOSITE	0x00000020
#define	OUT_SVIDEO		0x00000040

typedef struct status_t {
	int		version;	//[OUT]	driver version (100 = 1.00)
	int		flags;		//[OUT]	status flags
} status_t;
//status flags
#define	CFXGA_INSTALLED	0x00000001
#define	CFXGA_BUSY		0x00000002

typedef struct reso_info_t {
	u_int	mode_no;	//[IN]	mode no. 
	reso_t	reso;		//[OUT]	resolution infomation
} reso_info_t;

typedef struct copy_info_t {
	int		x;			//[IN]	destnation x org
	int		y;			//[IN]	destnation y org
	int		w;			//[IN]	width
	int		h;			//[IN]	height
	int		bpp;		//[IN]	src bpp
	int		stride;		//[IN]	src screen stride
	void	*adr;		//[IN]	src data start address
} copy_info_t;

typedef struct copy2_info_t {
	int		x;			//[IN]	destnation x org
	int		y;			//[IN]	destnation y org
	int		w;			//[IN]	width
	int		h;			//[IN]	height
	int		bpp;		//[IN]	src bpp
	int		stride;		//[IN]	src screen stride
	u_long	phys_adr;	//[IN]	src screen physical address
	u_long	size;		//[IN]	src screen physical address size (bytes)
	u_long	offset;		//[IN]	src date offset
	u_int	swivel;		//[IN]	swivel level
} copy2_info_t;
#define	SWIVEL_0	0
#define	SWIVEL_90	1


#define	MAX_REG	11
typedef struct DefReso {
	reso_t	reso;
	u_short	reg[MAX_REG * 2];
} DefReso, *pDefReso;


#define	CFXGA_RESONUM	(sizeof(reso_tbl) / sizeof(pDefReso))



#endif	//_MEMORY_CS_H
