#!/usr/bin/env python
#
import gtk,os,getpass,sys
from xml.dom import minidom, Node

class cpuconfig:
	DEF_PAD = 5

	f = open("/proc/deviceinfo/product","r")
	MODEL = f.read()
	f.close()

	MODEL = MODEL.split();

	MODEL = MODEL[0]

	print MODEL
	
	CPU = "Unknown"
	
	if MODEL == "SL-C700":
	    CPU = "PXA250"
	    CCCR_FILE  = "/proc/cccr_change"
	elif (MODEL == "SL-C750") | (MODEL == "SL-C7500"):
	    CPU = "PXA255"
	    CCCR_FILE  = "/proc/cccr_change"
	elif (MODEL == "SL-C760") | (MODEL == "SL-C860"):
	    CPU = "PXA255"
	    CCCR_FILE  = "/proc/cccr_change"
	elif (MODEL == "SL-6000"):
	    CPU = "PXA255"
	    CCCR_FILE  = "/proc/cccr_change"
	elif (MODEL == "SL-C1000") | (MODEL == "SL-C3100") | (MODEL == "SL-C3000"):
	    CPU = "PXA270"
	    CCCR_FILE  = "/proc/zaurus/CCCR"
	    VCORE_FILE = "/proc/zaurus/VCORE"

	if CPU == "PXA270":
	    FREQ_TAB  = ["416", "520", "624"]
	    CCCR_TAB  = ["2000210", "2000214", "2000218"]
	    VCORE_TAB = ["0a", "0c", "0e"]
	elif CPU == "PXA250":
	    FREQ_TAB = ["199", "398", "472"]
	    CCCR_TAB = ["141", "241", "242"]
	elif CPU == "PXA255":
	    FREQ_TAB = ["199", "398", "472"]
	    CCCR_TAB = ["141", "161", "162"]
	    #FREQ_TAB = ["199", "398", "472", "531"]
	    #CCCR_TAB = ["141", "161", "162", "163"]

	CPU_CCCR  = 0
	CPU_VCORE = 0

	if os.name == "nt":
		CFG_FILENAME = ".\\cpuconfig.cfg"
	else:
		CFG_FILENAME = os.environ['HOME'] + "/Choices/cpuconfig.cfg"

	def __init__(self):
		if (getpass.getuser().lower() != "root"):
			Warningdialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"You need to be root in order to run this program.")
			Warningdialog.run()
			Warningdialog.destroy()
			sys.exit()
		self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
	        self.window.set_title("CPU Config")
	        self.window.set_border_width(5)
		self.window.set_position(gtk.WIN_POS_CENTER)
	        self.window.set_resizable(gtk.FALSE)
	        self.window.connect("delete_event", gtk.main_quit)
	        self.window.connect("destroy", gtk.main_quit)

		MainBox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
		self.window.add(MainBox)
		
	        mainframe = gtk.Frame(self.CPU + " (" + self.MODEL + ")")
		MainBox.pack_start(mainframe, gtk.TRUE, gtk.TRUE, self.DEF_PAD)
		
		vbox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
		vbox.set_border_width(self.DEF_PAD)
	        mainframe.add(vbox)

		hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
		vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

		self.freq_menu = gtk.combo_box_new_text()
        	for freq in self.FREQ_TAB:
		    self.freq_menu.append_text(freq)
		
	        self.freq_menu.connect('changed', self.change_freq)
		self.freq_menu.set_size_request(80,30)
		hbox.pack_start(self.freq_menu, gtk.FALSE, gtk.TRUE, 0)

		self.freq_label = gtk.Label("MHz")
		hbox.pack_end(self.freq_label, gtk.TRUE, gtk.TRUE, self.DEF_PAD)

	        bbox = gtk.HButtonBox ()
	        MainBox.pack_start(bbox, gtk.FALSE, gtk.FALSE, 0)
	        bbox.set_layout(gtk.BUTTONBOX_END)

	        cancel_button = gtk.Button("Cancel",gtk.STOCK_CANCEL)
	        cancel_button.connect("clicked", gtk.main_quit)
	        bbox.add(cancel_button)

	        okbutton = gtk.Button("Ok",gtk.STOCK_OK)
	        okbutton.connect("clicked", self.close_and_update)
	        bbox.add(okbutton)
	        okbutton.set_flags(gtk.CAN_DEFAULT)
	        okbutton.grab_default()

		self.load_prefs();

		self.get_sys_freq();

		self.find_freq(self.CPU_FREQ)
		
		self.window.show_all()

	def get_sys_freq(self):
	        f = open(self.CCCR_FILE,"r")
		val = f.read()
		f.close()
		val = val.split();
		val = val[0]
		n = 0
		for cccr in self.CCCR_TAB:
		    if val.find(cccr) != -1:
			self.CPU_FREQ = self.FREQ_TAB[n]
			self.CPU_CCCR = self.CCCR_TAB[n]
			if self.CPU == "PXA270":
			    self.CPU_VCORE = self.VCORE_TAB[n]
			return True
		    else:
			n = n + 1
		return False

	def find_freq(self, data=None):
		n = 0
		for freq in self.FREQ_TAB:
		    if (freq == data):
			self.freq_menu.set_active(n)
			return True
		    else:
			n = n + 1
		self.freq_menu.set_active(0)
		return False

	def change_freq(self, combobox):
		n = combobox.get_active()
		self.CPU_FREQ = self.FREQ_TAB[n]
		self.CPU_CCCR = self.CCCR_TAB[n]
		if self.CPU == "PXA270":
		    self.CPU_VCORE = self.VCORE_TAB[n]
		return True

	def close_and_update(self,widget):
		self.save_prefs()
		#print self.CPU
		#print self.CPU_FREQ
		#print self.CPU_CCCR
		#if self.CPU == "PXA270":
		#    print self.CPU_VCORE
		    
		if self.CPU == "PXA270":
		    self.write_val(self.VCORE_FILE, self.CPU_VCORE);
		self.write_val(self.CCCR_FILE, self.CPU_CCCR);
		gtk.main_quit()

	def write_val(self, file, val):
		try:
		    f = open(file, "w");
		    f.write(val);
		    f.close();
		except IOError:
		    return False
		return True

	def load_prefs(self):
		if os.path.isfile(self.CFG_FILENAME):
			try:
				xmldoc = minidom.parse(self.CFG_FILENAME)
			except:
				return False
			else:
				tags = xmldoc.getElementsByTagName("CPUCONFIGSETTINGS");
				for tag in tags:			
					usbtypes = tag.getElementsByTagName("FREQ")
					for usbtype in usbtypes:
						self.CPU_FREQ = usbtype.getAttribute("freq")
						
				return True
		else:
			return False

	def save_prefs(self,widget=None):
		conf_tree = minidom.Document()
		conf_tree.appendChild(conf_tree.createComment("pdaXrom settings file"))
		root_node = conf_tree.createElement("CPUCONFIGSETTINGS")

		node = conf_tree.createElement("FREQ")
		node.setAttribute("freq", self.CPU_FREQ)
		root_node.appendChild(node)

		conf_tree.appendChild(root_node)
		FD = open(self.CFG_FILENAME, "w")
		FD.write(conf_tree.toprettyxml())
		FD.close()

	def main(self):
		gtk.main()

if __name__ == "__main__":
	cpuconfig = cpuconfig()
	cpuconfig.main()
	
