
/* pdfdocument.h: Implementation of EvDocument for tiffs
 * Copyright (C) 2005, Jonathan Blandford <jrb@gnome.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFF_DOCUMENT_H__
#define __TIFF_DOCUMENT_H__

#include "ev-document.h"

G_BEGIN_DECLS

#define TIFF_TYPE_DOCUMENT             (tiff_document_get_type ())
#define TIFF_DOCUMENT(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), TIFF_TYPE_DOCUMENT, TiffDocument))
#define TIFF_IS_DOCUMENT(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TIFF_TYPE_DOCUMENT))

typedef struct _TiffDocument TiffDocument;

TiffDocument *tiff_document_new      (void);
GType         tiff_document_get_type (void) G_GNUC_CONST;
     
G_END_DECLS

#endif /* __TIFF_DOCUMENT_H__ */
