//
// "$Id: ValueInput.h,v 1.3 2003/04/20 03:17:49 easysw Exp $"
//
// Text field for inputing a floating-point number
//
// Copyright 1998-2003 by Bill Spitzak and others.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
// Please report all bugs and problems to "fltk-bugs@fltk.org".
//

#ifndef fltk_ValueInput_h
#define fltk_ValueInput_h

#include "Valuator.h"
#include "FloatInput.h"

namespace fltk {

class FL_API ValueInput : public Valuator {
public:
  FloatInput input;

  int handle(int);
  void draw();
  ValueInput(int x,int y,int w,int h,const char *l=0);
  ~ValueInput();

protected:
  void layout();

private:
  virtual void value_damage(); // cause damage() due to value() changing
  static void input_cb(Widget*,void*);
  void increment_cb();
  static void repeat_callback(void* v);
};

}
#endif

//
// End of "$Id: ValueInput.h,v 1.3 2003/04/20 03:17:49 easysw Exp $".
//
