/*
 * gdict Dictionary for UNIX
 * Copyright (C) 2003 Alexander Zapjagaev <frustum@frustum.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "menu.h"

static gchar *menu_translate(const gchar *str,gpointer data) {
#ifdef ENABLE_NLS
	return gettext(str);
#else
	return str;
#endif
}

GtkWidget *menubar_create(GtkWidget *window,GtkItemFactoryEntry *entries,int num,char *path,void *data) {
	GtkItemFactory *factory;
	GtkAccelGroup *accel;
	
	accel = gtk_accel_group_new();
	factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR,path,accel);
	gtk_item_factory_set_translate_func(factory,menu_translate,NULL,NULL);
	
	gtk_item_factory_create_items(factory,num,entries,data);
	gtk_window_add_accel_group(GTK_WINDOW(window),accel);
	
	return gtk_item_factory_get_widget(factory,path);
}

GtkWidget *menuitem_create(GtkItemFactoryEntry *entries,int num,char *path,void *data) {
	GtkItemFactory *factory;
	
	factory = gtk_item_factory_new(GTK_TYPE_MENU,path,NULL);
	gtk_item_factory_set_translate_func(factory,menu_translate,NULL,NULL);
	
	gtk_item_factory_create_items(factory,num,entries,data);
	
	return gtk_item_factory_get_widget(factory,path);
}
