/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"

#include <sys/time.h>
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

GtkWidget *GPE_Alarm;

gint do_update_datetime(gpointer udata)
{
static GtkWidget *CurDateTime;

	CurDateTime=lookup_widget(GPE_Alarm, "PseudoMain");
	if (gtk_notebook_get_current_page(GTK_NOTEBOOK(CurDateTime)) == 0) {
		struct timeval mytv;
		struct tm *mytm;
		static char tstr[64]="";

		gettimeofday(&mytv, NULL);
		mytm=localtime(&mytv.tv_sec);
		strcpy(tstr,asctime(mytm));
		tstr[strlen(tstr)-1]='\0';
		CurDateTime=lookup_widget(GTK_WIDGET(udata),"CurDateTime");
		gtk_label_set_text(GTK_LABEL(CurDateTime),tstr);
	}

return 1;
}

int main (int argc, char *argv[])
{
GtkWidget *widget;

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
#endif

	g_thread_init(NULL);

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
	add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");
	add_pixmap_directory ("/usr/share/gpe-alarm/pixmaps");

	gtk_rc_parse("/usr/share/gpe-alarm/gpe-alarm.gtkrc");

	/*
	 * The following code was added by Glade to create one of each component
	 * (except popup menus), just so that you see something after building
	 * the project. Delete any components that you don't want shown initially.
	 */
	GPE_Alarm = create_GPE_Alarm ();
	signal(SIGUSR1, SIG_IGN);
	gtk_timeout_add(1000,do_update_datetime,GPE_Alarm);

	do_update_datetime(GPE_Alarm);
	
	widget=lookup_widget(GPE_Alarm,"AlarmEdit");
	gtk_widget_set_sensitive(widget,FALSE);
	widget=lookup_widget(GPE_Alarm,"AlarmDelete");
	gtk_widget_set_sensitive(widget,FALSE);
	widget=lookup_widget(GPE_Alarm,"AlarmCList");
	gtk_clist_set_sort_column(GTK_CLIST(widget), 0);
	gtk_clist_set_sort_type(GTK_CLIST(widget), GTK_SORT_ASCENDING);
	gtk_clist_column_titles_passive(GTK_CLIST(widget));
	widget=lookup_widget(GPE_Alarm,"AlarmType");
	gtk_signal_connect (GTK_OBJECT (GTK_OPTION_MENU (widget)->menu),
	                      "deactivate", GTK_SIGNAL_FUNC (on_AlarmType_selected),
	                      NULL);

	widget=lookup_widget(GPE_Alarm,"MainMenu");
	gtk_widget_hide(widget);

	signal(SIGUSR1, RTCD_sighandler);

	insert_rtcd_alarms();

	gtk_widget_show (GPE_Alarm);

	gtk_main ();

return 0;
}
