/******************************************************************************
//             INTEL CORPORATION PROPRIETARY INFORMATION
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Intel Corporation and may not be copied
//  or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2001 Intel Corporation. All Rights Reserved.
//
//  VSS: 
//		$Workfile: signal.c $
//		$Revision: 1 $
//		$Date: 03-09-10 17:22 $
//
//  Description:
//		IPP sine generation example
******************************************************************************/

/* Standard IPP definitions */
#include <ippdefs.h>
#include <ippSP.h>

/* Sine generator interface */
#include "signal.h"

/* Fixed sinusoidal parameters */
#define		MAG				32767					/* ~1, Q15 */
#define		PHASE			0						/* 0, Q15 */

/* State variables */
int g_SignalType=0;						/* Signal type, 0=tone, 1=tri, 2=Gaussian */
Ipp16s g_frqQ15;						/* Frequency */
IppToneState_16s g_SineState;			/* Tone generator state */
IppTriangleState_16s g_TriState;		/* Triangle generator state */
IppRandGaussState_16s g_NoiseState;		/* Noise generator state */

/* Adjust frequency */
void SetFrequency(Ipp16s frequency, int SampleRate)
{
	Ipp32s tmp;
	tmp=(frequency<<14)/(SampleRate/2);
	g_frqQ15=tmp;
	ippsToneInitQ15_16s(&g_SineState, MAG, g_frqQ15, PHASE);
	ippsTriangleInitQ15_16s(&g_TriState, MAG, g_frqQ15, PHASE, 0);
}

/* Set noise standard deviation */
void SetStdDev(Ipp16s sigma)
{
	/* Establish 0-mean, 0 seed */
	ippsRandGaussInit_16s(&g_NoiseState,0,sigma,0);
}

/* Generate signal */
void GenerateSignal(Ipp16s *buf, int len)
{
	switch(g_SignalType)
	{
		case TONE:
			ippsToneQ15_16s(buf,len,&g_SineState);
			break;
		case TRI:
			ippsTriangleQ15_16s(buf,len,&g_TriState);
			break;
		case NOISE:
			ippsRandGauss_16s(buf,len,&g_NoiseState);
			break;
	}
}

/* Select sinusoid, triangle, or Gaussian noise */
void SetSignalType(int type)
{
	g_SignalType=type;
}

