// CHANGED 2004-08-06 Lutz Rogowski
#include "mailistviewitem.h"
#include <libmailwrapper/abstractmail.h>
#include <qtextstream.h>
#include <kiconloader.h>
//#include <qpe/resource.h>

MailListViewItem::MailListViewItem(QListView * parent, MailListViewItem * item )
        :QListViewItem(parent,item),mail_data()
{
}

void MailListViewItem::showEntry()
{
    if ( mail_data->getFlags().testBit( FLAG_ANSWERED ) == true) {
        setPixmap( 0, SmallIcon ( "kmmsgreplied") );
    } else if ( mail_data->getFlags().testBit( FLAG_SEEN ) == true )  {
        /* I think it looks nicer if there are not such a log of icons but only on mails
           replied or new - Alwin*/ 
        //setPixmap( 0,SmallIcon ("kmmsgunseen") );
    } else  {
        setPixmap( 0,SmallIcon ( "kmmsgnew") );
    }
    double s = mail_data->Msgsize();
    int w = 0;
    s/=1024;
    if (s>999.0) {
        s/=1024.0;
        ++w;
    }
    QString fsort;
    fsort.sprintf( "%.2f", s );
    QString fsize = QString::number( s, 'f', 2 );
    //  1.23
    // 11.23
    // 111.23
    // 999.23 maxlen
    switch(fsize.length() ) {
    case 4:
        fsort = "00" + fsize ;
        break;
    case 5:
        fsort = "0" + fsize ;
        break;
    default:
        fsort = fsize ;
    break;
    
    }
    if ( w == 0 ) {
        setText(3, fsize + "kB" );
        mKeyMap.insert(3, "k" + fsort);
        //setText(3, "kB" + fsort ); // test only
    } else {
        //setText(3, fsize + "MB");
        mKeyMap.insert(3, "M" +fsort );
    }
    setText(1,mail_data->getSubject());
    setText(2,mail_data->getFrom());
#if 0    
    QString date = mail_data->getDate();
    
    int kom = date.find( ",")+2;
    if ( kom == 1 )
    kom = 0;
    if (  date.mid(kom,1) == " ")
        ++kom;
    if ( date.mid(kom+1,1) == " " )
        date =  "0" + date.mid( kom ); 
    else if ( kom )
        date =  date.mid( kom ); 
    if ( kom || date.mid(2,1 ) == " ") {
        QString mon = date.mid(3,3);
        QString so = 00;
        if ( mon == "Jan" )
            so = "01";
        else if ( mon == "Feb" )
            so = "02";
        else if ( mon == "Mar" )
            so = "03";
        else if ( mon == "Apr" )
            so = "04";
        else if ( mon == "May" )
            so = "05";
        else if ( mon == "Jun" )
            so = "06";
        else if ( mon == "Jul" )
            so = "07";
        else if ( mon == "Aug" )
            so = "08";
        else if ( mon == "Sep" )
            so = "09";
        else if ( mon == "Oct" )
            so = "10";
        else if ( mon == "Nov" )
            so = "11";
        else if ( mon == "Dec" )
            so = "12";
        date = date.mid(7,4)+so+date.left(2)+date.mid(12,14);
    }
    //qDebug("insert Date %s ", date.latin1());
    // if ( date.left(1) != "1" || date.left(1) != "2" )
    //  date = date.mid(5);
    mKeyMap.insert(4,date);
#endif
    mKeyMap.insert(4,mail_data->getIsoDate());
    setText(4,mail_data->getDate());
}

void MailListViewItem::storeData(const RecMailP&data)
{
    mail_data = data;
}
void MailListViewItem::setSortKey(int column,const QString &key)
{
    mKeyMap.insert(column,key);
}
QString MailListViewItem::key(int column, bool) const
{
    // to make is fast, we use here special cases
    if ( column == 3  ||  column == 4 ) {
        return *mKeyMap.find(column);
    }
    if ( column == 1 ) {
        if ( text(1).left(4).lower() == "re: " )
            return text(1).mid(4);

    }
    return text(column);
    /*
    QMap<int,QString>::ConstIterator it = mKeyMap.find(column);
    if (it == mKeyMap.end()) return text(column);
    else return *it;
    */
}

const RecMailP& MailListViewItem::data()const
{
    return mail_data;
}

MAILLIB::ATYPE MailListViewItem::wrapperType()
{
    if (!mail_data->Wrapper()) return MAILLIB::A_UNDEFINED;
    return mail_data->Wrapper()->getType();
}
