#include <stdio.h>
#include <libgen.h>
#include <getopt.h>

#include <qpe/qpeapplication.h>

#include <qtimer.h>

#include "ZdbManager.h"

enum MODE {
	MODE_INFO,
	MODE_READ,
	MODE_WRITE,
	MODE_DELETE,
};

char _version_[] =
#include "version.txt"
;

void printUsage(char* cmd)
{
	printf("--- Zaurus DataBase Access Tool version %s ---\n", _version_);
	printf("Usage: %s TYPE [-i|-r [-f FIELDS] [-n CARDID]|-w [-g]|-d] [-s SYSTEM FIELDS] [-b BASEDIR] [-c CODEC] [-h]\n", cmd);
	printf("       TYPE    database type\n");
	printf("                 address  : AddressBook\n");
	printf("                 todo     : ToDo\n");
	printf("                 datebook : DateBook\n");
	printf("                 inbox    : MailInbox\n");
	printf("                 outbox   : MailOutbox\n");
	printf("                 memo     : Memo\n");
	printf("       -i      show record information(default)\n");
	printf("       -r      read records\n");
	printf("         -f     database fields list(CSV)\n");
	printf("         -n     number of cardid\n");
	printf("       -w      write records\n");
	printf("         -g     add undefined category\n");
	printf("       -d      delete records\n");
	printf("       -s      database system fields list(CSV)\n");
	printf("       -b      set base directory\n");
	printf("       -c      set text codec\n");
	printf("                 eucJP(default) ShiftJIS utf8 ...\n");
	printf("       -h      print this help\n");
	return;
}

int main(int argc, char* argv[])
{
	QString type;
	QString basedir;
	int mode = MODE_INFO;

	QString fields;
	QString sysfields;
	QString codec;
	QString cardid;
	bool isReadOnly = true;
	bool addCategory = false;

	int c;
	while((c = getopt(argc, argv, ":t:b:f:s:c:n:rwdigh")) != -1){
		switch(c){
		case 'h':
			printUsage(basename(argv[0]));
			return 0;
		case 'b':
			basedir = optarg;
			break;
		case 'f':
			fields = optarg;
			break;
		case 's':
			sysfields = optarg;
			break;
		case 'c':
			codec = optarg;
			break;
		case 'n':
			cardid = optarg;
			break;
		case 'i':
			mode = MODE_INFO;
			break;
		case 'g':
			addCategory = true;
			break;
		case 'r':
			mode = MODE_READ;
			break;
		case 'w':
			mode = MODE_WRITE;
			isReadOnly = false;
			break;
		case 'd':
			mode = MODE_DELETE;
			isReadOnly = false;
			break;
		default:
			break;
		}
	}

	if(optind < argc){
		type = argv[optind];
	} else {
		printUsage(basename(argv[0]));
		return 1;
	}

	ZdbManager zdb;
	if(!sysfields.isEmpty()){
		zdb.setSysFields(sysfields);
	}

	int rc = 0;

	if(zdb.init(type, basedir, isReadOnly)){
		zdb.setCodec(codec);
		switch(mode){
		case MODE_INFO:
			rc = zdb.doInfo();
			break;
		case MODE_READ:
			zdb.setFields(fields);
			if(cardid){
				rc = zdb.doRead(cardid.toULong());
			} else {
				rc = zdb.doRead();
			}
			break;
		case MODE_WRITE:
			zdb.setCategoryAddEnable(addCategory);
			rc = zdb.doWrite();
			break;
		case MODE_DELETE:
			rc = zdb.doDelete();
			break;
		}
	}

	return rc;
}
